/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AsyncRepairCallback;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.RowDataResolver;
import org.apache.cassandra.service.RowDigestResolver;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCallback<TMessage, TResolved>
implements IAsyncCallback<TMessage> {
    protected static final Logger logger = LoggerFactory.getLogger(ReadCallback.class);
    public final IResponseResolver<TMessage, TResolved> resolver;
    private final SimpleCondition condition = new SimpleCondition();
    private final long startTime;
    private final int blockfor;
    final List<InetAddress> endpoints;
    private final IReadCommand command;
    private final ConsistencyLevel consistencyLevel;
    private final AtomicInteger received = new AtomicInteger(0);
    private final Table table;

    public ReadCallback(IResponseResolver<TMessage, TResolved> resolver, ConsistencyLevel consistencyLevel, IReadCommand command, List<InetAddress> filteredEndpoints) {
        this(resolver, consistencyLevel, consistencyLevel.blockFor(Table.open(command.getKeyspace())), command, Table.open(command.getKeyspace()), filteredEndpoints);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Blockfor is %s; setting up requests to %s", this.blockfor, StringUtils.join(this.endpoints, (String)",")));
        }
    }

    private ReadCallback(IResponseResolver<TMessage, TResolved> resolver, ConsistencyLevel consistencyLevel, int blockfor, IReadCommand command, Table table, List<InetAddress> endpoints) {
        this.command = command;
        this.table = table;
        this.blockfor = blockfor;
        this.consistencyLevel = consistencyLevel;
        this.resolver = resolver;
        this.startTime = System.currentTimeMillis();
        this.endpoints = endpoints;
    }

    public ReadCallback<TMessage, TResolved> withNewResolver(IResponseResolver<TMessage, TResolved> newResolver) {
        return new ReadCallback<TMessage, TResolved>(newResolver, this.consistencyLevel, this.blockfor, this.command, this.table, this.endpoints);
    }

    public TResolved get() throws ReadTimeoutException, DigestMismatchException, IOException {
        boolean success;
        long timeout = this.command.getTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            throw new ReadTimeoutException(this.consistencyLevel, this.received.get(), this.blockfor, this.resolver.isDataPresent());
        }
        return this.blockfor == 1 ? this.resolver.getData() : this.resolver.resolve();
    }

    @Override
    public void response(MessageIn<TMessage> message) {
        int n;
        this.resolver.preprocess(message);
        int n2 = n = this.waitingFor(message) ? this.received.incrementAndGet() : this.received.get();
        if (n >= this.blockfor && this.resolver.isDataPresent()) {
            this.condition.signal();
            this.maybeResolveForRepair();
        }
    }

    private boolean waitingFor(MessageIn message) {
        return this.consistencyLevel == ConsistencyLevel.LOCAL_QUORUM ? DatabaseDescriptor.getLocalDataCenter().equals(DatabaseDescriptor.getEndpointSnitch().getDatacenter(message.from)) : true;
    }

    public void response(TMessage result) {
        MessageIn<TMessage> message = MessageIn.create(FBUtilities.getBroadcastAddress(), result, Collections.<String, byte[]>emptyMap(), MessagingService.Verb.INTERNAL_RESPONSE, 6);
        this.response((TMessage)message);
    }

    protected void maybeResolveForRepair() {
        if (this.blockfor < this.endpoints.size() && this.received.get() == this.endpoints.size()) {
            assert (this.resolver.isDataPresent());
            StageManager.getStage(Stage.READ_REPAIR).execute(new AsyncRepairRunner());
        }
    }

    public void assureSufficientLiveNodes() throws UnavailableException {
        this.consistencyLevel.assureSufficientLiveNodes(this.table, this.endpoints);
    }

    @Override
    public boolean isLatencyForSnitch() {
        return true;
    }

    private class AsyncRepairRunner
    extends WrappedRunnable {
        private AsyncRepairRunner() {
        }

        @Override
        protected void runMayThrow() throws IOException {
            try {
                ReadCallback.this.resolver.resolve();
            }
            catch (DigestMismatchException e) {
                assert (ReadCallback.this.resolver instanceof RowDigestResolver);
                if (logger.isDebugEnabled()) {
                    logger.debug("Digest mismatch:", (Throwable)e);
                }
                ReadCommand readCommand = (ReadCommand)ReadCallback.this.command;
                RowDataResolver repairResolver = new RowDataResolver(readCommand.table, readCommand.key, readCommand.filter());
                AsyncRepairCallback repairHandler = new AsyncRepairCallback(repairResolver, ReadCallback.this.endpoints.size());
                MessageOut<ReadCommand> message = ((ReadCommand)ReadCallback.this.command).createMessage();
                for (InetAddress endpoint : ReadCallback.this.endpoints) {
                    MessagingService.instance().sendRR(message, endpoint, repairHandler);
                }
            }
        }
    }
}

