/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.thrift.ColumnParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriedSliceFromReadCommand
extends SliceFromReadCommand {
    static final Logger logger = LoggerFactory.getLogger(RetriedSliceFromReadCommand.class);
    public final int originalCount;

    public RetriedSliceFromReadCommand(String table, ByteBuffer key, ColumnParent column_parent, SliceQueryFilter filter, int originalCount) {
        this(table, key, new QueryPath(column_parent), filter, originalCount);
    }

    public RetriedSliceFromReadCommand(String table, ByteBuffer key, QueryPath path, SliceQueryFilter filter, int originalCount) {
        super(table, key, path, filter);
        this.originalCount = originalCount;
    }

    @Override
    public ReadCommand copy() {
        RetriedSliceFromReadCommand readCommand = new RetriedSliceFromReadCommand(this.table, this.key, this.queryPath, this.filter, this.originalCount);
        readCommand.setDigestQuery(this.isDigestQuery());
        return readCommand;
    }

    @Override
    public int getOriginalRequestedCount() {
        return this.originalCount;
    }

    @Override
    public String toString() {
        return "RetriedSliceFromReadCommand(cmd=" + super.toString() + ", originalCount=" + this.originalCount + ")";
    }
}

