/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilySerializer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.ISSTableColumnIterator;
import org.apache.cassandra.db.columniterator.SimpleAbstractColumnIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.IFilter;

public class SSTableNamesIterator
extends SimpleAbstractColumnIterator
implements ISSTableColumnIterator {
    private ColumnFamily cf;
    private final SSTableReader sstable;
    private FileDataInput fileToClose;
    private Iterator<OnDiskAtom> iter;
    public final SortedSet<ByteBuffer> columns;
    public final DecoratedKey key;

    public SSTableNamesIterator(SSTableReader sstable, DecoratedKey key, SortedSet<ByteBuffer> columns) {
        assert (columns != null);
        this.sstable = sstable;
        this.columns = columns;
        this.key = key;
        RowIndexEntry indexEntry = sstable.getPosition(key, SSTableReader.Operator.EQ);
        if (indexEntry == null) {
            return;
        }
        try {
            this.read(sstable, null, indexEntry);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, sstable.getFilename());
        }
        finally {
            if (this.fileToClose != null) {
                FileUtils.closeQuietly(this.fileToClose);
            }
        }
    }

    public SSTableNamesIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, SortedSet<ByteBuffer> columns, RowIndexEntry indexEntry) {
        assert (columns != null);
        this.sstable = sstable;
        this.columns = columns;
        this.key = key;
        try {
            this.read(sstable, file, indexEntry);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, sstable.getFilename());
        }
    }

    private FileDataInput createFileDataInput(long position) {
        this.fileToClose = this.sstable.getFileDataInput(position);
        return this.fileToClose;
    }

    @Override
    public SSTableReader getSStable() {
        return this.sstable;
    }

    private void read(SSTableReader sstable, FileDataInput file, RowIndexEntry indexEntry) throws IOException {
        List<IndexHelper.IndexInfo> indexList;
        IFilter bf;
        if (!indexEntry.isIndexed()) {
            if (file == null) {
                file = this.createFileDataInput(indexEntry.position);
            } else {
                file.seek(indexEntry.position);
            }
            DecoratedKey keyInDisk = SSTableReader.decodeKey(sstable.partitioner, sstable.descriptor, ByteBufferUtil.readWithShortLength(file));
            assert (keyInDisk.equals(this.key)) : String.format("%s != %s in %s", keyInDisk, this.key, file.getPath());
            SSTableReader.readRowSize(file, sstable.descriptor);
        }
        if (sstable.descriptor.version.hasPromotedIndexes) {
            bf = indexEntry.isIndexed() ? indexEntry.bloomFilter() : null;
            indexList = indexEntry.columnsIndex();
        } else {
            assert (file != null);
            bf = IndexHelper.defreezeBloomFilter(file, sstable.descriptor.version.filterType);
            indexList = IndexHelper.deserializeIndex(file);
        }
        if (!indexEntry.isIndexed()) {
            ColumnFamilySerializer serializer = ColumnFamily.serializer;
            try {
                this.cf = ColumnFamily.create(sstable.metadata);
                this.cf.delete(DeletionInfo.serializer().deserializeFromSSTable(file, sstable.descriptor.version));
            }
            catch (Exception e) {
                throw new IOException(serializer + " failed to deserialize " + sstable.getColumnFamilyName() + " with " + sstable.metadata + " from " + file, e);
            }
        } else {
            this.cf = ColumnFamily.create(sstable.metadata);
            this.cf.delete(indexEntry.deletionInfo());
        }
        ArrayList<OnDiskAtom> result = new ArrayList<OnDiskAtom>();
        ArrayList<ByteBuffer> filteredColumnNames = new ArrayList<ByteBuffer>(this.columns.size());
        for (ByteBuffer name : this.columns) {
            if (bf != null && !bf.isPresent(name)) continue;
            filteredColumnNames.add(name);
        }
        if (filteredColumnNames.isEmpty()) {
            return;
        }
        if (indexList.isEmpty()) {
            this.readSimpleColumns(file, this.columns, filteredColumnNames, result);
        } else {
            long basePosition;
            if (sstable.descriptor.version.hasPromotedIndexes) {
                basePosition = indexEntry.position;
            } else {
                assert (file != null);
                file.readInt();
                basePosition = file.getFilePointer();
            }
            this.readIndexedColumns(sstable.metadata, file, this.columns, filteredColumnNames, indexList, basePosition, result);
        }
        this.iter = result.iterator();
    }

    private void readSimpleColumns(FileDataInput file, SortedSet<ByteBuffer> columnNames, List<ByteBuffer> filteredColumnNames, List<OnDiskAtom> result) throws IOException {
        OnDiskAtom.Serializer atomSerializer = this.cf.getOnDiskSerializer();
        int columns = file.readInt();
        int n = 0;
        for (int i = 0; i < columns; ++i) {
            OnDiskAtom column = atomSerializer.deserializeFromSSTable(file, this.sstable.descriptor.version);
            if (column instanceof IColumn) {
                if (!columnNames.contains(column.name())) continue;
                result.add(column);
                if (n++ <= filteredColumnNames.size()) continue;
                break;
            }
            result.add(column);
        }
    }

    private void readIndexedColumns(CFMetaData metadata, FileDataInput file, SortedSet<ByteBuffer> columnNames, List<ByteBuffer> filteredColumnNames, List<IndexHelper.IndexInfo> indexList, long basePosition, List<OnDiskAtom> result) throws IOException {
        AbstractType<?> comparator = metadata.comparator;
        ArrayList<IndexHelper.IndexInfo> ranges = new ArrayList<IndexHelper.IndexInfo>();
        int lastIndexIdx = -1;
        for (ByteBuffer name : filteredColumnNames) {
            int index = IndexHelper.indexFor(name, indexList, comparator, false, lastIndexIdx);
            if (index < 0 || index == indexList.size()) continue;
            IndexHelper.IndexInfo indexInfo = indexList.get(index);
            if (comparator.compare(name, indexInfo.firstName) < 0 || index == lastIndexIdx) continue;
            ranges.add(indexInfo);
            lastIndexIdx = index;
        }
        if (ranges.isEmpty()) {
            return;
        }
        for (IndexHelper.IndexInfo indexInfo : ranges) {
            long positionToSeek = basePosition + indexInfo.offset;
            if (file == null) {
                file = this.createFileDataInput(positionToSeek);
            }
            OnDiskAtom.Serializer atomSerializer = this.cf.getOnDiskSerializer();
            file.seek(positionToSeek);
            FileMark mark = file.mark();
            while (file.bytesPastMark(mark) < indexInfo.width) {
                OnDiskAtom column = atomSerializer.deserializeFromSSTable(file, this.sstable.descriptor.version);
                if (column instanceof IColumn && !columnNames.contains(column.name())) continue;
                result.add(column);
            }
        }
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.cf;
    }

    protected OnDiskAtom computeNext() {
        if (this.iter == null || !this.iter.hasNext()) {
            return (OnDiskAtom)this.endOfData();
        }
        return this.iter.next();
    }
}

