/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceQueryPager;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table {
    public static final String SYSTEM_KS = "system";
    private static final Logger logger = LoggerFactory.getLogger(Table.class);
    public static final ReentrantReadWriteLock switchLock = new ReentrantReadWriteLock();
    public final String name;
    private final ConcurrentMap<UUID, ColumnFamilyStore> columnFamilyStores = new ConcurrentHashMap<UUID, ColumnFamilyStore>();
    private final Object[] indexLocks;
    private volatile AbstractReplicationStrategy replicationStrategy;
    public static final Function<String, Table> tableTransformer;

    public static Table open(String table) {
        return Table.open(table, Schema.instance, true);
    }

    public static Table openWithoutSSTables(String table) {
        return Table.open(table, Schema.instance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Table open(String table, Schema schema, boolean loadSSTables) {
        Table tableInstance = schema.getTableInstance(table);
        if (tableInstance != null) return tableInstance;
        Class<Table> clazz = Table.class;
        synchronized (Table.class) {
            tableInstance = schema.getTableInstance(table);
            if (tableInstance != null) return tableInstance;
            tableInstance = new Table(table, loadSSTables);
            schema.storeTableInstance(tableInstance);
            for (ColumnFamilyStore cfs : tableInstance.getColumnFamilyStores()) {
                cfs.initRowCache();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return tableInstance;
        }
    }

    public static Table clear(String table) throws IOException {
        return Table.clear(table, Schema.instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table clear(String table, Schema schema) throws IOException {
        Class<Table> clazz = Table.class;
        synchronized (Table.class) {
            Table t = schema.removeTableInstance(table);
            if (t != null) {
                for (ColumnFamilyStore cfs : t.getColumnFamilyStores()) {
                    t.unloadCf(cfs);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return t;
        }
    }

    public static void removeUnreadableSSTables(File directory) {
        for (Table table : Table.all()) {
            for (ColumnFamilyStore baseCfs : table.getColumnFamilyStores()) {
                for (ColumnFamilyStore cfs : baseCfs.concatWithIndexes()) {
                    cfs.maybeRemoveUnreadableSSTables(directory);
                }
            }
        }
    }

    public Collection<ColumnFamilyStore> getColumnFamilyStores() {
        return Collections.unmodifiableCollection(this.columnFamilyStores.values());
    }

    public ColumnFamilyStore getColumnFamilyStore(String cfName) {
        UUID id = Schema.instance.getId(this.name, cfName);
        if (id == null) {
            throw new IllegalArgumentException(String.format("Unknown table/cf pair (%s.%s)", this.name, cfName));
        }
        return this.getColumnFamilyStore(id);
    }

    public ColumnFamilyStore getColumnFamilyStore(UUID id) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(id);
        if (cfs == null) {
            throw new IllegalArgumentException("Unknown CF " + id);
        }
        return cfs;
    }

    public void snapshot(String snapshotName, String columnFamilyName) throws IOException {
        assert (snapshotName != null);
        boolean tookSnapShot = false;
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            if (columnFamilyName != null && !cfStore.columnFamily.equals(columnFamilyName)) continue;
            tookSnapShot = true;
            cfStore.snapshot(snapshotName);
        }
        if (columnFamilyName != null && !tookSnapShot) {
            throw new IOException("Failed taking snapshot. Column family " + columnFamilyName + " does not exist.");
        }
    }

    public static String getTimestampedSnapshotName(String clientSuppliedName) {
        String snapshotName = Long.toString(System.currentTimeMillis());
        if (clientSuppliedName != null && !clientSuppliedName.equals("")) {
            snapshotName = snapshotName + "-" + clientSuppliedName;
        }
        return snapshotName;
    }

    public boolean snapshotExists(String snapshotName) {
        assert (snapshotName != null);
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            if (!cfStore.snapshotExists(snapshotName)) continue;
            return true;
        }
        return false;
    }

    public void clearSnapshot(String snapshotName) {
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            cfStore.clearSnapshot(snapshotName);
        }
    }

    public List<SSTableReader> getAllSSTables() {
        ArrayList<SSTableReader> list = new ArrayList<SSTableReader>(this.columnFamilyStores.size());
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            list.addAll(cfStore.getSSTables());
        }
        return list;
    }

    private Table(String table, boolean loadSSTables) {
        this.name = table;
        KSMetaData ksm = Schema.instance.getKSMetaData(table);
        assert (ksm != null) : "Unknown keyspace " + table;
        try {
            this.createReplicationStrategy(ksm);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.indexLocks = new Object[DatabaseDescriptor.getConcurrentWriters() * 128];
        for (int i = 0; i < this.indexLocks.length; ++i) {
            this.indexLocks[i] = new Object();
        }
        for (CFMetaData cfm : new ArrayList<CFMetaData>(Schema.instance.getTableDefinition(table).cfMetaData().values())) {
            logger.debug("Initializing {}.{}", (Object)this.name, (Object)cfm.cfName);
            this.initCf(cfm.cfId, cfm.cfName, loadSSTables);
        }
    }

    public void createReplicationStrategy(KSMetaData ksm) throws ConfigurationException {
        if (this.replicationStrategy != null) {
            StorageService.instance.getTokenMetadata().unregister(this.replicationStrategy);
        }
        this.replicationStrategy = AbstractReplicationStrategy.createReplicationStrategy(ksm.name, ksm.strategyClass, StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), ksm.strategyOptions);
    }

    public void dropCf(UUID cfId) throws IOException {
        assert (this.columnFamilyStores.containsKey(cfId));
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.remove(cfId);
        if (cfs == null) {
            return;
        }
        this.unloadCf(cfs);
    }

    private void unloadCf(ColumnFamilyStore cfs) throws IOException {
        try {
            cfs.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        cfs.invalidate();
    }

    public void initCf(UUID cfId, String cfName, boolean loadSSTables) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(cfId);
        if (cfs == null) {
            ColumnFamilyStore oldCfs = this.columnFamilyStores.putIfAbsent(cfId, ColumnFamilyStore.createColumnFamilyStore(this, cfName, loadSSTables));
            if (oldCfs != null) {
                throw new IllegalStateException("added multiple mappings for cf id " + cfId);
            }
        } else {
            assert (cfs.getColumnFamilyName().equals(cfName));
            cfs.metadata.reload();
            cfs.reload();
        }
    }

    public Row getRow(QueryFilter filter) {
        ColumnFamilyStore cfStore = this.getColumnFamilyStore(filter.getColumnFamilyName());
        ColumnFamily columnFamily = cfStore.getColumnFamily(filter);
        return new Row(filter.key, columnFamily);
    }

    public void apply(RowMutation mutation, boolean writeCommitLog) {
        this.apply(mutation, writeCommitLog, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(RowMutation mutation, boolean writeCommitLog, boolean updateIndexes) {
        if (!mutation.getTable().equals("system_traces")) {
            Tracing.trace("Acquiring switchLock read lock");
        }
        switchLock.readLock().lock();
        try {
            if (writeCommitLog) {
                Tracing.trace("Appending to commitlog");
                CommitLog.instance.add(mutation);
            }
            DecoratedKey key = StorageService.getPartitioner().decorateKey(mutation.key());
            for (ColumnFamily cf : mutation.getColumnFamilies()) {
                ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(cf.id());
                if (cfs == null) {
                    logger.error("Attempting to mutate non-existant column family " + cf.id());
                    continue;
                }
                Tracing.trace("Adding to {} memtable", cf.metadata().cfName);
                cfs.apply(key, cf, updateIndexes ? cfs.indexManager.updaterFor(key, true) : SecondaryIndexManager.nullUpdater);
            }
        }
        finally {
            switchLock.readLock().unlock();
        }
    }

    public AbstractReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void indexRow(DecoratedKey key, ColumnFamilyStore cfs, Set<String> idxNames) {
        if (logger.isDebugEnabled()) {
            logger.debug("Indexing row {} ", (Object)cfs.metadata.getKeyValidator().getString(key.key));
        }
        Collection<SecondaryIndex> indexes = cfs.indexManager.getIndexesByNames(idxNames);
        switchLock.readLock().lock();
        try {
            SliceQueryPager pager = new SliceQueryPager(cfs, key, ColumnSlice.ALL_COLUMNS_ARRAY);
            while (pager.hasNext()) {
                Object object = cfs.table.indexLockFor(key.key);
                synchronized (object) {
                    ColumnFamily cf = pager.next();
                    ColumnFamily cf2 = cf.cloneMeShallow();
                    for (IColumn column : cf) {
                        if (!cfs.indexManager.indexes(column.name(), indexes)) continue;
                        cf2.addColumn(column);
                    }
                    cfs.indexManager.indexRow(key.key, cf2);
                }
            }
            return;
        }
        finally {
            switchLock.readLock().unlock();
        }
    }

    private Object indexLockFor(ByteBuffer key) {
        return this.indexLocks[Math.abs(key.hashCode() % this.indexLocks.length)];
    }

    public List<Future<?>> flush() {
        ArrayList futures = new ArrayList();
        for (UUID cfId : this.columnFamilyStores.keySet()) {
            futures.add(((ColumnFamilyStore)this.columnFamilyStores.get(cfId)).forceFlush());
        }
        return futures;
    }

    public static Iterable<Table> all() {
        return Iterables.transform(Schema.instance.getTables(), tableTransformer);
    }

    public static Iterable<Table> nonSystem() {
        return Iterables.transform(Schema.instance.getNonSystemTables(), tableTransformer);
    }

    public static Iterable<Table> system() {
        return Iterables.transform(Schema.systemKeyspaceNames, tableTransformer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name='" + this.name + "')";
    }

    static {
        if (!StorageService.instance.isClientMode()) {
            DatabaseDescriptor.createAllDirectories();
        }
        tableTransformer = new Function<String, Table>(){

            public Table apply(String tableName) {
                return Table.open(tableName);
            }
        };
    }
}

