/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.SeedProviderDef;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.SeedProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class SimpleSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSeedProvider.class);
    List<InetAddress> seeds;

    public SimpleSeedProvider(Map<String, String> args) {
        try {
            this.seeds = this.loadSeeds();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public List<InetAddress> getSeeds() {
        try {
            this.seeds = this.loadSeeds();
        }
        catch (Exception e) {
            logger.warn("Could not refresh seeds from configuration file: {}", (Throwable)e);
        }
        return Collections.unmodifiableList(this.seeds);
    }

    private List<InetAddress> loadSeeds() throws IOException, ConfigurationException {
        URL url = DatabaseDescriptor.getStorageConfigURL();
        InputStream input = url.openStream();
        Constructor constructor = new Constructor(Config.class);
        TypeDescription seedDesc = new TypeDescription(SeedProviderDef.class);
        seedDesc.putMapPropertyType("parameters", String.class, String.class);
        constructor.addTypeDescription(seedDesc);
        Yaml yaml = new Yaml(new Loader((BaseConstructor)constructor));
        Config conf = (Config)yaml.load(input);
        String[] hosts = conf.seed_provider.parameters.get("seeds").split(",", -1);
        ArrayList<InetAddress> seeds = new ArrayList<InetAddress>(hosts.length);
        for (String host : hosts) {
            try {
                seeds.add(InetAddress.getByName(host.trim()));
            }
            catch (UnknownHostException ex) {
                logger.warn("Seed provider couldn't lookup host " + host);
            }
        }
        return seeds;
    }
}

