/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.columniterator.ICountableColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.StreamingHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazilyCompactedRow
extends AbstractCompactedRow
implements Iterable<OnDiskAtom> {
    private static Logger logger = LoggerFactory.getLogger(LazilyCompactedRow.class);
    private final List<? extends ICountableColumnIterator> rows;
    private final CompactionController controller;
    private final boolean shouldPurge;
    private ColumnFamily emptyColumnFamily;
    private Reducer reducer;
    private final ColumnStats columnStats;
    private long columnSerializedSize;
    private boolean closed;
    private ColumnIndex.Builder indexBuilder;
    private ColumnIndex columnsIndex;
    private final SecondaryIndexManager.Updater indexer;

    public LazilyCompactedRow(CompactionController controller, List<? extends ICountableColumnIterator> rows) {
        super(rows.get(0).getKey());
        this.rows = rows;
        this.controller = controller;
        this.indexer = controller.cfs.indexManager.updaterFor(this.key);
        long maxDelTimestamp = Long.MIN_VALUE;
        for (OnDiskAtomIterator onDiskAtomIterator : rows) {
            ColumnFamily cf = onDiskAtomIterator.getColumnFamily();
            maxDelTimestamp = Math.max(maxDelTimestamp, cf.deletionInfo().maxTimestamp());
            if (this.emptyColumnFamily == null) {
                this.emptyColumnFamily = cf;
                continue;
            }
            this.emptyColumnFamily.delete(cf);
        }
        this.shouldPurge = controller.shouldPurge(this.key, maxDelTimestamp);
        try {
            this.indexAndWrite(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.columnStats = new ColumnStats(this.reducer == null ? 0 : this.reducer.columns, this.reducer == null ? Long.MAX_VALUE : this.reducer.minTimestampSeen, this.reducer == null ? maxDelTimestamp : Math.max(maxDelTimestamp, this.reducer.maxTimestampSeen), this.reducer == null ? new StreamingHistogram(100) : this.reducer.tombstones);
        this.columnSerializedSize = this.reducer == null ? 0L : this.reducer.serializedSize;
        this.reducer = null;
    }

    private void indexAndWrite(DataOutput out) throws IOException {
        this.indexBuilder = new ColumnIndex.Builder(this.emptyColumnFamily, this.key.key, out);
        this.columnsIndex = this.indexBuilder.build(this);
    }

    @Override
    public long write(DataOutput out) throws IOException {
        long secondPassColumnSize;
        assert (!this.closed);
        DataOutputBuffer clockOut = new DataOutputBuffer();
        DeletionTime.serializer.serialize(this.emptyColumnFamily.deletionInfo().getTopLevelDeletion(), clockOut);
        long dataSize = (long)clockOut.getLength() + this.columnSerializedSize + this.indexBuilder.getOpenedMarkerSize();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("clock / column sizes are %s / %s", clockOut.getLength(), this.columnSerializedSize));
        }
        assert (dataSize > 0L);
        out.writeLong(dataSize);
        out.write(clockOut.getData(), 0, clockOut.getLength());
        out.writeInt(this.indexBuilder.writtenAtomCount());
        this.indexAndWrite(out);
        long l = secondPassColumnSize = this.reducer == null ? 0L : this.reducer.serializedSize;
        assert (secondPassColumnSize == this.columnSerializedSize) : "originally calculated column size of " + this.columnSerializedSize + " but now it is " + secondPassColumnSize;
        this.close();
        return dataSize;
    }

    @Override
    public void update(MessageDigest digest) {
        assert (!this.closed);
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            DeletionTime.serializer.serialize(this.emptyColumnFamily.deletionInfo().getTopLevelDeletion(), out);
            out.writeInt(this.columnStats.columnCount);
            digest.update(out.getData(), 0, out.getLength());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        Iterator<OnDiskAtom> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next().updateDigest(digest);
        }
        this.close();
    }

    @Override
    public boolean isEmpty() {
        boolean cfIrrelevant = this.shouldPurge ? ColumnFamilyStore.removeDeletedCF(this.emptyColumnFamily.cloneMeShallow(), this.controller.gcBefore) == null : !this.emptyColumnFamily.isMarkedForDelete();
        return cfIrrelevant && this.columnStats.columnCount == 0;
    }

    public int getEstimatedColumnCount() {
        int n = 0;
        for (ICountableColumnIterator iCountableColumnIterator : this.rows) {
            n += iCountableColumnIterator.getColumnCount();
        }
        return n;
    }

    public AbstractType<?> getComparator() {
        return this.emptyColumnFamily.getComparator();
    }

    @Override
    public Iterator<OnDiskAtom> iterator() {
        for (ICountableColumnIterator iCountableColumnIterator : this.rows) {
            iCountableColumnIterator.reset();
        }
        this.reducer = new Reducer();
        IMergeIterator<OnDiskAtom, OnDiskAtom> iter = MergeIterator.get(this.rows, this.getComparator().onDiskAtomComparator, this.reducer);
        return Iterators.filter(iter, (Predicate)Predicates.notNull());
    }

    @Override
    public ColumnStats columnStats() {
        return this.columnStats;
    }

    @Override
    public void close() {
        for (OnDiskAtomIterator onDiskAtomIterator : this.rows) {
            try {
                onDiskAtomIterator.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.closed = true;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.emptyColumnFamily.deletionInfo();
    }

    @Override
    public ColumnIndex index() {
        return this.columnsIndex;
    }

    private class Reducer
    extends MergeIterator.Reducer<OnDiskAtom, OnDiskAtom> {
        ColumnFamily container;
        RangeTombstone tombstone;
        long serializedSize;
        int columns;
        long minTimestampSeen;
        long maxTimestampSeen;
        StreamingHistogram tombstones;

        private Reducer() {
            this.container = LazilyCompactedRow.this.emptyColumnFamily.cloneMeShallow();
            this.serializedSize = 4L;
            this.columns = 0;
            this.minTimestampSeen = Long.MAX_VALUE;
            this.maxTimestampSeen = Long.MIN_VALUE;
            this.tombstones = new StreamingHistogram(100);
        }

        @Override
        public void reduce(OnDiskAtom current) {
            if (current instanceof RangeTombstone) {
                this.tombstone = (RangeTombstone)current;
            } else {
                IColumn column = (IColumn)current;
                this.container.addColumn(column);
                if (LazilyCompactedRow.this.indexer != SecondaryIndexManager.nullUpdater && !column.isMarkedForDelete() && !this.container.getColumn(column.name()).equals(column)) {
                    LazilyCompactedRow.this.indexer.remove(column);
                }
            }
        }

        @Override
        protected OnDiskAtom getReduced() {
            if (this.tombstone != null) {
                RangeTombstone t = this.tombstone;
                this.tombstone = null;
                if (LazilyCompactedRow.this.shouldPurge && ((DeletionTime)t.data).isGcAble(((LazilyCompactedRow)LazilyCompactedRow.this).controller.gcBefore)) {
                    LazilyCompactedRow.this.indexBuilder.tombstoneTracker().update(t, true);
                    return null;
                }
                this.serializedSize += t.serializedSizeForSSTable();
                return t;
            }
            ColumnFamily purged = PrecompactedRow.removeDeletedAndOldShards(LazilyCompactedRow.this.key, LazilyCompactedRow.this.shouldPurge, LazilyCompactedRow.this.controller, this.container);
            if (purged == null || !purged.iterator().hasNext()) {
                this.container = LazilyCompactedRow.this.emptyColumnFamily.cloneMeShallow();
                return null;
            }
            IColumn reduced = purged.iterator().next();
            this.container = LazilyCompactedRow.this.emptyColumnFamily.cloneMeShallow();
            if (LazilyCompactedRow.this.indexBuilder.tombstoneTracker().isDeleted(reduced)) {
                return null;
            }
            this.serializedSize += reduced.serializedSizeForSSTable();
            ++this.columns;
            this.minTimestampSeen = Math.min(this.minTimestampSeen, reduced.minTimestamp());
            this.maxTimestampSeen = Math.max(this.maxTimestampSeen, reduced.maxTimestamp());
            int deletionTime = reduced.getLocalDeletionTime();
            if (deletionTime < Integer.MAX_VALUE) {
                this.tombstones.update(deletionTime);
            }
            return reduced;
        }
    }
}

