/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.CounterUpdateColumn;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.Pair;

public class UpdateParameters {
    public final List<ByteBuffer> variables;
    public final long timestamp;
    private final int ttl;
    public final int localDeletionTime;
    private final Map<ByteBuffer, ColumnGroupMap> prefetchedLists;

    public UpdateParameters(List<ByteBuffer> variables, long timestamp, int ttl, Map<ByteBuffer, ColumnGroupMap> prefetchedLists) {
        this.variables = variables;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
        this.prefetchedLists = prefetchedLists;
    }

    public Column makeColumn(ByteBuffer name, ByteBuffer value) throws InvalidRequestException {
        QueryProcessor.validateColumnName(name);
        return this.ttl > 0 ? new ExpiringColumn(name, value, this.timestamp, this.ttl) : new Column(name, value, this.timestamp);
    }

    public Column makeCounter(ByteBuffer name, long delta) throws InvalidRequestException {
        QueryProcessor.validateColumnName(name);
        return new CounterUpdateColumn(name, delta, System.currentTimeMillis());
    }

    public Column makeTombstone(ByteBuffer name) throws InvalidRequestException {
        QueryProcessor.validateColumnName(name);
        return new DeletedColumn(name, this.localDeletionTime, this.timestamp);
    }

    public RangeTombstone makeRangeTombstone(ByteBuffer start, ByteBuffer end) throws InvalidRequestException {
        QueryProcessor.validateColumnName(start);
        QueryProcessor.validateColumnName(end);
        return new RangeTombstone(start, end, this.timestamp, this.localDeletionTime);
    }

    public RangeTombstone makeTombstoneForOverwrite(ByteBuffer start, ByteBuffer end) throws InvalidRequestException {
        QueryProcessor.validateColumnName(start);
        QueryProcessor.validateColumnName(end);
        return new RangeTombstone(start, end, this.timestamp - 1L, this.localDeletionTime);
    }

    public List<Pair<ByteBuffer, IColumn>> getPrefetchedList(ByteBuffer rowKey, ByteBuffer cql3ColumnName) {
        if (this.prefetchedLists == null) {
            return Collections.emptyList();
        }
        ColumnGroupMap m = this.prefetchedLists.get(rowKey);
        return m == null ? Collections.emptyList() : m.getCollection(cql3ColumnName);
    }
}

