/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;

public class BoundedStatsDeque
implements Iterable<Double> {
    private final LinkedBlockingDeque<Double> deque;
    private final AtomicDouble sum;

    public BoundedStatsDeque(int size) {
        this.deque = new LinkedBlockingDeque(size);
        this.sum = new AtomicDouble(0.0);
    }

    @Override
    public Iterator<Double> iterator() {
        return this.deque.iterator();
    }

    public int size() {
        return this.deque.size();
    }

    public void add(double i) {
        if (!this.deque.offer(i)) {
            Double removed = this.deque.remove();
            this.sum.addAndGet(-removed.doubleValue());
            this.deque.offer(i);
        }
        this.sum.addAndGet(i);
    }

    public double sum() {
        return this.sum.get();
    }

    public double mean() {
        return this.size() > 0 ? this.sum() / (double)this.size() : 0.0;
    }
}

