/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestSerializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;

class GossipDigestAckSerializer
implements IVersionedSerializer<GossipDigestAck> {
    GossipDigestAckSerializer() {
    }

    @Override
    public void serialize(GossipDigestAck gDigestAckMessage, DataOutput dos, int version) throws IOException {
        GossipDigestSerializationHelper.serialize(gDigestAckMessage.gDigestList, dos, version);
        if (version < 6) {
            dos.writeBoolean(true);
        }
        dos.writeInt(gDigestAckMessage.epStateMap.size());
        for (Map.Entry<InetAddress, EndpointState> entry : gDigestAckMessage.epStateMap.entrySet()) {
            InetAddress ep = entry.getKey();
            CompactEndpointSerializationHelper.serialize(ep, dos);
            EndpointState.serializer.serialize(entry.getValue(), dos, version);
        }
    }

    @Override
    public GossipDigestAck deserialize(DataInput dis, int version) throws IOException {
        List<GossipDigest> gDigestList = GossipDigestSerializationHelper.deserialize(dis, version);
        if (version < 6) {
            dis.readBoolean();
        }
        int size = dis.readInt();
        HashMap<InetAddress, EndpointState> epStateMap = new HashMap<InetAddress, EndpointState>(size);
        for (int i = 0; i < size; ++i) {
            InetAddress ep = CompactEndpointSerializationHelper.deserialize(dis);
            EndpointState epState = EndpointState.serializer.deserialize(dis, version);
            epStateMap.put(ep, epState);
        }
        return new GossipDigestAck(gDigestList, epStateMap);
    }

    @Override
    public long serializedSize(GossipDigestAck ack, int version) {
        int size = GossipDigestSerializationHelper.serializedSize(ack.gDigestList, version);
        if (version < 6) {
            size += TypeSizes.NATIVE.sizeof(true);
        }
        size += TypeSizes.NATIVE.sizeof(ack.epStateMap.size());
        for (Map.Entry<InetAddress, EndpointState> entry : ack.epStateMap.entrySet()) {
            size = (int)((long)size + ((long)CompactEndpointSerializationHelper.serializedSize(entry.getKey()) + EndpointState.serializer.serializedSize(entry.getValue(), version)));
        }
        return size;
    }
}

