/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SuperColumnSerializer;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.ISSTableSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.ByteBufferUtil;

public interface OnDiskAtom {
    public ByteBuffer name();

    public long minTimestamp();

    public long maxTimestamp();

    public int getLocalDeletionTime();

    public int serializedSize(TypeSizes var1);

    public long serializedSizeForSSTable();

    public void validateFields(CFMetaData var1) throws MarshalException;

    public void updateDigest(MessageDigest var1);

    public static class Serializer
    implements ISSTableSerializer<OnDiskAtom> {
        private final IColumnSerializer columnSerializer;

        public Serializer(IColumnSerializer columnSerializer) {
            this.columnSerializer = columnSerializer;
        }

        @Override
        public void serializeForSSTable(OnDiskAtom atom, DataOutput dos) throws IOException {
            if (atom instanceof IColumn) {
                this.columnSerializer.serialize((IColumn)atom, dos);
            } else {
                assert (atom instanceof RangeTombstone);
                RangeTombstone.serializer.serializeForSSTable((RangeTombstone)atom, dos);
            }
        }

        @Override
        public OnDiskAtom deserializeFromSSTable(DataInput dis, Descriptor.Version version) throws IOException {
            return this.deserializeFromSSTable(dis, IColumnSerializer.Flag.LOCAL, (int)(System.currentTimeMillis() / 1000L), version);
        }

        public OnDiskAtom deserializeFromSSTable(DataInput dis, IColumnSerializer.Flag flag, int expireBefore, Descriptor.Version version) throws IOException {
            if (this.columnSerializer instanceof SuperColumnSerializer) {
                return this.columnSerializer.deserialize(dis, flag, expireBefore);
            }
            ByteBuffer name = ByteBufferUtil.readWithShortLength(dis);
            if (name.remaining() <= 0) {
                throw ColumnSerializer.CorruptColumnException.create(dis, name);
            }
            int b = dis.readUnsignedByte();
            if ((b & 0x10) != 0) {
                return RangeTombstone.serializer.deserializeBody(dis, name, version);
            }
            return ((ColumnSerializer)this.columnSerializer).deserializeColumnBody(dis, name, b, flag, expireBefore);
        }
    }
}

