/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;

public interface RawSelector {

    public static class WithFunction
    implements RawSelector {
        public final String functionName;
        public final List<RawSelector> args;

        public WithFunction(String functionName, List<RawSelector> args) {
            this.functionName = functionName;
            this.args = args;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.functionName).append("(");
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.args.get(i));
            }
            return sb.append(")").toString();
        }
    }

    public static class WritetimeOrTTL
    implements RawSelector {
        public final ColumnIdentifier id;
        public final boolean isWritetime;

        public WritetimeOrTTL(ColumnIdentifier id, boolean isWritetime) {
            this.id = id;
            this.isWritetime = isWritetime;
        }

        public String toString() {
            return (this.isWritetime ? "writetime" : "ttl") + "(" + this.id + ")";
        }
    }
}

