/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.BoundedStatsDeque;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrivalWindow {
    private static final Logger logger = LoggerFactory.getLogger(ArrivalWindow.class);
    private double tLast = 0.0;
    private final BoundedStatsDeque arrivalIntervals;
    private final double MAX_INTERVAL_IN_MS = DatabaseDescriptor.getRpcTimeout();

    ArrivalWindow(int size) {
        this.arrivalIntervals = new BoundedStatsDeque(size);
    }

    synchronized void add(double value) {
        if (this.tLast > 0.0) {
            double interArrivalTime = value - this.tLast;
            if (interArrivalTime <= this.MAX_INTERVAL_IN_MS) {
                this.arrivalIntervals.add(interArrivalTime);
            } else {
                logger.debug("Ignoring interval time of {}", (Object)interArrivalTime);
            }
        } else {
            this.arrivalIntervals.add(30000.0);
        }
        this.tLast = value;
    }

    double mean() {
        return this.arrivalIntervals.mean();
    }

    double phi(long tnow) {
        assert (this.arrivalIntervals.size() > 0 && this.tLast > 0.0);
        double t = (double)tnow - this.tLast;
        return t / this.mean();
    }

    public String toString() {
        return StringUtils.join(this.arrivalIntervals.iterator(), (String)" ");
    }
}

