/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class TypeCast
implements Term.Raw {
    private final CQL3Type type;
    private final Term.Raw term;

    public TypeCast(CQL3Type type, Term.Raw term) {
        this.type = type;
        this.term = term;
    }

    @Override
    public Term prepare(ColumnSpecification receiver) throws InvalidRequestException {
        if (!this.term.isAssignableTo(this.castedSpecOf(receiver))) {
            throw new InvalidRequestException(String.format("Cannot cast value %s to type %s", this.term, this.type));
        }
        if (!this.isAssignableTo(receiver)) {
            throw new InvalidRequestException(String.format("Cannot assign value %s to %s of type %s", this, receiver, receiver.type.asCQL3Type()));
        }
        return this.term.prepare(receiver);
    }

    private ColumnSpecification castedSpecOf(ColumnSpecification receiver) {
        return new ColumnSpecification(receiver.ksName, receiver.cfName, new ColumnIdentifier(this.toString(), true), this.type.getType());
    }

    @Override
    public boolean isAssignableTo(ColumnSpecification receiver) {
        return receiver.type.asCQL3Type().equals(this.type);
    }

    public String toString() {
        return "(" + this.type + ")" + this.term;
    }
}

