/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.io.IOException;
import org.apache.cassandra.transport.Frame;
import org.apache.cassandra.transport.ProtocolException;
import org.jboss.netty.buffer.ChannelBuffers;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyError;

public interface FrameCompressor {
    public Frame compress(Frame var1) throws IOException;

    public Frame decompress(Frame var1) throws IOException;

    public static class SnappyCompressor
    implements FrameCompressor {
        public static final SnappyCompressor instance;

        private SnappyCompressor() {
            Snappy.getNativeLibraryVersion();
        }

        @Override
        public Frame compress(Frame frame) throws IOException {
            byte[] input = new byte[frame.body.readableBytes()];
            byte[] output = new byte[Snappy.maxCompressedLength((int)input.length)];
            frame.body.readBytes(input);
            int written = Snappy.compress((byte[])input, (int)0, (int)input.length, (byte[])output, (int)0);
            return frame.with(ChannelBuffers.wrappedBuffer((byte[])output, (int)0, (int)written));
        }

        @Override
        public Frame decompress(Frame frame) throws IOException {
            byte[] input = new byte[frame.body.readableBytes()];
            frame.body.readBytes(input);
            if (!Snappy.isValidCompressedBuffer((byte[])input, (int)0, (int)input.length)) {
                throw new ProtocolException("Provided frame does not appear to be Snappy compressed");
            }
            byte[] output = new byte[Snappy.uncompressedLength((byte[])input)];
            int size = Snappy.uncompress((byte[])input, (int)0, (int)input.length, (byte[])output, (int)0);
            return frame.with(ChannelBuffers.wrappedBuffer((byte[])output, (int)0, (int)size));
        }

        static {
            SnappyCompressor i;
            try {
                i = new SnappyCompressor();
            }
            catch (Exception e) {
                i = null;
            }
            catch (NoClassDefFoundError e) {
                i = null;
            }
            catch (SnappyError e) {
                i = null;
            }
            catch (UnsatisfiedLinkError e) {
                i = null;
            }
            instance = i;
        }
    }
}

