/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.StorageService;

public class TokenFct
extends AbstractFunction {
    private static final IPartitioner partitioner = StorageService.instance.getPartitioner();
    public static final Function.Factory factory = new Function.Factory(){

        @Override
        public Function create(String ksName, String cfName) {
            return new TokenFct(Schema.instance.getCFMetaData(ksName, cfName));
        }
    };
    private final CFDefinition cfDef;

    public TokenFct(CFMetaData cfm) {
        super("token", partitioner.getTokenValidator(), TokenFct.getKeyTypes(cfm));
        this.cfDef = cfm.getCfDef();
    }

    private static AbstractType[] getKeyTypes(CFMetaData cfm) {
        AbstractType[] types = new AbstractType[cfm.getCfDef().keys.size()];
        int i = 0;
        for (CFDefinition.Name name : cfm.getCfDef().keys.values()) {
            types[i++] = name.type;
        }
        return types;
    }

    @Override
    public ByteBuffer execute(List<ByteBuffer> parameters) throws InvalidRequestException {
        ColumnNameBuilder builder = this.cfDef.getKeyNameBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            ByteBuffer bb = parameters.get(i);
            if (bb == null) {
                return null;
            }
            builder.add(bb);
        }
        return partitioner.getTokenFactory().toByteArray(partitioner.getToken(builder.build()));
    }
}

