/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.thrift.TCustomServerSocket;
import org.apache.cassandra.thrift.TCustomSocket;
import org.apache.cassandra.thrift.TServerFactory;
import org.apache.cassandra.thrift.ThriftSessionManager;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTThreadPoolServer
extends TServer {
    private static final Logger logger = LoggerFactory.getLogger((String)CustomTThreadPoolServer.class.getName());
    private final ExecutorService executorService;
    private volatile boolean stopped;
    private final TThreadPoolServer.Args args;
    private final AtomicInteger activeClients = new AtomicInteger(0);

    public CustomTThreadPoolServer(TThreadPoolServer.Args args, ExecutorService executorService) {
        super((TServer.AbstractServerArgs)args);
        this.executorService = executorService;
        this.args = args;
    }

    public void serve() {
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            logger.error("Error occurred during listening.", (Throwable)ttx);
            return;
        }
        this.stopped = false;
        while (!this.stopped) {
            block8: {
                while (this.activeClients.get() >= this.args.maxWorkerThreads) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                try {
                    TTransport client = this.serverTransport_.accept();
                    this.activeClients.incrementAndGet();
                    WorkerProcess wp = new WorkerProcess(client);
                    this.executorService.execute(wp);
                }
                catch (TTransportException ttx) {
                    if (ttx.getCause() instanceof SocketTimeoutException) continue;
                    if (this.stopped) break block8;
                    logger.warn("Transport error occurred during acceptance of message.", (Throwable)ttx);
                }
            }
            if (this.activeClients.get() < this.args.maxWorkerThreads) continue;
            logger.warn("Maximum number of clients " + this.args.maxWorkerThreads + " reached");
        }
        this.executorService.shutdown();
    }

    public void stop() {
        this.stopped = true;
        this.serverTransport_.interrupt();
    }

    public static class Factory
    implements TServerFactory {
        @Override
        public TServer buildTServer(TServerFactory.Args args) {
            TCustomServerSocket serverTransport;
            InetSocketAddress addr = args.addr;
            try {
                EncryptionOptions.ClientEncryptionOptions clientEnc = DatabaseDescriptor.getClientEncryptionOptions();
                if (clientEnc.enabled) {
                    logger.info("enabling encrypted thrift connections between client and server");
                    TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters(clientEnc.protocol, clientEnc.cipher_suites);
                    params.setKeyStore(clientEnc.keystore, clientEnc.keystore_password);
                    params.requireClientAuth(clientEnc.require_client_auth.booleanValue());
                    TServerSocket sslServer = TSSLTransportFactory.getServerSocket((int)addr.getPort(), (int)0, (InetAddress)addr.getAddress(), (TSSLTransportFactory.TSSLTransportParameters)params);
                    serverTransport = new TCustomServerSocket(sslServer.getServerSocket(), args.keepAlive, args.sendBufferSize, args.recvBufferSize);
                } else {
                    serverTransport = new TCustomServerSocket(addr, args.keepAlive, args.sendBufferSize, args.recvBufferSize);
                }
            }
            catch (TTransportException e) {
                throw new RuntimeException(String.format("Unable to create thrift socket to %s:%s", addr.getAddress(), addr.getPort()), e);
            }
            TThreadPoolServer.Args serverArgs = (TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).minWorkerThreads(DatabaseDescriptor.getRpcMinThreads().intValue()).maxWorkerThreads(DatabaseDescriptor.getRpcMaxThreads().intValue()).inputTransportFactory(args.inTransportFactory)).outputTransportFactory(args.outTransportFactory)).inputProtocolFactory(args.tProtocolFactory)).outputProtocolFactory(args.tProtocolFactory)).processor((TProcessor)args.processor);
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(serverArgs.minWorkerThreads, serverArgs.maxWorkerThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("Thrift"));
            return new CustomTThreadPoolServer(serverArgs, executorService);
        }
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport client) {
            this.client_ = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TProcessor processor = null;
            TTransport inputTransport = null;
            TTransport outputTransport = null;
            TProtocol inputProtocol = null;
            TProtocol outputProtocol = null;
            SocketAddress socket = null;
            try {
                socket = ((TCustomSocket)this.client_).getSocket().getRemoteSocketAddress();
                ThriftSessionManager.instance.setCurrentSocket(socket);
                processor = CustomTThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                inputTransport = CustomTThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                outputTransport = CustomTThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                inputProtocol = CustomTThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                outputProtocol = CustomTThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                while (!CustomTThreadPoolServer.this.stopped && processor.process(inputProtocol, outputProtocol)) {
                    inputProtocol = CustomTThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                    outputProtocol = CustomTThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                }
            }
            catch (TTransportException ttx) {
                logger.debug("Thrift transport error occurred during processing of message.", (Throwable)ttx);
            }
            catch (TException tx) {
                logger.error("Thrift error occurred during processing of message.", (Throwable)tx);
            }
            catch (Exception x) {
                logger.error("Error occurred during processing of message.", (Throwable)x);
            }
            finally {
                CustomTThreadPoolServer.this.activeClients.decrementAndGet();
                if (socket != null) {
                    ThriftSessionManager.instance.connectionComplete(socket);
                }
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport != null) {
                outputTransport.close();
            }
        }
    }
}

