/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.utils.SemanticVersion;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientState {
    private static final Logger logger;
    public static final SemanticVersion DEFAULT_CQL_VERSION;
    private static final Set<IResource> READABLE_SYSTEM_RESOURCES;
    private static final Set<IResource> PROTECTED_AUTH_RESOURCES;
    private volatile AuthenticatedUser user;
    private String keyspace;
    private SemanticVersion cqlVersion;
    private final boolean internalCall;

    public ClientState() {
        this(false);
    }

    public ClientState(boolean internalCall) {
        this.internalCall = internalCall;
        if (!DatabaseDescriptor.getAuthenticator().requireAuthentication()) {
            this.user = AuthenticatedUser.ANONYMOUS_USER;
        }
    }

    public String getRawKeyspace() {
        return this.keyspace;
    }

    public String getKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("no keyspace has been specified");
        }
        return this.keyspace;
    }

    public void setKeyspace(String ks) throws InvalidRequestException {
        if (Schema.instance.getKSMetaData(ks) == null) {
            throw new InvalidRequestException("Keyspace '" + ks + "' does not exist");
        }
        this.keyspace = ks;
    }

    public void login(Map<String, String> credentials) throws AuthenticationException {
        AuthenticatedUser user = DatabaseDescriptor.getAuthenticator().authenticate(credentials);
        if (!user.isAnonymous() && !Auth.isExistingUser(user.getName())) {
            throw new AuthenticationException(String.format("User %s doesn't exist - create it with CREATE USER query first", user.getName()));
        }
        this.user = user;
    }

    public void hasAllKeyspacesAccess(Permission perm) throws UnauthorizedException, InvalidRequestException {
        if (this.internalCall) {
            return;
        }
        this.validateLogin();
        this.ensureHasPermission(perm, DataResource.root());
    }

    public void hasKeyspaceAccess(String keyspace, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.hasAccess(keyspace, perm, DataResource.keyspace(keyspace));
    }

    public void hasColumnFamilyAccess(String keyspace, String columnFamily, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.hasAccess(keyspace, perm, DataResource.columnFamily(keyspace, columnFamily));
    }

    private void hasAccess(String keyspace, Permission perm, DataResource resource) throws UnauthorizedException, InvalidRequestException {
        ClientState.validateKeyspace(keyspace);
        if (this.internalCall) {
            return;
        }
        this.validateLogin();
        this.preventSystemKSSchemaModification(keyspace, perm);
        if (perm.equals((Object)Permission.SELECT) && READABLE_SYSTEM_RESOURCES.contains(resource)) {
            return;
        }
        if (PROTECTED_AUTH_RESOURCES.contains(resource)) {
            throw new UnauthorizedException(String.format("Resource %s is inaccessible", resource));
        }
        this.ensureHasPermission(perm, resource);
    }

    public void ensureHasPermission(Permission perm, IResource resource) throws UnauthorizedException {
        for (IResource iResource : Resources.chain(resource)) {
            if (!this.authorize(iResource).contains((Object)perm)) continue;
            return;
        }
        throw new UnauthorizedException(String.format("User %s has no %s permission on %s or any of its parents", new Object[]{this.user.getName(), perm, resource}));
    }

    private void preventSystemKSSchemaModification(String keyspace, Permission perm) throws UnauthorizedException {
        if (Schema.systemKeyspaceNames.contains((Object)keyspace.toLowerCase()) && !perm.equals((Object)Permission.SELECT) && !perm.equals((Object)Permission.MODIFY)) {
            throw new UnauthorizedException(keyspace + " keyspace is not user-modifiable.");
        }
    }

    public void validateLogin() throws UnauthorizedException {
        if (this.user == null) {
            throw new UnauthorizedException("You have not logged in");
        }
    }

    public void ensureNotAnonymous() throws UnauthorizedException {
        this.validateLogin();
        if (this.user.isAnonymous()) {
            throw new UnauthorizedException("You have to be logged in to perform this query");
        }
    }

    private static void validateKeyspace(String keyspace) throws InvalidRequestException {
        if (keyspace == null) {
            throw new InvalidRequestException("You have not set a keyspace for this session");
        }
    }

    public void setCQLVersion(String str) throws InvalidRequestException {
        SemanticVersion version;
        try {
            version = new SemanticVersion(str);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        SemanticVersion cql = org.apache.cassandra.cql.QueryProcessor.CQL_VERSION;
        SemanticVersion cql3 = QueryProcessor.CQL_VERSION;
        SemanticVersion cql3Beta = new SemanticVersion("3.0.0-beta1");
        if (version.equals(cql3Beta)) {
            throw new InvalidRequestException(String.format("There has been a few syntax breaking changes between 3.0.0-beta1 and 3.0.0 (mainly the syntax for options of CREATE KEYSPACE and CREATE TABLE). 3.0.0-beta1  is not supported; please upgrade to 3.0.0", new Object[0]));
        }
        if (version.isSupportedBy(cql)) {
            this.cqlVersion = cql;
        } else if (version.isSupportedBy(cql3)) {
            this.cqlVersion = cql3;
        } else {
            throw new InvalidRequestException(String.format("Provided version %s is not supported by this server (supported: %s)", version, StringUtils.join((Object[])ClientState.getCQLSupportedVersion(), (String)", ")));
        }
    }

    public AuthenticatedUser getUser() {
        return this.user;
    }

    public SemanticVersion getCQLVersion() {
        return this.cqlVersion;
    }

    public static SemanticVersion[] getCQLSupportedVersion() {
        SemanticVersion cql = org.apache.cassandra.cql.QueryProcessor.CQL_VERSION;
        SemanticVersion cql3 = QueryProcessor.CQL_VERSION;
        return new SemanticVersion[]{cql, cql3};
    }

    private Set<Permission> authorize(IResource resource) {
        return DatabaseDescriptor.getAuthorizer().authorize(this.user, resource);
    }

    static {
        String[] cfs;
        logger = LoggerFactory.getLogger(ClientState.class);
        DEFAULT_CQL_VERSION = QueryProcessor.CQL_VERSION;
        READABLE_SYSTEM_RESOURCES = new HashSet<IResource>(5);
        PROTECTED_AUTH_RESOURCES = new HashSet<IResource>();
        for (String cf : cfs = new String[]{"local", "peers", "schema_keyspaces", "schema_columnfamilies", "schema_columns"}) {
            READABLE_SYSTEM_RESOURCES.add(DataResource.columnFamily("system", cf));
        }
        PROTECTED_AUTH_RESOURCES.addAll(DatabaseDescriptor.getAuthenticator().protectedResources());
        PROTECTED_AUTH_RESOURCES.addAll(DatabaseDescriptor.getAuthorizer().protectedResources());
    }
}

