/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.StreamingHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableMetadata {
    public static final double NO_COMPRESSION_RATIO = -1.0;
    public static final SSTableMetadataSerializer serializer = new SSTableMetadataSerializer();
    public final EstimatedHistogram estimatedRowSize;
    public final EstimatedHistogram estimatedColumnCount;
    public final ReplayPosition replayPosition;
    public final long minTimestamp;
    public final long maxTimestamp;
    public final double compressionRatio;
    public final String partitioner;
    public final Set<Integer> ancestors;
    public final StreamingHistogram estimatedTombstoneDropTime;

    private SSTableMetadata() {
        this(SSTableMetadata.defaultRowSizeHistogram(), SSTableMetadata.defaultColumnCountHistogram(), ReplayPosition.NONE, Long.MAX_VALUE, Long.MIN_VALUE, -1.0, null, Collections.emptySet(), SSTableMetadata.defaultTombstoneDropTimeHistogram());
    }

    private SSTableMetadata(EstimatedHistogram rowSizes, EstimatedHistogram columnCounts, ReplayPosition replayPosition, long minTimestamp, long maxTimestamp, double cr, String partitioner, Set<Integer> ancestors, StreamingHistogram estimatedTombstoneDropTime) {
        this.estimatedRowSize = rowSizes;
        this.estimatedColumnCount = columnCounts;
        this.replayPosition = replayPosition;
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.compressionRatio = cr;
        this.partitioner = partitioner;
        this.ancestors = ancestors;
        this.estimatedTombstoneDropTime = estimatedTombstoneDropTime;
    }

    public static SSTableMetadata createDefaultInstance() {
        return new SSTableMetadata();
    }

    public static Collector createCollector() {
        return new Collector();
    }

    static EstimatedHistogram defaultColumnCountHistogram() {
        return new EstimatedHistogram(114);
    }

    static EstimatedHistogram defaultRowSizeHistogram() {
        return new EstimatedHistogram(150);
    }

    static StreamingHistogram defaultTombstoneDropTimeHistogram() {
        return new StreamingHistogram(100);
    }

    public double getEstimatedDroppableTombstoneRatio(int gcBefore) {
        long estimatedColumnCount = this.estimatedColumnCount.mean() * this.estimatedColumnCount.count();
        if (estimatedColumnCount > 0L) {
            double droppable = this.getDroppableTombstonesBefore(gcBefore);
            return droppable / (double)estimatedColumnCount;
        }
        return 0.0;
    }

    public double getDroppableTombstonesBefore(int gcBefore) {
        return this.estimatedTombstoneDropTime.sum(gcBefore);
    }

    public static class SSTableMetadataSerializer {
        private static final Logger logger = LoggerFactory.getLogger(SSTableMetadataSerializer.class);

        public void serialize(SSTableMetadata sstableStats, DataOutput dos) throws IOException {
            assert (sstableStats.partitioner != null);
            EstimatedHistogram.serializer.serialize(sstableStats.estimatedRowSize, dos);
            EstimatedHistogram.serializer.serialize(sstableStats.estimatedColumnCount, dos);
            ReplayPosition.serializer.serialize(sstableStats.replayPosition, dos);
            dos.writeLong(sstableStats.minTimestamp);
            dos.writeLong(sstableStats.maxTimestamp);
            dos.writeDouble(sstableStats.compressionRatio);
            dos.writeUTF(sstableStats.partitioner);
            dos.writeInt(sstableStats.ancestors.size());
            for (Integer g : sstableStats.ancestors) {
                dos.writeInt(g);
            }
            StreamingHistogram.serializer.serialize(sstableStats.estimatedTombstoneDropTime, dos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SSTableMetadata deserialize(Descriptor descriptor) throws IOException {
            logger.debug("Load metadata for {}", (Object)descriptor);
            File statsFile = new File(descriptor.filenameFor(SSTable.COMPONENT_STATS));
            if (!statsFile.exists()) {
                logger.debug("No sstable stats for {}", (Object)descriptor);
                return new SSTableMetadata();
            }
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(statsFile)));
            try {
                SSTableMetadata sSTableMetadata = this.deserialize(dis, descriptor);
                return sSTableMetadata;
            }
            finally {
                FileUtils.closeQuietly(dis);
            }
        }

        public SSTableMetadata deserialize(DataInputStream dis, Descriptor desc) throws IOException {
            long maxTimestamp;
            long minTimestamp;
            ReplayPosition replayPosition;
            EstimatedHistogram rowSizes = EstimatedHistogram.serializer.deserialize(dis);
            EstimatedHistogram columnCounts = EstimatedHistogram.serializer.deserialize(dis);
            ReplayPosition replayPosition2 = replayPosition = desc.version.metadataIncludesReplayPosition ? ReplayPosition.serializer.deserialize(dis) : ReplayPosition.NONE;
            if (!desc.version.metadataIncludesModernReplayPosition) {
                replayPosition = ReplayPosition.NONE;
            }
            long l = minTimestamp = desc.version.tracksMinTimestamp ? dis.readLong() : Long.MIN_VALUE;
            if (!desc.version.tracksMinTimestamp) {
                minTimestamp = Long.MAX_VALUE;
            }
            long l2 = maxTimestamp = desc.version.containsTimestamp() ? dis.readLong() : Long.MIN_VALUE;
            if (!desc.version.tracksMaxTimestamp) {
                maxTimestamp = Long.MAX_VALUE;
            }
            double compressionRatio = desc.version.hasCompressionRatio ? dis.readDouble() : -1.0;
            String partitioner = desc.version.hasPartitioner ? dis.readUTF() : null;
            int nbAncestors = desc.version.hasAncestors ? dis.readInt() : 0;
            HashSet<Integer> ancestors = new HashSet<Integer>(nbAncestors);
            for (int i = 0; i < nbAncestors; ++i) {
                ancestors.add(dis.readInt());
            }
            StreamingHistogram tombstoneHistogram = desc.version.tracksTombstones ? StreamingHistogram.serializer.deserialize(dis) : SSTableMetadata.defaultTombstoneDropTimeHistogram();
            return new SSTableMetadata(rowSizes, columnCounts, replayPosition, minTimestamp, maxTimestamp, compressionRatio, partitioner, ancestors, tombstoneHistogram);
        }
    }

    public static class Collector {
        protected EstimatedHistogram estimatedRowSize = SSTableMetadata.defaultRowSizeHistogram();
        protected EstimatedHistogram estimatedColumnCount = SSTableMetadata.defaultColumnCountHistogram();
        protected ReplayPosition replayPosition = ReplayPosition.NONE;
        protected long minTimestamp = Long.MAX_VALUE;
        protected long maxTimestamp = Long.MIN_VALUE;
        protected double compressionRatio = -1.0;
        protected Set<Integer> ancestors = new HashSet<Integer>();
        protected StreamingHistogram estimatedTombstoneDropTime = SSTableMetadata.defaultTombstoneDropTimeHistogram();

        public void addRowSize(long rowSize) {
            this.estimatedRowSize.add(rowSize);
        }

        public void addColumnCount(long columnCount) {
            this.estimatedColumnCount.add(columnCount);
        }

        public void mergeTombstoneHistogram(StreamingHistogram histogram) {
            this.estimatedTombstoneDropTime.merge(histogram);
        }

        public void addCompressionRatio(long compressed, long uncompressed) {
            this.compressionRatio = (double)compressed / (double)uncompressed;
        }

        public void updateMinTimestamp(long potentialMin) {
            this.minTimestamp = Math.min(this.minTimestamp, potentialMin);
        }

        public void updateMaxTimestamp(long potentialMax) {
            this.maxTimestamp = Math.max(this.maxTimestamp, potentialMax);
        }

        public SSTableMetadata finalizeMetadata(String partitioner) {
            return new SSTableMetadata(this.estimatedRowSize, this.estimatedColumnCount, this.replayPosition, this.minTimestamp, this.maxTimestamp, this.compressionRatio, partitioner, this.ancestors, this.estimatedTombstoneDropTime);
        }

        public Collector estimatedRowSize(EstimatedHistogram estimatedRowSize) {
            this.estimatedRowSize = estimatedRowSize;
            return this;
        }

        public Collector estimatedColumnCount(EstimatedHistogram estimatedColumnCount) {
            this.estimatedColumnCount = estimatedColumnCount;
            return this;
        }

        public Collector replayPosition(ReplayPosition replayPosition) {
            this.replayPosition = replayPosition;
            return this;
        }

        public Collector addAncestor(int generation) {
            this.ancestors.add(generation);
            return this;
        }

        void update(long size, ColumnStats stats) {
            this.updateMinTimestamp(stats.minTimestamp);
            this.updateMaxTimestamp(stats.maxTimestamp);
            this.addRowSize(size);
            this.addColumnCount(stats.columnCount);
            this.mergeTombstoneHistogram(stats.tombstoneHistogram);
        }
    }
}

