/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.LazilyCompactedRow;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionController {
    private static final Logger logger = LoggerFactory.getLogger(CompactionController.class);
    public final ColumnFamilyStore cfs;
    private final DataTracker.SSTableIntervalTree overlappingTree;
    private final Set<SSTableReader> overlappingSSTables;
    public final int gcBefore;
    public final int mergeShardBefore;
    private final Throttle throttle = new Throttle("Cassandra_Throttle", new Throttle.ThroughputFunction(){

        @Override
        public int targetThroughput() {
            if (DatabaseDescriptor.getCompactionThroughputMbPerSec() < 1 || StorageService.instance.isBootstrapMode()) {
                return 0;
            }
            int totalBytesPerMS = DatabaseDescriptor.getCompactionThroughputMbPerSec() * 1024 * 1024 / 1000;
            return totalBytesPerMS / Math.max(1, CompactionManager.instance.getActiveCompactions());
        }
    });

    public CompactionController(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore) {
        this(cfs, gcBefore, cfs.getAndReferenceOverlappingSSTables(sstables));
    }

    protected CompactionController(ColumnFamilyStore cfs, int maxValue) {
        this(cfs, maxValue, null);
    }

    private CompactionController(ColumnFamilyStore cfs, int gcBefore, Set<SSTableReader> overlappingSSTables) {
        assert (cfs != null);
        this.cfs = cfs;
        this.gcBefore = gcBefore;
        this.mergeShardBefore = (int)((cfs.oldestUnflushedMemtable() + 18000L) / 1000L);
        this.overlappingSSTables = overlappingSSTables == null ? Collections.emptySet() : overlappingSSTables;
        this.overlappingTree = overlappingSSTables == null ? null : DataTracker.buildIntervalTree(overlappingSSTables);
    }

    public String getKeyspace() {
        return this.cfs.table.name;
    }

    public String getColumnFamily() {
        return this.cfs.columnFamily;
    }

    public boolean shouldPurge(DecoratedKey key, long maxDeletionTimestamp) {
        List filteredSSTables = this.overlappingTree.search(key);
        for (SSTableReader sstable : filteredSSTables) {
            if (!sstable.getBloomFilter().isPresent(key.key) || sstable.getMinTimestamp() < maxDeletionTimestamp) continue;
            return false;
        }
        return true;
    }

    public void invalidateCachedRow(DecoratedKey key) {
        this.cfs.invalidateCachedRow(key);
    }

    public void removeDeletedInCache(DecoratedKey key) {
        if (CacheService.instance.rowCache.isPutCopying()) {
            return;
        }
        ColumnFamily cachedRow = this.cfs.getRawCachedRow(key);
        if (cachedRow != null) {
            ColumnFamilyStore.removeDeleted(cachedRow, this.gcBefore);
        }
    }

    public AbstractCompactedRow getCompactedRow(List<SSTableIdentityIterator> rows) {
        long rowSize = 0L;
        for (SSTableIdentityIterator row : rows) {
            rowSize += row.dataSize;
        }
        if (rowSize > (long)DatabaseDescriptor.getInMemoryCompactionLimit()) {
            String keyString = this.cfs.metadata.getKeyValidator().getString(rows.get((int)0).getKey().key);
            logger.info(String.format("Compacting large row %s/%s:%s (%d bytes) incrementally", this.cfs.table.name, this.cfs.columnFamily, keyString, rowSize));
            return new LazilyCompactedRow(this, rows);
        }
        return new PrecompactedRow(this, rows);
    }

    public AbstractCompactedRow getCompactedRow(SSTableIdentityIterator row) {
        return this.getCompactedRow(Collections.singletonList(row));
    }

    public void mayThrottle(long currentBytes) {
        this.throttle.throttle(currentBytes);
    }

    public void close() {
        SSTableReader.releaseReferences(this.overlappingSSTables);
    }
}

