/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.cassandra.db.AbstractColumnContainer;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.AtomicSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.ThreadSafeSortedColumns;
import org.apache.cassandra.db.columniterator.ISSTableColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.columniterator.SimpleAbstractColumnIterator;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.HeapAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollationController {
    private static final Logger logger = LoggerFactory.getLogger(CollationController.class);
    private final ColumnFamilyStore cfs;
    private final QueryFilter filter;
    private final ISortedColumns.Factory factory;
    private final int gcBefore;
    private int sstablesIterated = 0;

    public CollationController(ColumnFamilyStore cfs, boolean mutableColumns, QueryFilter filter, int gcBefore) {
        this.cfs = cfs;
        this.filter = filter;
        this.gcBefore = gcBefore;
        this.factory = mutableColumns ? (cfs.metadata.cfType == ColumnFamilyType.Super ? ThreadSafeSortedColumns.factory() : AtomicSortedColumns.factory()) : ArrayBackedSortedColumns.factory();
    }

    public ColumnFamily getTopLevelColumns() {
        return this.filter.filter instanceof NamesQueryFilter && (this.cfs.metadata.cfType == ColumnFamilyType.Standard || this.filter.path.superColumnName != null) && this.cfs.metadata.getDefaultValidator() != CounterColumnType.instance ? this.collectTimeOrderedData() : this.collectAllData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily collectTimeOrderedData() {
        logger.trace("collectTimeOrderedData");
        ColumnFamily container = ColumnFamily.create(this.cfs.metadata, this.factory, this.filter.filter.isReversed());
        ArrayList<OnDiskAtomIterator> iterators = new ArrayList<OnDiskAtomIterator>();
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = this.cfs.markReferenced(this.filter.key);
        ColumnFamily temp = ColumnFamily.create(this.cfs.metadata, ArrayBackedSortedColumns.factory(), this.filter.filter.isReversed());
        try {
            Tracing.trace("Merging memtable contents");
            for (Memtable memtable : view.memtables) {
                OnDiskAtomIterator iter = this.filter.getMemtableColumnIterator(memtable);
                if (iter != null) {
                    iterators.add(iter);
                    temp.delete(iter.getColumnFamily());
                    while (iter.hasNext()) {
                        temp.addAtom((OnDiskAtom)iter.next());
                    }
                }
                container.addAll(temp, HeapAllocator.instance);
                temp.clear();
            }
            NamesQueryFilter namesFilter = (NamesQueryFilter)this.filter.filter;
            TreeSet<ByteBuffer> filterColumns = new TreeSet<ByteBuffer>(namesFilter.columns);
            QueryFilter reducedFilter = new QueryFilter(this.filter.key, this.filter.path, namesFilter.withUpdatedColumns(filterColumns));
            Collections.sort(view.sstables, SSTable.maxTimestampComparator);
            long mostRecentRowTombstone = Long.MIN_VALUE;
            for (SSTableReader sstable : view.sstables) {
                if (sstable.getMaxTimestamp() < mostRecentRowTombstone) break;
                long currentMaxTs = sstable.getMaxTimestamp();
                this.reduceNameFilter(reducedFilter, container, currentMaxTs);
                if (((NamesQueryFilter)reducedFilter.filter).columns.isEmpty()) break;
                ISSTableColumnIterator iter = reducedFilter.getSSTableColumnIterator(sstable);
                iterators.add(iter);
                if (iter.getColumnFamily() != null) {
                    ColumnFamily cf = iter.getColumnFamily();
                    if (cf.isMarkedForDelete()) {
                        mostRecentRowTombstone = cf.deletionInfo().getTopLevelDeletion().markedForDeleteAt;
                    }
                    temp.delete(cf);
                    ++this.sstablesIterated;
                    Tracing.trace("Merging data from sstable {}", sstable.descriptor.generation);
                    while (iter.hasNext()) {
                        temp.addAtom((OnDiskAtom)iter.next());
                    }
                }
                container.addAll(temp, HeapAllocator.instance);
                temp.clear();
            }
            if (iterators.isEmpty()) {
                Iterator<SSTableReader> i$ = null;
                return i$;
            }
            final ColumnFamily c2 = container;
            SimpleAbstractColumnIterator toCollate = new SimpleAbstractColumnIterator(){
                final Iterator<IColumn> iter;
                {
                    this.iter = c2.iterator();
                }

                protected OnDiskAtom computeNext() {
                    return this.iter.hasNext() ? (OnDiskAtom)this.iter.next() : (OnDiskAtom)this.endOfData();
                }

                @Override
                public ColumnFamily getColumnFamily() {
                    return c2;
                }

                @Override
                public DecoratedKey getKey() {
                    return ((CollationController)CollationController.this).filter.key;
                }
            };
            ColumnFamily returnCF = container.cloneMeShallow();
            Tracing.trace("Collating all results");
            this.filter.collateOnDiskAtom(returnCF, Collections.singletonList(toCollate), this.gcBefore);
            if (this.sstablesIterated > this.cfs.getMinimumCompactionThreshold() && !this.cfs.isCompactionDisabled() && this.cfs.getCompactionStrategy() instanceof SizeTieredCompactionStrategy) {
                Tracing.trace("Defragmenting requested data");
                RowMutation rm = new RowMutation(this.cfs.table.name, new Row(this.filter.key, returnCF.cloneMe()));
                Table.open(rm.getTable()).apply(rm, false, false);
            }
            ColumnFamily columnFamily = returnCF;
            return columnFamily;
        }
        finally {
            for (OnDiskAtomIterator iter : iterators) {
                FileUtils.closeQuietly(iter);
            }
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    private void reduceNameFilter(QueryFilter filter, ColumnFamily returnCF, long sstableTimestamp) {
        ColumnFamily container;
        AbstractColumnContainer abstractColumnContainer = container = filter.path.superColumnName == null ? returnCF : (SuperColumn)returnCF.getColumn(filter.path.superColumnName);
        if (container == null || sstableTimestamp == Long.MIN_VALUE) {
            return;
        }
        Iterator iterator = ((NamesQueryFilter)filter.filter).columns.iterator();
        while (iterator.hasNext()) {
            ByteBuffer filterColumn = (ByteBuffer)iterator.next();
            IColumn column = container.getColumn(filterColumn);
            if (column == null || column.timestamp() <= sstableTimestamp) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily collectAllData() {
        logger.trace("collectAllData");
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = this.cfs.markReferenced(this.filter.key);
        ArrayList<OnDiskAtomIterator> iterators = new ArrayList<OnDiskAtomIterator>(Iterables.size(view.memtables) + view.sstables.size());
        ColumnFamily returnCF = ColumnFamily.create(this.cfs.metadata, this.factory, this.filter.filter.isReversed());
        try {
            ColumnFamily columnFamily;
            Tracing.trace("Merging memtable contents");
            for (Memtable memtable : view.memtables) {
                OnDiskAtomIterator iter = this.filter.getMemtableColumnIterator(memtable);
                if (iter == null) continue;
                returnCF.delete(iter.getColumnFamily());
                iterators.add(iter);
            }
            Collections.sort(view.sstables, SSTable.maxTimestampComparator);
            long mostRecentRowTombstone = Long.MIN_VALUE;
            for (SSTableReader sstable : view.sstables) {
                if (sstable.getMaxTimestamp() < mostRecentRowTombstone) break;
                OnDiskAtomIterator iter = this.filter.getSSTableColumnIterator(sstable);
                iterators.add(iter);
                if (iter.getColumnFamily() == null) continue;
                ColumnFamily cf = iter.getColumnFamily();
                if (cf.isMarkedForDelete()) {
                    mostRecentRowTombstone = cf.deletionInfo().getTopLevelDeletion().markedForDeleteAt;
                }
                returnCF.delete(cf);
                ++this.sstablesIterated;
            }
            if (iterators.isEmpty()) {
                columnFamily = null;
                return columnFamily;
            }
            Tracing.trace("Merging data from memtables and {} sstables", this.sstablesIterated);
            this.filter.collateOnDiskAtom(returnCF, iterators, this.gcBefore);
            columnFamily = returnCF;
            return columnFamily;
        }
        finally {
            for (OnDiskAtomIterator iter : iterators) {
                FileUtils.closeQuietly(iter);
            }
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    public int getSstablesIterated() {
        return this.sstablesIterated;
    }
}

