/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.ReadCallback;

public class DatacenterReadCallback<TMessage, TResolved>
extends ReadCallback<TMessage, TResolved> {
    private static final Comparator<InetAddress> localComparator = new Comparator<InetAddress>(){

        @Override
        public int compare(InetAddress endpoint1, InetAddress endpoint2) {
            boolean local1 = ReadCallback.localdc.equals(ReadCallback.snitch.getDatacenter(endpoint1));
            boolean local2 = ReadCallback.localdc.equals(ReadCallback.snitch.getDatacenter(endpoint2));
            if (local1 && !local2) {
                return -1;
            }
            if (local2 && !local1) {
                return 1;
            }
            return 0;
        }
    };

    public DatacenterReadCallback(IResponseResolver resolver, ConsistencyLevel consistencyLevel, IReadCommand command, List<InetAddress> endpoints) {
        super(resolver, consistencyLevel, command, endpoints);
    }

    @Override
    protected void sortForConsistencyLevel(List<InetAddress> endpoints) {
        Collections.sort(endpoints, localComparator);
    }

    @Override
    protected boolean waitingFor(MessageIn message) {
        return localdc.equals(snitch.getDatacenter(message.from));
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        int localEndpoints = 0;
        for (InetAddress endpoint : this.endpoints) {
            if (!localdc.equals(snitch.getDatacenter(endpoint))) continue;
            ++localEndpoints;
        }
        if (localEndpoints < this.blockfor) {
            if (logger.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder("Local replicas [");
                for (InetAddress endpoint : this.endpoints) {
                    if (!localdc.equals(snitch.getDatacenter(endpoint))) continue;
                    builder.append(endpoint).append(",");
                }
                builder.append("] are insufficient to satisfy LOCAL_QUORUM requirement of ").append(this.blockfor).append(" live nodes in '").append(localdc).append("'");
                logger.debug(builder.toString());
            }
            throw new UnavailableException(this.consistencyLevel, this.blockfor, localEndpoints);
        }
    }
}

