/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.RowRepairResolver;
import org.apache.cassandra.utils.WrappedRunnable;

public class AsyncRepairCallback
implements IAsyncCallback {
    private final RowRepairResolver repairResolver;
    private final int blockfor;
    protected final AtomicInteger received = new AtomicInteger(0);

    public AsyncRepairCallback(RowRepairResolver repairResolver, int blockfor) {
        this.repairResolver = repairResolver;
        this.blockfor = blockfor;
    }

    public void response(MessageIn message) {
        this.repairResolver.preprocess(message);
        if (this.received.incrementAndGet() == this.blockfor) {
            StageManager.getStage(Stage.READ_REPAIR).execute(new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws DigestMismatchException, IOException {
                    AsyncRepairCallback.this.repairResolver.resolve();
                }
            });
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return true;
    }
}

