/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.net.OutboundTcpConnectionPool;

public class ConnectionMetrics {
    public static final String GROUP_NAME = "org.apache.cassandra.metrics";
    public static final String TYPE_NAME = "Connection";
    public static final Meter totalTimeouts = Metrics.newMeter((MetricName)new MetricName("org.apache.cassandra.metrics", "Connection", "TotalTimeouts"), (String)"total timeouts", (TimeUnit)TimeUnit.SECONDS);
    private static long recentTimeouts;
    public final String address;
    public final Gauge<Integer> commandPendingTasks;
    public final Gauge<Long> commandCompletedTasks;
    public final Gauge<Long> commandDroppedTasks;
    public final Gauge<Integer> responsePendingTasks;
    public final Gauge<Long> responseCompletedTasks;
    public final Meter timeouts;
    private long recentTimeoutCount;

    public ConnectionMetrics(InetAddress ip, final OutboundTcpConnectionPool connectionPool) {
        this.address = ip.getHostAddress();
        this.commandPendingTasks = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "CommandPendingTasks", this.address), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return connectionPool.cmdCon.getPendingMessages();
            }
        });
        this.commandCompletedTasks = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "CommandCompletedTasks", this.address), (Gauge)new Gauge<Long>(){

            public Long value() {
                return connectionPool.cmdCon.getCompletedMesssages();
            }
        });
        this.commandDroppedTasks = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "CommandDroppedTasks", this.address), (Gauge)new Gauge<Long>(){

            public Long value() {
                return connectionPool.cmdCon.getDroppedMessages();
            }
        });
        this.responsePendingTasks = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "ResponsePendingTasks", this.address), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return connectionPool.ackCon.getPendingMessages();
            }
        });
        this.responseCompletedTasks = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "ResponseCompletedTasks", this.address), (Gauge)new Gauge<Long>(){

            public Long value() {
                return connectionPool.ackCon.getCompletedMesssages();
            }
        });
        this.timeouts = Metrics.newMeter((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "Timeouts", this.address), (String)"timeouts", (TimeUnit)TimeUnit.SECONDS);
    }

    public void release() {
        Metrics.defaultRegistry().removeMetric(new MetricName(GROUP_NAME, TYPE_NAME, "CommandPendingTasks", this.address));
        Metrics.defaultRegistry().removeMetric(new MetricName(GROUP_NAME, TYPE_NAME, "CommandCompletedTasks", this.address));
        Metrics.defaultRegistry().removeMetric(new MetricName(GROUP_NAME, TYPE_NAME, "CommandDroppedTasks", this.address));
        Metrics.defaultRegistry().removeMetric(new MetricName(GROUP_NAME, TYPE_NAME, "ResponsePendingTasks", this.address));
        Metrics.defaultRegistry().removeMetric(new MetricName(GROUP_NAME, TYPE_NAME, "ResponseCompletedTasks", this.address));
        Metrics.defaultRegistry().removeMetric(new MetricName(GROUP_NAME, TYPE_NAME, "Timeouts", this.address));
    }

    @Deprecated
    public static long getRecentTotalTimeout() {
        long total = totalTimeouts.count();
        long recent = total - recentTimeouts;
        recentTimeouts = total;
        return recent;
    }

    @Deprecated
    public long getRecentTimeout() {
        long timeoutCount = this.timeouts.count();
        long recent = timeoutCount - this.recentTimeoutCount;
        this.recentTimeoutCount = timeoutCount;
        return recent;
    }
}

