/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.JdbcInetAddress;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class InetAddressType
extends AbstractType<InetAddress> {
    public static final InetAddressType instance = new InetAddressType();

    InetAddressType() {
    }

    @Override
    public InetAddress compose(ByteBuffer bytes) {
        return JdbcInetAddress.instance.compose(bytes);
    }

    @Override
    public ByteBuffer decompose(InetAddress value) {
        return JdbcInetAddress.instance.decompose(value);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return JdbcInetAddress.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        InetAddress address;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            address = InetAddress.getByName(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make inetaddress from '%s'", source), e);
        }
        return this.decompose(address);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        try {
            InetAddress.getByAddress(ByteBufferUtil.getArray(bytes));
        }
        catch (UnknownHostException e) {
            throw new MarshalException(String.format("Expected 4 or 16 byte inetaddress; got %s", ByteBufferUtil.bytesToHex(bytes)));
        }
    }
}

