/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.Selector;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.RangeSliceVerbHandler;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStatement
implements CQLStatement {
    private static final Logger logger = LoggerFactory.getLogger(SelectStatement.class);
    private final int boundTerms;
    public final CFDefinition cfDef;
    public final Parameters parameters;
    private final List<Pair<CFDefinition.Name, Selector>> selectedNames = new ArrayList<Pair<CFDefinition.Name, Selector>>();
    private final Restriction[] keyRestrictions;
    private final Restriction[] columnRestrictions;
    private final Map<CFDefinition.Name, Restriction> metadataRestrictions = new HashMap<CFDefinition.Name, Restriction>();
    private Restriction sliceRestriction;
    private boolean isReversed;
    private boolean onToken;
    private boolean isKeyRange;
    private boolean keyIsInRelation;

    public SelectStatement(CFDefinition cfDef, int boundTerms, Parameters parameters) {
        this.cfDef = cfDef;
        this.boundTerms = boundTerms;
        this.keyRestrictions = new Restriction[cfDef.keys.size()];
        this.columnRestrictions = new Restriction[cfDef.columns.size()];
        this.parameters = parameters;
    }

    @Override
    public int getBoundsTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage.Rows execute(ConsistencyLevel cl, QueryState state, List<ByteBuffer> variables) throws RequestExecutionException, RequestValidationException {
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        cl.validateForRead(this.keyspace());
        try {
            List<Row> rows = this.isKeyRange ? StorageProxy.getRangeSlice(this.getRangeCommand(variables), cl) : StorageProxy.read(this.getSliceCommands(variables), cl);
            return this.processResults(rows, variables);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ResultMessage.Rows processResults(List<Row> rows, List<ByteBuffer> variables) throws RequestValidationException {
        ResultSet rset = this.process(rows, variables);
        rset = this.parameters.isCount ? rset.makeCountResult() : rset;
        return new ResultMessage.Rows(rset);
    }

    static List<Row> readLocally(String keyspace, List<ReadCommand> cmds) throws IOException {
        Table table = Table.open(keyspace);
        ArrayList<Row> rows = new ArrayList<Row>(cmds.size());
        for (ReadCommand cmd : cmds) {
            rows.add(cmd.getRow(table));
        }
        return rows;
    }

    @Override
    public ResultMessage.Rows executeInternal(QueryState state) throws RequestExecutionException, RequestValidationException {
        try {
            List<Row> rows = this.isKeyRange ? RangeSliceVerbHandler.executeLocally(this.getRangeCommand(Collections.<ByteBuffer>emptyList())) : SelectStatement.readLocally(this.keyspace(), this.getSliceCommands(Collections.<ByteBuffer>emptyList()));
            return this.processResults(rows, Collections.<ByteBuffer>emptyList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ResultSet process(List<Row> rows) throws InvalidRequestException {
        assert (!this.parameters.isCount);
        return this.process(rows, Collections.<ByteBuffer>emptyList());
    }

    public String keyspace() {
        return this.cfDef.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfDef.cfm.cfName;
    }

    private List<ReadCommand> getSliceCommands(List<ByteBuffer> variables) throws RequestValidationException {
        QueryPath queryPath = new QueryPath(this.columnFamily());
        Collection<ByteBuffer> keys = this.getKeys(variables);
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        if (this.isColumnRange()) {
            for (ByteBuffer key : keys) {
                QueryProcessor.validateKey(key);
                commands.add(new SliceFromReadCommand(this.keyspace(), key, queryPath, (SliceQueryFilter)this.makeFilter(variables)));
            }
        } else {
            IDiskAtomFilter filter = this.makeFilter(variables);
            for (ByteBuffer key : keys) {
                QueryProcessor.validateKey(key);
                commands.add(new SliceByNamesReadCommand(this.keyspace(), key, queryPath, (NamesQueryFilter)filter));
            }
        }
        return commands;
    }

    private RangeSliceCommand getRangeCommand(List<ByteBuffer> variables) throws RequestValidationException {
        IDiskAtomFilter filter = this.makeFilter(variables);
        List<IndexExpression> expressions = this.getIndexExpressions(variables);
        return new RangeSliceCommand(this.keyspace(), this.columnFamily(), null, filter, this.getKeyBounds(variables), expressions, this.getLimit(), true, false);
    }

    private AbstractBounds<RowPosition> getKeyBounds(List<ByteBuffer> variables) throws InvalidRequestException {
        AbstractBounds bounds;
        IPartitioner p = StorageService.getPartitioner();
        if (this.onToken) {
            Token startToken = this.getTokenBound(Bound.START, variables, p);
            Token endToken = this.getTokenBound(Bound.END, variables, p);
            Token.KeyBound start = this.includeKeyBound(Bound.START) ? startToken.minKeyBound() : startToken.maxKeyBound();
            Token.KeyBound end = this.includeKeyBound(Bound.END) ? endToken.maxKeyBound() : endToken.minKeyBound();
            bounds = new Range<RowPosition>(start, end);
        } else {
            RowPosition finishKey;
            ByteBuffer startKeyBytes = this.getKeyBound(Bound.START, variables);
            ByteBuffer finishKeyBytes = this.getKeyBound(Bound.END, variables);
            RowPosition startKey = RowPosition.forKey(startKeyBytes, p);
            if (startKey.compareTo(finishKey = RowPosition.forKey(finishKeyBytes, p)) > 0 && !finishKey.isMinimum(p)) {
                if (p instanceof RandomPartitioner) {
                    throw new InvalidRequestException("Start key sorts after end key. This is not allowed; you probably should not specify end key at all, under RandomPartitioner");
                }
                throw new InvalidRequestException("Start key must sort before (or equal to) finish key in your partitioner!");
            }
            bounds = this.includeKeyBound(Bound.START) ? (this.includeKeyBound(Bound.END) ? new Bounds<RowPosition>(startKey, finishKey) : new IncludingExcludingBounds<RowPosition>(startKey, finishKey)) : (this.includeKeyBound(Bound.END) ? new Range<RowPosition>(startKey, finishKey) : new ExcludingBounds<RowPosition>(startKey, finishKey));
        }
        return bounds;
    }

    private IDiskAtomFilter makeFilter(List<ByteBuffer> variables) throws InvalidRequestException {
        if (this.isColumnRange()) {
            int multiplier = this.cfDef.isCompact ? 1 : this.cfDef.metadata.size() + 1;
            int toGroup = this.cfDef.isCompact ? -1 : this.cfDef.columns.size();
            ColumnSlice slice = new ColumnSlice(this.getRequestedBound(Bound.START, variables), this.getRequestedBound(Bound.END, variables));
            SliceQueryFilter filter = new SliceQueryFilter(new ColumnSlice[]{slice}, this.isReversed, this.getLimit(), toGroup, multiplier);
            QueryProcessor.validateSliceFilter(this.cfDef.cfm, filter);
            return filter;
        }
        SortedSet<ByteBuffer> columnNames = this.getRequestedColumns(variables);
        QueryProcessor.validateColumnNames(columnNames);
        return new NamesQueryFilter(columnNames, true);
    }

    private int getLimit() {
        return this.sliceRestriction != null && !this.sliceRestriction.isInclusive(Bound.START) && this.parameters.limit != Integer.MAX_VALUE ? this.parameters.limit + 1 : this.parameters.limit;
    }

    private Collection<ByteBuffer> getKeys(List<ByteBuffer> variables) throws InvalidRequestException {
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        ColumnNameBuilder builder = this.cfDef.getKeyNameBuilder();
        for (CFDefinition.Name name : this.cfDef.keys.values()) {
            Restriction r = this.keyRestrictions[name.position];
            assert (r != null);
            if (builder.remainingCount() == 1) {
                for (Term t : r.eqValues) {
                    keys.add(builder.copy().add(t, Relation.Type.EQ, variables).build());
                }
                continue;
            }
            if (r.eqValues.size() > 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            builder.add(r.eqValues.get(0), Relation.Type.EQ, variables);
        }
        return keys;
    }

    private ByteBuffer getKeyBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        return SelectStatement.buildBound(b, this.cfDef.keys.values(), this.keyRestrictions, this.isReversed, this.cfDef.getKeyNameBuilder(), variables);
    }

    private Token getTokenBound(Bound b, List<ByteBuffer> variables, IPartitioner<?> p) throws InvalidRequestException {
        Term t;
        assert (this.onToken);
        Restriction keyRestriction = this.keyRestrictions[0];
        Term term = t = keyRestriction.isEquality() ? keyRestriction.eqValues.get(0) : keyRestriction.bound(b);
        if (t == null) {
            return p.getMinimumToken();
        }
        if (t.getType() == Term.Type.STRING && !t.isToken) {
            try {
                String text = t.getText();
                p.getTokenFactory().validate(text);
                return p.getTokenFactory().fromString(text);
            }
            catch (ConfigurationException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }
        assert (t.isToken);
        ColumnNameBuilder builder = this.cfDef.getKeyNameBuilder();
        for (CFDefinition.Name name : this.cfDef.keys.values()) {
            Restriction r = this.keyRestrictions[name.position];
            builder.add(r.isEquality() ? r.eqValues.get(0) : r.bound(b), Relation.Type.EQ, variables);
        }
        return p.getToken(builder.build());
    }

    private boolean includeKeyBound(Bound b) {
        for (Restriction r : this.keyRestrictions) {
            if (r == null) {
                return true;
            }
            if (r.isEquality()) continue;
            return r.isInclusive(b);
        }
        return true;
    }

    private boolean isColumnRange() {
        if (!this.cfDef.isCompact && !this.cfDef.isComposite) {
            return false;
        }
        if (this.cfDef.hasCollections) {
            return true;
        }
        for (Restriction r : this.columnRestrictions) {
            if (r != null && r.isEquality()) continue;
            return true;
        }
        return false;
    }

    private boolean isWildcard() {
        return this.selectedNames.isEmpty();
    }

    private SortedSet<ByteBuffer> getRequestedColumns(List<ByteBuffer> variables) throws InvalidRequestException {
        assert (!this.isColumnRange());
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        for (Restriction r : this.columnRestrictions) {
            assert (r != null && r.isEquality());
            if (r.eqValues.size() > 1) {
                assert (this.cfDef.isCompact);
                TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfDef.cfm.comparator);
                Iterator<Term> iter = r.eqValues.iterator();
                while (iter.hasNext()) {
                    Term v = iter.next();
                    ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                    ByteBuffer cname = b.add(v, Relation.Type.EQ, variables).build();
                    columns.add(cname);
                }
                return columns;
            }
            builder.add(r.eqValues.get(0), Relation.Type.EQ, variables);
        }
        if (this.cfDef.isCompact) {
            return FBUtilities.singleton(builder.build());
        }
        assert (!this.cfDef.hasCollections);
        TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfDef.cfm.comparator);
        if (this.cfDef.isComposite) {
            columns.add(builder.copy().add(ByteBufferUtil.EMPTY_BYTE_BUFFER).build());
            for (Pair<CFDefinition.Name, Selector> p : this.getExpandedSelection()) {
                columns.add(builder.copy().add(((Selector)p.right).id().key).build());
            }
        } else {
            Iterator<ColumnIdentifier> iter = this.cfDef.metadata.keySet().iterator();
            while (iter.hasNext()) {
                ColumnIdentifier name = iter.next();
                ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                ByteBuffer cname = b.add(name.key).build();
                columns.add(cname);
            }
        }
        return columns;
    }

    private static ByteBuffer buildBound(Bound bound, Collection<CFDefinition.Name> names, Restriction[] restrictions, boolean isReversed, ColumnNameBuilder builder, List<ByteBuffer> variables) throws InvalidRequestException {
        Bound eocBound = isReversed ? Bound.reverse(bound) : bound;
        for (CFDefinition.Name name : names) {
            Bound b = isReversed == SelectStatement.isReversedType(name) ? bound : Bound.reverse(bound);
            Restriction r = restrictions[name.position];
            if (r == null || !r.isEquality() && r.bound(b) == null) {
                if (builder.componentCount() > 0 && eocBound == Bound.END) {
                    return builder.buildAsEndOfRange();
                }
                return builder.build();
            }
            if (r.isEquality()) {
                assert (r.eqValues.size() == 1);
                builder.add(r.eqValues.get(0), Relation.Type.EQ, variables);
                continue;
            }
            Term t = r.bound(b);
            assert (t != null);
            return builder.add(t, r.getRelation(eocBound, b), variables).build();
        }
        return bound == Bound.END ? builder.buildAsEndOfRange() : builder.build();
    }

    private ByteBuffer getRequestedBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.isColumnRange());
        return SelectStatement.buildBound(b, this.cfDef.columns.values(), this.columnRestrictions, this.isReversed, this.cfDef.getColumnNameBuilder(), variables);
    }

    private List<IndexExpression> getIndexExpressions(List<ByteBuffer> variables) throws InvalidRequestException {
        if (this.metadataRestrictions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (Map.Entry<CFDefinition.Name, Restriction> entry : this.metadataRestrictions.entrySet()) {
            CFDefinition.Name name = entry.getKey();
            Restriction restriction = entry.getValue();
            if (restriction.isEquality()) {
                for (Term t : restriction.eqValues) {
                    ByteBuffer value = t.getByteBuffer(name.type, variables);
                    if (value.remaining() > 65535) {
                        throw new InvalidRequestException("Index expression values may not be larger than 64K");
                    }
                    expressions.add(new IndexExpression(name.name.key, IndexOperator.EQ, value));
                }
                continue;
            }
            for (Bound b : Bound.values()) {
                if (restriction.bound(b) == null) continue;
                ByteBuffer value = restriction.bound(b).getByteBuffer(name.type, variables);
                if (value.remaining() > 65535) {
                    throw new InvalidRequestException("Index expression values may not be larger than 64K");
                }
                expressions.add(new IndexExpression(name.name.key, restriction.getIndexOperator(b), value));
            }
        }
        return expressions;
    }

    private List<Pair<CFDefinition.Name, Selector>> getExpandedSelection() {
        if (this.selectedNames.isEmpty()) {
            ArrayList<Pair<CFDefinition.Name, Selector>> selection = new ArrayList<Pair<CFDefinition.Name, Selector>>();
            for (CFDefinition.Name name : this.cfDef) {
                selection.add(Pair.create(name, name.name));
            }
            return selection;
        }
        return this.selectedNames;
    }

    private ByteBuffer value(IColumn c) {
        return c instanceof CounterColumn ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
    }

    private void addReturnValue(ResultSet cqlRows, Selector s, IColumn c) {
        if (c == null || c.isMarkedForDelete()) {
            cqlRows.addColumnValue(null);
            return;
        }
        if (s.hasFunction()) {
            switch (s.function()) {
                case WRITE_TIME: {
                    cqlRows.addColumnValue(ByteBufferUtil.bytes(c.timestamp()));
                    break;
                }
                case TTL: {
                    if (c instanceof ExpiringColumn) {
                        int ttl = ((ExpiringColumn)c).getLocalDeletionTime() - (int)(System.currentTimeMillis() / 1000L);
                        cqlRows.addColumnValue(ByteBufferUtil.bytes(ttl));
                        break;
                    }
                    cqlRows.addColumnValue(null);
                }
            }
        } else {
            cqlRows.addColumnValue(this.value(c));
        }
    }

    private ResultSet createResult(List<Pair<CFDefinition.Name, Selector>> selection) {
        ArrayList<ColumnSpecification> names = new ArrayList<ColumnSpecification>(selection.size());
        for (Pair<CFDefinition.Name, Selector> p : selection) {
            if (((Selector)p.right).hasFunction()) {
                switch (((Selector)p.right).function()) {
                    case WRITE_TIME: {
                        names.add(new ColumnSpecification(((CFDefinition.Name)p.left).ksName, ((CFDefinition.Name)p.left).cfName, new ColumnIdentifier(((Selector)p.right).toString(), true), LongType.instance));
                        break;
                    }
                    case TTL: {
                        names.add(new ColumnSpecification(((CFDefinition.Name)p.left).ksName, ((CFDefinition.Name)p.left).cfName, new ColumnIdentifier(((Selector)p.right).toString(), true), Int32Type.instance));
                    }
                }
                continue;
            }
            names.add((ColumnSpecification)p.left);
        }
        return new ResultSet(names);
    }

    private Iterable<IColumn> columnsInOrder(final ColumnFamily cf, List<ByteBuffer> variables) throws InvalidRequestException {
        Restriction last = this.columnRestrictions[this.columnRestrictions.length - 1];
        if (last == null || !last.isEquality()) {
            return cf.getSortedColumns();
        }
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        for (int i = 0; i < this.columnRestrictions.length - 1; ++i) {
            builder.add(this.columnRestrictions[i].eqValues.get(0), Relation.Type.EQ, variables);
        }
        final ArrayList<ByteBuffer> requested = new ArrayList<ByteBuffer>(last.eqValues.size());
        Iterator<Term> iter = last.eqValues.iterator();
        while (iter.hasNext()) {
            Term t = iter.next();
            ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
            requested.add(b.add(t, Relation.Type.EQ, variables).build());
        }
        return new Iterable<IColumn>(){

            @Override
            public Iterator<IColumn> iterator() {
                return new AbstractIterator<IColumn>(){
                    Iterator<ByteBuffer> iter;
                    {
                        this.iter = requested.iterator();
                    }

                    public IColumn computeNext() {
                        if (!this.iter.hasNext()) {
                            return (IColumn)this.endOfData();
                        }
                        IColumn column = cf.getColumn(this.iter.next());
                        return column == null ? this.computeNext() : column;
                    }
                };
            }
        };
    }

    private ResultSet process(List<Row> rows, List<ByteBuffer> variables) throws InvalidRequestException {
        List<Pair<CFDefinition.Name, Selector>> selection = this.getExpandedSelection();
        ResultSet cqlRows = this.createResult(selection);
        for (Row row : rows) {
            if (row.cf == null) continue;
            ByteBuffer[] keyComponents = null;
            keyComponents = this.cfDef.hasCompositeKey ? ((CompositeType)this.cfDef.cfm.getKeyValidator()).split(row.key.key) : new ByteBuffer[]{row.key.key};
            if (this.cfDef.isCompact) {
                for (IColumn iColumn : this.columnsInOrder(row.cf, variables)) {
                    if (iColumn.isMarkedForDelete()) continue;
                    ByteBuffer[] components = null;
                    if (this.cfDef.isComposite) {
                        components = ((CompositeType)this.cfDef.cfm.comparator).split(iColumn.name());
                    } else if (this.sliceRestriction != null && (!this.sliceRestriction.isInclusive(Bound.START) && iColumn.name().equals(this.sliceRestriction.bound(Bound.START).getByteBuffer(this.cfDef.cfm.comparator, variables)) || !this.sliceRestriction.isInclusive(Bound.END) && iColumn.name().equals(this.sliceRestriction.bound(Bound.END).getByteBuffer(this.cfDef.cfm.comparator, variables)))) continue;
                    block8: for (Pair<CFDefinition.Name, Selector> p : selection) {
                        CFDefinition.Name name = (CFDefinition.Name)p.left;
                        Selector selector = (Selector)p.right;
                        switch (name.kind) {
                            case KEY_ALIAS: {
                                cqlRows.addColumnValue(keyComponents[name.position]);
                                continue block8;
                            }
                            case COLUMN_ALIAS: {
                                if (this.cfDef.isComposite) {
                                    if (name.position < components.length) {
                                        cqlRows.addColumnValue(components[name.position]);
                                        continue block8;
                                    }
                                    cqlRows.addColumnValue(null);
                                    continue block8;
                                }
                                cqlRows.addColumnValue(iColumn.name());
                                continue block8;
                            }
                            case VALUE_ALIAS: {
                                this.addReturnValue(cqlRows, selector, iColumn);
                                continue block8;
                            }
                            case COLUMN_METADATA: {
                                throw new AssertionError();
                            }
                        }
                        throw new AssertionError();
                    }
                }
                continue;
            }
            if (this.cfDef.isComposite) {
                CompositeType composite = (CompositeType)this.cfDef.cfm.comparator;
                ColumnGroupMap.Builder builder = new ColumnGroupMap.Builder(composite, this.cfDef.hasCollections);
                for (IColumn c : row.cf) {
                    if (c.isMarkedForDelete()) continue;
                    builder.add(c);
                }
                for (ColumnGroupMap group : builder.groups()) {
                    this.handleGroup(selection, row.key.key, keyComponents, group, cqlRows);
                }
                continue;
            }
            if (row.cf.hasOnlyTombstones()) continue;
            for (Pair pair : selection) {
                CFDefinition.Name name = (CFDefinition.Name)pair.left;
                Selector selector = (Selector)pair.right;
                if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS) {
                    cqlRows.addColumnValue(keyComponents[name.position]);
                    continue;
                }
                IColumn c = row.cf.getColumn(name.name.key);
                this.addReturnValue(cqlRows, selector, c);
            }
        }
        this.orderResults(selection, cqlRows);
        if (this.isReversed) {
            cqlRows.reverse();
        }
        cqlRows.trim(this.parameters.limit);
        return cqlRows;
    }

    private void orderResults(List<Pair<CFDefinition.Name, Selector>> selection, ResultSet cqlRows) {
        if (cqlRows.size() == 0 || this.parameters.orderings.isEmpty() || this.isKeyRange || !this.keyIsInRelation) {
            return;
        }
        if (this.parameters.orderings.size() == 1) {
            CFDefinition.Name ordering = this.cfDef.get((ColumnIdentifier)this.parameters.orderings.keySet().iterator().next());
            Collections.sort(cqlRows.rows, new SingleColumnComparator(this.getColumnPositionInSelect(selection, ordering), ordering.type));
            return;
        }
        ArrayList<AbstractType> types = new ArrayList<AbstractType>(this.parameters.orderings.size());
        int[] positions = new int[this.parameters.orderings.size()];
        int idx = 0;
        for (ColumnIdentifier identifier : this.parameters.orderings.keySet()) {
            CFDefinition.Name orderingColumn = this.cfDef.get(identifier);
            types.add(orderingColumn.type);
            positions[idx++] = this.getColumnPositionInSelect(selection, orderingColumn);
        }
        Collections.sort(cqlRows.rows, new CompositeComparator(types, positions));
    }

    private int getColumnPositionInSelect(List<Pair<CFDefinition.Name, Selector>> selection, CFDefinition.Name columnName) {
        for (int i = 0; i < selection.size(); ++i) {
            if (!((CFDefinition.Name)selection.get((int)i).left).equals(columnName)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column %s wasn't found in select clause.", columnName));
    }

    private static boolean isSameRow(ByteBuffer[] c1, ByteBuffer[] c2) {
        assert (c1.length == c2.length) : "Sparse composite should not have partial column names";
        for (int i = 0; i < c1.length - 1; ++i) {
            if (c1[i].equals(c2[i])) continue;
            return false;
        }
        return true;
    }

    private void handleGroup(List<Pair<CFDefinition.Name, Selector>> selection, ByteBuffer key, ByteBuffer[] keyComponents, ColumnGroupMap columns, ResultSet cqlRows) {
        block6: for (Pair<CFDefinition.Name, Selector> p : selection) {
            CFDefinition.Name name = (CFDefinition.Name)p.left;
            Selector selector = (Selector)p.right;
            switch (name.kind) {
                case KEY_ALIAS: {
                    cqlRows.addColumnValue(keyComponents[name.position]);
                    continue block6;
                }
                case COLUMN_ALIAS: {
                    cqlRows.addColumnValue(columns.getKeyComponent(name.position));
                    continue block6;
                }
                case VALUE_ALIAS: {
                    throw new AssertionError();
                }
                case COLUMN_METADATA: {
                    if (name.type.isCollection()) {
                        List<Pair<ByteBuffer, IColumn>> collection = columns.getCollection(name.name.key);
                        if (collection == null) {
                            cqlRows.addColumnValue(null);
                            continue block6;
                        }
                        cqlRows.addColumnValue(((CollectionType)name.type).serialize(collection));
                        continue block6;
                    }
                    IColumn c = columns.getSimple(name.name.key);
                    this.addReturnValue(cqlRows, selector, c);
                    continue block6;
                }
            }
            throw new AssertionError();
        }
    }

    private static boolean isReversedType(CFDefinition.Name name) {
        return name.type instanceof ReversedType;
    }

    private boolean columnFilterIsIdentity() {
        for (Restriction r : this.columnRestrictions) {
            if (r == null) continue;
            return false;
        }
        return true;
    }

    private static class CompositeComparator
    implements Comparator<List<ByteBuffer>> {
        private final List<AbstractType<?>> orderTypes;
        private final int[] positions;

        private CompositeComparator(List<AbstractType<?>> orderTypes, int[] positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.length; ++i) {
                ByteBuffer bValue;
                int columnPos;
                ByteBuffer aValue;
                AbstractType<?> type = this.orderTypes.get(i);
                int comparison = type.compare(aValue = a.get(columnPos = this.positions[i]), bValue = b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    implements Comparator<List<ByteBuffer>> {
        private final int index;
        private final AbstractType<?> comparator;

        public SingleColumnComparator(int columnIndex, AbstractType<?> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.comparator.compare(a.get(this.index), b.get(this.index));
        }
    }

    public static class Parameters {
        private final int limit;
        private final Map<ColumnIdentifier, Boolean> orderings;
        private final boolean isCount;
        private final boolean allowFiltering;

        public Parameters(int limit, Map<ColumnIdentifier, Boolean> orderings, boolean isCount, boolean allowFiltering) {
            this.limit = limit;
            this.orderings = orderings;
            this.isCount = isCount;
            this.allowFiltering = allowFiltering;
        }
    }

    private static class Restriction {
        List<Term> eqValues;
        private final Term[] bounds;
        private final boolean[] boundInclusive;
        final boolean onToken;

        Restriction(List<Term> values) {
            this.eqValues = values;
            this.bounds = null;
            this.boundInclusive = null;
            this.onToken = false;
        }

        Restriction(Term value, boolean onToken) {
            this(Collections.singletonList(value));
        }

        Restriction(boolean onToken) {
            this.eqValues = null;
            this.bounds = new Term[2];
            this.boundInclusive = new boolean[2];
            this.onToken = onToken;
        }

        boolean isEquality() {
            return this.eqValues != null;
        }

        public void setBound(Bound b, Term t) {
            this.bounds[b.idx] = t;
        }

        public void setInclusive(Bound b) {
            this.boundInclusive[b.idx] = true;
        }

        public Term bound(Bound b) {
            return this.bounds[b.idx];
        }

        public boolean isInclusive(Bound b) {
            return this.bounds[b.idx] == null || this.boundInclusive[b.idx];
        }

        public Relation.Type getRelation(Bound eocBound, Bound inclusiveBound) {
            switch (eocBound) {
                case START: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.GTE : Relation.Type.GT;
                }
                case END: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.LTE : Relation.Type.LT;
                }
            }
            throw new AssertionError();
        }

        public IndexOperator getIndexOperator(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? IndexOperator.GTE : IndexOperator.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? IndexOperator.LTE : IndexOperator.LT;
                }
            }
            throw new AssertionError();
        }

        public void setBound(ColumnIdentifier name, Relation.Type type, Term t) throws InvalidRequestException {
            Bound b = null;
            boolean inclusive = false;
            switch (type) {
                case GT: {
                    b = Bound.START;
                    inclusive = false;
                    break;
                }
                case GTE: {
                    b = Bound.START;
                    inclusive = true;
                    break;
                }
                case LT: {
                    b = Bound.END;
                    inclusive = false;
                    break;
                }
                case LTE: {
                    b = Bound.END;
                    inclusive = true;
                }
            }
            if (this.bounds == null) {
                throw new InvalidRequestException(String.format("%s cannot be restricted by both an equal and an inequal relation", name));
            }
            if (this.bounds[b.idx] != null) {
                throw new InvalidRequestException(String.format("Invalid restrictions found on %s", name));
            }
            this.bounds[b.idx] = t;
            this.boundInclusive[b.idx] = inclusive;
        }

        public String toString() {
            String s = this.eqValues == null ? String.format("SLICE(%s %s, %s %s)", this.boundInclusive[0] ? ">=" : ">", this.bounds[0], this.boundInclusive[1] ? "<=" : "<", this.bounds[1]) : String.format("EQ(%s)", this.eqValues);
            return this.onToken ? s + "*" : s;
        }
    }

    public static class RawStatement
    extends CFStatement {
        private final Parameters parameters;
        private final List<Selector> selectClause;
        private final List<Relation> whereClause;

        public RawStatement(CFName cfName, Parameters parameters, List<Selector> selectClause, List<Relation> whereClause) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause == null ? Collections.emptyList() : whereClause;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            Restriction restriction;
            CFDefinition.Name cname;
            int i;
            CFDefinition.Name name;
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            if (this.parameters.limit <= 0) {
                throw new InvalidRequestException("LIMIT must be strictly positive");
            }
            CFDefinition cfDef = cfm.getCfDef();
            SelectStatement stmt = new SelectStatement(cfDef, this.getBoundsTerms(), this.parameters);
            CFDefinition.Name[] names = new CFDefinition.Name[this.getBoundsTerms()];
            if (this.parameters.isCount) {
                if (!this.selectClause.isEmpty()) {
                    throw new InvalidRequestException("Only COUNT(*) and COUNT(1) operations are currently supported.");
                }
            } else {
                for (Selector t : this.selectClause) {
                    name = cfDef.get(t.id());
                    if (name == null) {
                        throw new InvalidRequestException(String.format("Undefined name %s in selection clause", t.id()));
                    }
                    if (t.hasFunction() && name.kind != CFDefinition.Name.Kind.COLUMN_METADATA && name.kind != CFDefinition.Name.Kind.VALUE_ALIAS) {
                        throw new InvalidRequestException(String.format("Cannot use function %s on PRIMARY KEY part %s", new Object[]{t.function(), name}));
                    }
                    if (t.hasFunction() && name.type.isCollection()) {
                        throw new InvalidRequestException(String.format("Function %s is not supported on collections", new Object[]{t.function()}));
                    }
                    stmt.selectedNames.add(Pair.create(name, t));
                }
            }
            for (Relation rel : this.whereClause) {
                name = cfDef.get(rel.getEntity());
                if (name == null) {
                    throw new InvalidRequestException(String.format("Undefined name %s in where clause ('%s')", rel.getEntity(), rel));
                }
                if (rel.operator() == Relation.Type.IN) {
                    for (Term value : rel.getInValues()) {
                        if (!value.isBindMarker()) continue;
                        names[value.bindIndex] = name;
                    }
                } else {
                    Term value = rel.getValue();
                    if (value.isBindMarker()) {
                        names[value.bindIndex] = name;
                    }
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        if (rel.operator() != Relation.Type.EQ && rel.operator() != Relation.Type.IN && !rel.onToken && !StorageService.getPartitioner().preservesOrder()) {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on the partition key for RandomPartitioner (unless you use the token() function)");
                        }
                        ((SelectStatement)stmt).keyRestrictions[name.position] = this.updateRestriction(name, stmt.keyRestrictions[name.position], rel);
                        break;
                    }
                    case COLUMN_ALIAS: {
                        ((SelectStatement)stmt).columnRestrictions[name.position] = this.updateRestriction(name, stmt.columnRestrictions[name.position], rel);
                        break;
                    }
                    case VALUE_ALIAS: {
                        throw new InvalidRequestException(String.format("Restricting the value of a compact CF (%s) is not supported", name.name));
                    }
                    case COLUMN_METADATA: {
                        stmt.metadataRestrictions.put(name, this.updateRestriction(name, (Restriction)stmt.metadataRestrictions.get(name), rel));
                    }
                }
            }
            boolean shouldBeDone = false;
            CFDefinition.Name previous = null;
            Iterator<CFDefinition.Name> iter = cfDef.columns.values().iterator();
            for (i = 0; i < stmt.columnRestrictions.length; ++i) {
                cname = iter.next();
                restriction = stmt.columnRestrictions[i];
                if (restriction == null) {
                    shouldBeDone = true;
                } else {
                    if (shouldBeDone) {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cname, previous));
                    }
                    if (!restriction.isEquality()) {
                        shouldBeDone = true;
                        if (!(cfDef.isComposite || restriction.isInclusive(Bound.START) && restriction.isInclusive(Bound.END))) {
                            stmt.sliceRestriction = restriction;
                        }
                    } else if (!(restriction.eqValues.size() <= 1 || cfDef.isCompact && i == stmt.columnRestrictions.length - 1)) {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted by IN relation", cname));
                    }
                }
                previous = cname;
            }
            shouldBeDone = false;
            previous = null;
            stmt.keyIsInRelation = false;
            iter = cfDef.keys.values().iterator();
            for (i = 0; i < stmt.keyRestrictions.length; ++i) {
                cname = iter.next();
                restriction = stmt.keyRestrictions[i];
                if (restriction == null) {
                    if (stmt.onToken) {
                        throw new InvalidRequestException(String.format("The token() function must be applied to all partition key components or none of them", new Object[0]));
                    }
                    stmt.isKeyRange = true;
                    shouldBeDone = true;
                } else {
                    if (shouldBeDone) {
                        throw new InvalidRequestException(String.format("partition key part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cname, previous));
                    }
                    if (restriction.onToken) {
                        stmt.isKeyRange = true;
                        stmt.onToken = true;
                        if (restriction.isEquality() && restriction.eqValues.size() > 1) {
                            throw new InvalidRequestException("Select using the token() function don't support IN clause");
                        }
                    } else {
                        if (stmt.onToken) {
                            throw new InvalidRequestException(String.format("The token() function must be applied to all partition key components or none of them", new Object[0]));
                        }
                        if (restriction.isEquality()) {
                            if (restriction.eqValues.size() > 1) {
                                if (i != stmt.keyRestrictions.length - 1) {
                                    throw new InvalidRequestException(String.format("Partition KEY part %s cannot be restricted by IN relation (only the last part of the partition key can)", cname));
                                }
                                stmt.keyIsInRelation = true;
                            }
                        } else {
                            stmt.isKeyRange = true;
                            shouldBeDone = true;
                        }
                    }
                }
                previous = cname;
            }
            if (!stmt.metadataRestrictions.isEmpty()) {
                stmt.isKeyRange = true;
                boolean hasEq = false;
                SecondaryIndexManager idxManager = Table.open((String)this.keyspace()).getColumnFamilyStore((String)this.columnFamily()).indexManager;
                HashSet<ByteBuffer> indexedNames = new HashSet<ByteBuffer>();
                for (SecondaryIndex secondaryIndex : idxManager.getIndexes()) {
                    for (ColumnDefinition cdef : secondaryIndex.getColumnDefs()) {
                        indexedNames.add(cdef.name);
                    }
                }
                for (Map.Entry entry : stmt.metadataRestrictions.entrySet()) {
                    Restriction restriction2 = (Restriction)entry.getValue();
                    if (!restriction2.isEquality()) continue;
                    if (restriction2.eqValues.size() > 1) {
                        throw new InvalidRequestException("Cannot use IN operator on column not part of the PRIMARY KEY");
                    }
                    if (!indexedNames.contains(((CFDefinition.Name)entry.getKey()).name.key)) continue;
                    hasEq = true;
                    break;
                }
                if (!hasEq) {
                    throw new InvalidRequestException("No indexed columns present in by-columns clause with Equal operator");
                }
                if (stmt.keyIsInRelation) {
                    throw new InvalidRequestException("Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
                }
            }
            if (!stmt.parameters.orderings.isEmpty()) {
                if (!stmt.metadataRestrictions.isEmpty()) {
                    throw new InvalidRequestException("ORDER BY with 2ndary indexes is not supported.");
                }
                if (stmt.isKeyRange) {
                    throw new InvalidRequestException("ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
                }
                if (stmt.keyIsInRelation && !stmt.selectedNames.isEmpty()) {
                    for (ColumnIdentifier column : stmt.parameters.orderings.keySet()) {
                        CFDefinition.Name name2 = cfDef.get(column);
                        boolean hasColumn = false;
                        for (Pair selectPair : stmt.selectedNames) {
                            if (!((CFDefinition.Name)selectPair.left).equals(name2)) continue;
                            hasColumn = true;
                            break;
                        }
                        if (hasColumn) continue;
                        throw new InvalidRequestException("ORDER BY could not be used on columns missing in select clause.");
                    }
                }
                Boolean[] reversedMap = new Boolean[cfDef.columns.size()];
                int i2 = 0;
                for (Map.Entry entry : stmt.parameters.orderings.entrySet()) {
                    ColumnIdentifier columnIdentifier = (ColumnIdentifier)entry.getKey();
                    boolean reversed = (Boolean)entry.getValue();
                    CFDefinition.Name name3 = cfDef.get(columnIdentifier);
                    if (name3 == null) {
                        throw new InvalidRequestException(String.format("Order by on unknown column %s", columnIdentifier));
                    }
                    if (name3.kind != CFDefinition.Name.Kind.COLUMN_ALIAS) {
                        throw new InvalidRequestException(String.format("Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", columnIdentifier));
                    }
                    if (i2++ != name3.position) {
                        throw new InvalidRequestException(String.format("Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY", new Object[0]));
                    }
                    reversedMap[name3.position] = reversed != SelectStatement.isReversedType(name3);
                }
                Boolean isReversed = null;
                for (Boolean b : reversedMap) {
                    if (b == null) continue;
                    if (isReversed == null) {
                        isReversed = b;
                        continue;
                    }
                    if (isReversed == b) continue;
                    throw new InvalidRequestException(String.format("Unsupported order by relation", new Object[0]));
                }
                assert (isReversed != null);
                stmt.isReversed = isReversed;
            }
            if (!this.parameters.allowFiltering && stmt.isKeyRange && (stmt.metadataRestrictions.size() > 1 || stmt.metadataRestrictions.isEmpty() && !stmt.columnFilterIsIdentity())) {
                throw new InvalidRequestException("Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING");
            }
            return new ParsedStatement.Prepared(stmt, Arrays.asList(names));
        }

        Restriction updateRestriction(CFDefinition.Name name, Restriction restriction, Relation newRel) throws InvalidRequestException {
            if (newRel.onToken && name.kind != CFDefinition.Name.Kind.KEY_ALIAS) {
                throw new InvalidRequestException(String.format("The token() function is only supported on the partition key, found on %s", name));
            }
            switch (newRel.operator()) {
                case EQ: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes an Equal", name));
                    }
                    restriction = new Restriction(newRel.getValue(), newRel.onToken);
                    break;
                }
                case IN: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one reation if it includes a IN", name));
                    }
                    restriction = new Restriction(newRel.getInValues());
                    break;
                }
                case GT: 
                case GTE: 
                case LT: 
                case LTE: {
                    if (restriction == null) {
                        restriction = new Restriction(newRel.onToken);
                    }
                    restriction.setBound(name.name, newRel.operator(), newRel.getValue());
                }
            }
            return restriction;
        }

        public String toString() {
            return String.format("SelectRawStatement[name=%s, selectClause=%s, whereClause=%s, isCount=%s, limit=%s]", this.cfName, this.selectClause, this.whereClause, this.parameters.isCount, this.parameters.limit);
        }
    }

    private static enum Bound {
        START(0),
        END(1);

        public final int idx;

        private Bound(int idx) {
            this.idx = idx;
        }

        public static Bound reverse(Bound b) {
            return b == START ? END : START;
        }
    }
}

