/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class ServerConnection
extends Connection {
    public static final Connection.Factory FACTORY = new Connection.Factory(){

        @Override
        public Connection newConnection(Connection.Tracker tracker) {
            return new ServerConnection(tracker);
        }
    };
    private final ClientState clientState;
    private volatile State state;
    private final ConcurrentMap<Integer, QueryState> queryStates = new NonBlockingHashMap();

    public ServerConnection(Connection.Tracker tracker) {
        super(tracker);
        this.clientState = new ClientState();
        this.state = State.UNINITIALIZED;
    }

    public QueryState getQueryState(int streamId) {
        QueryState qState = (QueryState)this.queryStates.get(streamId);
        if (qState == null) {
            QueryState newState = new QueryState(this.clientState);
            qState = this.queryStates.putIfAbsent(streamId, newState);
            if (qState == null) {
                qState = newState;
            }
        }
        return qState;
    }

    public void validateNewMessage(Message.Type type) {
        switch (this.state) {
            case UNINITIALIZED: {
                if (type == Message.Type.STARTUP || type == Message.Type.OPTIONS) break;
                throw new ProtocolException(String.format("Unexpected message %s, expecting STARTUP or OPTIONS", new Object[]{type}));
            }
            case AUTHENTICATION: {
                if (type == Message.Type.CREDENTIALS) break;
                throw new ProtocolException(String.format("Unexpected message %s, needs authentication through CREDENTIALS message", new Object[]{type}));
            }
            case READY: {
                if (type != Message.Type.STARTUP) break;
                throw new ProtocolException("Unexpected message STARTUP, the connection is already initialized");
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void applyStateTransition(Message.Type requestType, Message.Type responseType) {
        switch (this.state) {
            case UNINITIALIZED: {
                if (requestType != Message.Type.STARTUP) break;
                if (responseType == Message.Type.AUTHENTICATE) {
                    this.state = State.AUTHENTICATION;
                    break;
                }
                if (responseType != Message.Type.READY) break;
                this.state = State.READY;
                break;
            }
            case AUTHENTICATION: {
                assert (requestType == Message.Type.CREDENTIALS);
                if (responseType == Message.Type.READY) {
                    this.state = State.READY;
                }
            }
            case READY: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static enum State {
        UNINITIALIZED,
        AUTHENTICATION,
        READY;

    }
}

