/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import org.apache.cassandra.cache.RefCountedMemory;
import org.apache.cassandra.io.util.AbstractDataInput;

public class MemoryInputStream
extends AbstractDataInput {
    private final RefCountedMemory mem;
    private int position = 0;

    public MemoryInputStream(RefCountedMemory mem) {
        this.mem = mem;
    }

    @Override
    public int read() throws IOException {
        return this.mem.getByte(this.position++) & 0xFF;
    }

    @Override
    public void readFully(byte[] buffer, int offset, int count) throws IOException {
        this.mem.getBytes(this.position, buffer, offset, count);
        this.position += count;
    }

    @Override
    protected void seekInternal(int pos) {
        this.position = pos;
    }

    @Override
    protected int getPosition() {
        return this.position;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.seekInternal(this.getPosition() + n);
        return this.position;
    }

    @Override
    public void close() {
    }
}

