/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.DiskAwareRunnable;

public abstract class AbstractCompactionTask
extends DiskAwareRunnable {
    protected final ColumnFamilyStore cfs;
    protected Collection<SSTableReader> sstables;
    protected boolean isUserDefined;
    protected OperationType compactionType;

    public AbstractCompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables) {
        this.cfs = cfs;
        this.sstables = sstables;
        this.isUserDefined = false;
        this.compactionType = OperationType.COMPACTION;
    }

    public abstract int execute(CompactionManager.CompactionExecutorStatsCollector var1);

    public void unmarkSSTables() {
        this.cfs.getDataTracker().unmarkCompacting(this.sstables);
    }

    public AbstractCompactionTask setUserDefined(boolean isUserDefined) {
        this.isUserDefined = isUserDefined;
        return this;
    }

    public AbstractCompactionTask setCompactionType(OperationType compactionType) {
        this.compactionType = compactionType;
        return this;
    }

    public String toString() {
        return "CompactionTask(" + this.sstables + ")";
    }
}

