/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.ISSTableSerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.UUIDSerializer;

public class ColumnFamilySerializer
implements IVersionedSerializer<ColumnFamily>,
ISSTableSerializer<ColumnFamily> {
    @Override
    public void serialize(ColumnFamily cf, DataOutput dos, int version) {
        try {
            if (cf == null) {
                dos.writeBoolean(false);
                return;
            }
            dos.writeBoolean(true);
            this.serializeCfId(cf.id(), dos, version);
            DeletionInfo.serializer().serialize(cf.deletionInfo(), dos, version);
            IColumnSerializer columnSerializer = cf.getColumnSerializer();
            int count = cf.getColumnCount();
            dos.writeInt(count);
            int written = 0;
            for (IColumn column : cf) {
                columnSerializer.serialize(column, dos);
                ++written;
            }
            assert (count == written) : "Column family had " + count + " columns, but " + written + " written";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ColumnFamily deserialize(DataInput dis, int version) throws IOException {
        return this.deserialize(dis, IColumnSerializer.Flag.LOCAL, TreeMapBackedSortedColumns.factory(), version);
    }

    public ColumnFamily deserialize(DataInput dis, IColumnSerializer.Flag flag, ISortedColumns.Factory factory, int version) throws IOException {
        if (!dis.readBoolean()) {
            return null;
        }
        ColumnFamily cf = ColumnFamily.create(this.deserializeCfId(dis, version), factory);
        IColumnSerializer columnSerializer = cf.getColumnSerializer();
        cf.delete(DeletionInfo.serializer().deserialize(dis, version, cf.getComparator()));
        int expireBefore = (int)(System.currentTimeMillis() / 1000L);
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            cf.addColumn(columnSerializer.deserialize(dis, flag, expireBefore));
        }
        return cf;
    }

    public long contentSerializedSize(ColumnFamily cf, TypeSizes typeSizes, int version) {
        long size = DeletionInfo.serializer().serializedSize(cf.deletionInfo(), typeSizes, version);
        size += (long)typeSizes.sizeof(cf.getColumnCount());
        for (IColumn column : cf) {
            size += (long)column.serializedSize(typeSizes);
        }
        return size;
    }

    public long serializedSize(ColumnFamily cf, TypeSizes typeSizes, int version) {
        if (cf == null) {
            return typeSizes.sizeof(false);
        }
        return (long)(typeSizes.sizeof(true) + this.cfIdSerializedSize(cf.id(), typeSizes, version)) + this.contentSerializedSize(cf, typeSizes, version);
    }

    @Override
    public long serializedSize(ColumnFamily cf, int version) {
        return this.serializedSize(cf, TypeSizes.NATIVE, version);
    }

    @Override
    public void serializeForSSTable(ColumnFamily cf, DataOutput dos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnFamily deserializeFromSSTable(DataInput dis, Descriptor.Version version) {
        throw new UnsupportedOperationException();
    }

    public void deserializeColumnsFromSSTable(DataInput dis, ColumnFamily cf, int size, IColumnSerializer.Flag flag, int expireBefore, Descriptor.Version version) throws IOException {
        OnDiskAtom.Serializer atomSerializer = cf.getOnDiskSerializer();
        for (int i = 0; i < size; ++i) {
            cf.addAtom(atomSerializer.deserializeFromSSTable(dis, flag, expireBefore, version));
        }
    }

    public void deserializeFromSSTable(DataInput dis, ColumnFamily cf, IColumnSerializer.Flag flag, Descriptor.Version version) throws IOException {
        cf.delete(DeletionInfo.serializer().deserializeFromSSTable(dis, version));
        int size = dis.readInt();
        int expireBefore = (int)(System.currentTimeMillis() / 1000L);
        this.deserializeColumnsFromSSTable(dis, cf, size, flag, expireBefore, version);
    }

    public void serializeCfId(UUID cfId, DataOutput dos, int version) throws IOException {
        if (version < 6) {
            Integer oldId = Schema.instance.convertNewCfId(cfId);
            if (oldId == null) {
                throw new IOException("Can't serialize ColumnFamily ID " + cfId + " to be used by version " + version + ", because int <-> uuid mapping could not be established (CF was created in mixed version cluster).");
            }
            dos.writeInt(oldId);
        } else {
            UUIDSerializer.serializer.serialize(cfId, dos, version);
        }
    }

    public UUID deserializeCfId(DataInput dis, int version) throws IOException {
        UUID cfId;
        UUID uUID = cfId = version < 6 ? Schema.instance.convertOldCfId(dis.readInt()) : UUIDSerializer.serializer.deserialize(dis, version);
        if (Schema.instance.getCF(cfId) == null) {
            throw new UnknownColumnFamilyException("Couldn't find cfId=" + cfId, cfId);
        }
        return cfId;
    }

    public int cfIdSerializedSize(UUID cfId, TypeSizes typeSizes, int version) {
        if (version < 6) {
            Integer oldId = Schema.instance.convertNewCfId(cfId);
            if (oldId == null) {
                throw new RuntimeException("Can't serialize ColumnFamily ID " + cfId + " to be used by version " + version + ", because int <-> uuid mapping could not be established (CF was created in mixed version cluster).");
            }
            return typeSizes.sizeof(oldId);
        }
        return typeSizes.sizeof(cfId);
    }
}

