/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.operations;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.operations.ColumnOperation;
import org.apache.cassandra.cql3.operations.ListOperation;
import org.apache.cassandra.cql3.operations.MapOperation;
import org.apache.cassandra.cql3.operations.Operation;
import org.apache.cassandra.cql3.operations.SetOperation;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.Pair;

public class PreparedOperation
implements Operation {
    private final Term preparedValue;
    private final Kind kind;

    public PreparedOperation(Term value, Kind kind) {
        assert (value.isBindMarker());
        this.preparedValue = value;
        this.kind = kind;
    }

    @Override
    public void execute(ColumnFamily cf, ColumnNameBuilder builder, AbstractType<?> validator, UpdateParameters params, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        if (validator instanceof CollectionType) {
            block0 : switch (((CollectionType)validator).kind) {
                case LIST: {
                    switch (this.kind) {
                        case SET: {
                            ListOperation.doSetFromPrepared(cf, builder, (ListType)validator, this.preparedValue, params);
                            break block0;
                        }
                        case PREPARED_PLUS: {
                            ListOperation.doPrependFromPrepared(cf, builder, (ListType)validator, this.preparedValue, params);
                            break block0;
                        }
                        case PLUS_PREPARED: {
                            ListOperation.doAppendFromPrepared(cf, builder, (ListType)validator, this.preparedValue, params);
                            break block0;
                        }
                        case MINUS_PREPARED: {
                            ListOperation.doDiscardFromPrepared(cf, builder, (ListType)validator, this.preparedValue, params, list);
                        }
                    }
                    break;
                }
                case SET: {
                    switch (this.kind) {
                        case SET: {
                            SetOperation.doSetFromPrepared(cf, builder, (SetType)validator, this.preparedValue, params);
                            break block0;
                        }
                        case PREPARED_PLUS: {
                            throw new InvalidRequestException("Unsupported syntax, cannot add to a prepared set");
                        }
                        case PLUS_PREPARED: {
                            SetOperation.doAddFromPrepared(cf, builder, (SetType)validator, this.preparedValue, params);
                            break block0;
                        }
                        case MINUS_PREPARED: {
                            SetOperation.doDiscardFromPrepared(cf, builder, (SetType)validator, this.preparedValue, params);
                        }
                    }
                    break;
                }
                case MAP: {
                    switch (this.kind) {
                        case SET: {
                            MapOperation.doSetFromPrepared(cf, builder, (MapType)validator, this.preparedValue, params);
                            break block0;
                        }
                        case PREPARED_PLUS: {
                            throw new InvalidRequestException("Unsupported syntax, cannot put to a prepared map");
                        }
                        case PLUS_PREPARED: {
                            MapOperation.doPutFromPrepared(cf, builder, (MapType)validator, this.preparedValue, params);
                            break block0;
                        }
                        case MINUS_PREPARED: {
                            throw new InvalidRequestException("Unsuppoted syntax, discard syntax for map not supported");
                        }
                    }
                }
            }
        } else {
            switch (this.kind) {
                case SET: {
                    ColumnOperation.Set(this.preparedValue).execute(cf, builder, validator, params, null);
                    break;
                }
                case PREPARED_PLUS: {
                    throw new InvalidRequestException("Unsupported syntax for increment, must be of the form X = X + <value>");
                }
                case PLUS_PREPARED: {
                    ColumnOperation.CounterInc(this.preparedValue).execute(cf, builder, validator, params, null);
                    break;
                }
                case MINUS_PREPARED: {
                    ColumnOperation.CounterDec(this.preparedValue).execute(cf, builder, validator, params, null);
                }
            }
        }
    }

    @Override
    public void addBoundNames(ColumnSpecification column, ColumnSpecification[] boundNames) throws InvalidRequestException {
        if (this.preparedValue.isBindMarker()) {
            boundNames[this.preparedValue.bindIndex] = column;
        }
    }

    @Override
    public List<Term> getValues() {
        return Collections.singletonList(this.preparedValue);
    }

    @Override
    public boolean requiresRead(AbstractType<?> validator) {
        return validator instanceof ListType && this.kind == Kind.MINUS_PREPARED;
    }

    public boolean isPotentialCounterOperation() {
        return this.kind == Kind.PLUS_PREPARED || this.kind == Kind.MINUS_PREPARED;
    }

    @Override
    public Operation.Type getType() {
        return Operation.Type.PREPARED;
    }

    public static enum Kind {
        SET,
        PREPARED_PLUS,
        PLUS_PREPARED,
        MINUS_PREPARED;

    }
}

