/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.CqlMetadata;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.transport.CBCodec;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.DataType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ResultSet {
    public static final Codec codec = new Codec();
    private static final ColumnIdentifier COUNT_COLUMN = new ColumnIdentifier("count", false);
    public final Metadata metadata;
    public final List<List<ByteBuffer>> rows;

    public ResultSet(List<ColumnSpecification> metadata) {
        this(new Metadata(metadata), new ArrayList<List<ByteBuffer>>());
    }

    private ResultSet(Metadata metadata, List<List<ByteBuffer>> rows) {
        this.metadata = metadata;
        this.rows = rows;
    }

    public int size() {
        return this.rows.size();
    }

    public void addColumnValue(ByteBuffer value) {
        if (this.rows.isEmpty() || this.lastRow().size() == this.metadata.names.size()) {
            this.rows.add(new ArrayList(this.metadata.names.size()));
        }
        this.lastRow().add(value);
    }

    private List<ByteBuffer> lastRow() {
        return this.rows.get(this.rows.size() - 1);
    }

    public void reverse() {
        Collections.reverse(this.rows);
    }

    public void trim(int limit) {
        int toRemove = this.rows.size() - limit;
        if (toRemove > 0) {
            for (int i = 0; i < toRemove; ++i) {
                this.rows.remove(this.rows.size() - 1);
            }
        }
    }

    public ResultSet makeCountResult() {
        String ksName = this.metadata.names.get((int)0).ksName;
        String cfName = this.metadata.names.get((int)0).cfName;
        this.metadata.names.clear();
        this.metadata.names.add(new ColumnSpecification(ksName, cfName, COUNT_COLUMN, LongType.instance));
        long count = this.rows.size();
        this.rows.clear();
        this.rows.add(Collections.singletonList(ByteBufferUtil.bytes(count)));
        return this;
    }

    public CqlResult toThriftResult() {
        String UTF8 = "UTF8Type";
        CqlMetadata schema = new CqlMetadata(new HashMap(), new HashMap(), UTF8, UTF8);
        for (ColumnSpecification name : this.metadata.names) {
            ByteBuffer colName = ByteBufferUtil.bytes(name.toString());
            schema.name_types.put(colName, UTF8);
            AbstractType<?> normalizedType = name.type instanceof ReversedType ? ((ReversedType)name.type).baseType : name.type;
            schema.value_types.put(colName, normalizedType.toString());
        }
        ArrayList<CqlRow> cqlRows = new ArrayList<CqlRow>(this.rows.size());
        for (List<ByteBuffer> row : this.rows) {
            ArrayList<Column> thriftCols = new ArrayList<Column>(this.metadata.names.size());
            for (int i = 0; i < this.metadata.names.size(); ++i) {
                Column col = new Column(ByteBufferUtil.bytes(this.metadata.names.get(i).toString()));
                col.setValue(row.get(i));
                thriftCols.add(col);
            }
            cqlRows.add(new CqlRow(ByteBufferUtil.EMPTY_BYTE_BUFFER, thriftCols));
        }
        CqlResult res = new CqlResult(CqlResultType.ROWS);
        res.setRows(cqlRows).setSchema(schema);
        return res;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.metadata).append('\n');
            for (List<ByteBuffer> row : this.rows) {
                for (int i = 0; i < row.size(); ++i) {
                    ByteBuffer v = row.get(i);
                    if (v == null) {
                        sb.append(" | null");
                        continue;
                    }
                    sb.append(" | ").append(this.metadata.names.get((int)i).type.getString(v));
                }
                sb.append('\n');
            }
            sb.append("---");
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Flag {
        GLOBAL_TABLES_SPEC;


        public static EnumSet<Flag> deserialize(int flags) {
            EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
            Flag[] values = Flag.values();
            for (int n = 0; n < 32; ++n) {
                if ((flags & 1 << n) == 0) continue;
                set.add(values[n]);
            }
            return set;
        }

        public static int serialize(EnumSet<Flag> flags) {
            int i = 0;
            for (Flag flag : flags) {
                i |= 1 << flag.ordinal();
            }
            return i;
        }
    }

    public static class Metadata {
        public static final CBCodec<Metadata> codec = new Codec();
        public final EnumSet<Flag> flags;
        public final List<ColumnSpecification> names;

        public Metadata(List<ColumnSpecification> names) {
            this(EnumSet.noneOf(Flag.class), names);
            if (!names.isEmpty() && this.allInSameCF()) {
                this.flags.add(Flag.GLOBAL_TABLES_SPEC);
            }
        }

        private Metadata(EnumSet<Flag> flags, List<ColumnSpecification> names) {
            this.flags = flags;
            this.names = names;
        }

        private boolean allInSameCF() {
            assert (!this.names.isEmpty());
            Iterator<ColumnSpecification> iter = this.names.iterator();
            ColumnSpecification first = iter.next();
            while (iter.hasNext()) {
                ColumnSpecification name = iter.next();
                if (name.ksName.equals(first.ksName) && name.cfName.equals(first.cfName)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (ColumnSpecification name : this.names) {
                sb.append("[").append(name.toString());
                sb.append("(").append(name.ksName).append(", ").append(name.cfName).append(")");
                sb.append(", ").append(name.type).append("]");
            }
            return sb.toString();
        }

        private static class Codec
        implements CBCodec<Metadata> {
            private Codec() {
            }

            @Override
            public Metadata decode(ChannelBuffer body) {
                int iflags = body.readInt();
                int columnCount = body.readInt();
                EnumSet<Flag> flags = Flag.deserialize(iflags);
                boolean globalTablesSpec = flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
                String globalKsName = null;
                String globalCfName = null;
                if (globalTablesSpec) {
                    globalKsName = CBUtil.readString(body);
                    globalCfName = CBUtil.readString(body);
                }
                ArrayList<ColumnSpecification> names = new ArrayList<ColumnSpecification>(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    String ksName = globalTablesSpec ? globalKsName : CBUtil.readString(body);
                    String cfName = globalTablesSpec ? globalCfName : CBUtil.readString(body);
                    ColumnIdentifier colName = new ColumnIdentifier(CBUtil.readString(body), true);
                    AbstractType type = DataType.toType(DataType.codec.decodeOne(body));
                    names.add(new ColumnSpecification(ksName, cfName, colName, type));
                }
                return new Metadata(flags, names);
            }

            @Override
            public ChannelBuffer encode(Metadata m) {
                boolean globalTablesSpec = m.flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
                int stringCount = globalTablesSpec ? 2 + m.names.size() : 3 * m.names.size();
                CBUtil.BufferBuilder builder = new CBUtil.BufferBuilder(1 + m.names.size(), stringCount, 0);
                ChannelBuffer header = ChannelBuffers.buffer((int)8);
                header.writeInt(Flag.serialize(m.flags));
                header.writeInt(m.names.size());
                builder.add(header);
                if (globalTablesSpec) {
                    builder.addString(m.names.get((int)0).ksName);
                    builder.addString(m.names.get((int)0).cfName);
                }
                for (ColumnSpecification name : m.names) {
                    if (!globalTablesSpec) {
                        builder.addString(name.ksName);
                        builder.addString(name.cfName);
                    }
                    builder.addString(name.toString());
                    builder.add(DataType.codec.encodeOne(DataType.fromType(name.type)));
                }
                return builder.build();
            }
        }
    }

    public static class Codec
    implements CBCodec<ResultSet> {
        @Override
        public ResultSet decode(ChannelBuffer body) {
            Metadata m = Metadata.codec.decode(body);
            int rowCount = body.readInt();
            ResultSet rs = new ResultSet(m, new ArrayList(rowCount));
            int totalValues = rowCount * m.names.size();
            for (int i = 0; i < totalValues; ++i) {
                rs.addColumnValue(CBUtil.readValue(body));
            }
            return rs;
        }

        @Override
        public ChannelBuffer encode(ResultSet rs) {
            CBUtil.BufferBuilder builder = new CBUtil.BufferBuilder(2, 0, rs.metadata.names.size() * rs.rows.size());
            builder.add(Metadata.codec.encode(rs.metadata));
            builder.add(CBUtil.intToCB(rs.rows.size()));
            for (List<ByteBuffer> row : rs.rows) {
                for (ByteBuffer bb : row) {
                    builder.addValue(bb);
                }
            }
            return builder.build();
        }
    }
}

