/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.antlr.runtime.tree.Tree;
import org.apache.cassandra.cli.CliCommandHelp;
import org.apache.cassandra.cli.CliCompiler;
import org.apache.cassandra.cli.CliMain;
import org.apache.cassandra.cli.CliSessionState;
import org.apache.cassandra.cli.CliUserHelp;
import org.apache.cassandra.cli.CliUtils;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.SimpleSnitch;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class CliClient {
    private static final String DEFAULT_PLACEMENT_STRATEGY = "org.apache.cassandra.locator.NetworkTopologyStrategy";
    private final String NEWLINE = System.getProperty("line.separator");
    private final String TAB = "  ";
    private final Cassandra.Client thriftClient;
    private final CliSessionState sessionState;
    private String keySpace = null;
    private String username = null;
    private final Map<String, KsDef> keyspacesMap = new HashMap<String, KsDef>();
    private final Map<String, Map<String, CfDef>> cql3KeyspacesMap = new HashMap<String, Map<String, CfDef>>();
    private final Map<String, AbstractType<?>> cfKeysComparators;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
    private final CfAssumptions assumptions = new CfAssumptions();
    private CliUserHelp help;

    public CliClient(CliSessionState cliSessionState, Cassandra.Client thriftClient) {
        this.sessionState = cliSessionState;
        this.thriftClient = thriftClient;
        this.cfKeysComparators = new HashMap();
        this.assumptions.readAssumptions();
    }

    private CliUserHelp getHelp() {
        if (this.help == null) {
            this.help = this.loadHelp();
        }
        return this.help;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CliUserHelp loadHelp() {
        InputStream is = CliClient.class.getClassLoader().getResourceAsStream("org/apache/cassandra/cli/CliHelp.yaml");
        assert (is != null);
        try {
            Constructor constructor = new Constructor(CliUserHelp.class);
            TypeDescription desc = new TypeDescription(CliUserHelp.class);
            desc.putListPropertyType("commands", CliCommandHelp.class);
            Yaml yaml = new Yaml(new Loader((BaseConstructor)constructor));
            CliUserHelp cliUserHelp = (CliUserHelp)yaml.load(is);
            return cliUserHelp;
        }
        finally {
            FileUtils.closeQuietly(is);
        }
    }

    public void printBanner() {
        this.sessionState.out.println("Welcome to Cassandra CLI version " + FBUtilities.getReleaseVersionString() + "\n");
        this.sessionState.out.println(this.getHelp().banner);
    }

    public void executeCLIStatement(String statement) throws CharacterCodingException, TException, TimedOutException, NotFoundException, NoSuchFieldException, InvalidRequestException, UnavailableException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Tree tree = CliCompiler.compileQuery(statement);
        try {
            switch (tree.getType()) {
                case 10: {
                    this.cleanupAndExit();
                    break;
                }
                case 17: {
                    this.executeGet(tree);
                    break;
                }
                case 18: {
                    this.executeGetWithConditions(tree);
                    break;
                }
                case 11: {
                    this.executeHelp(tree);
                    break;
                }
                case 19: {
                    this.executeSet(tree);
                    break;
                }
                case 21: {
                    this.executeDelete(tree);
                    break;
                }
                case 20: {
                    this.executeCount(tree);
                    break;
                }
                case 25: {
                    this.executeAddKeySpace(tree.getChild(0));
                    break;
                }
                case 24: {
                    this.executeAddColumnFamily(tree.getChild(0));
                    break;
                }
                case 28: {
                    this.executeUpdateKeySpace(tree.getChild(0));
                    break;
                }
                case 29: {
                    this.executeUpdateColumnFamily(tree.getChild(0));
                    break;
                }
                case 27: {
                    this.executeDelColumnFamily(tree);
                    break;
                }
                case 26: {
                    this.executeDelKeySpace(tree);
                    break;
                }
                case 13: {
                    this.executeShowClusterName();
                    break;
                }
                case 14: {
                    this.executeShowVersion();
                    break;
                }
                case 15: {
                    this.executeShowKeySpaces();
                    break;
                }
                case 16: {
                    this.executeShowSchema(tree);
                    break;
                }
                case 5: {
                    this.executeDescribe(tree);
                    break;
                }
                case 6: {
                    this.executeDescribeCluster();
                    break;
                }
                case 7: {
                    this.executeUseKeySpace(tree);
                    break;
                }
                case 8: {
                    this.executeTraceNextQuery();
                    break;
                }
                case 4: {
                    this.executeConnect(tree);
                    break;
                }
                case 30: {
                    this.executeList(tree);
                    break;
                }
                case 31: {
                    this.executeTruncate(tree.getChild(0).getText());
                    break;
                }
                case 32: {
                    this.executeAssumeStatement(tree);
                    break;
                }
                case 33: {
                    this.executeConsistencyLevelStatement(tree);
                    break;
                }
                case 22: {
                    this.executeIncr(tree, 1L);
                    break;
                }
                case 23: {
                    this.executeIncr(tree, -1L);
                    break;
                }
                case 34: {
                    this.executeDropIndex(tree);
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    this.sessionState.err.println("Invalid Statement (Type: " + tree.getType() + ")");
                    if (this.sessionState.batch) {
                        System.exit(2);
                    }
                    break;
                }
            }
        }
        catch (SchemaDisagreementException e) {
            throw new RuntimeException("schema does not match across nodes, (try again later).", e);
        }
    }

    private void cleanupAndExit() {
        CliMain.disconnect();
        this.assumptions.writeAssumptions();
        System.exit(0);
    }

    public KsDef getKSMetaData(String keyspace) throws NotFoundException, InvalidRequestException, TException {
        if (!this.keyspacesMap.containsKey(keyspace)) {
            KsDef ksDef = this.thriftClient.describe_keyspace(keyspace);
            this.keyspacesMap.put(keyspace, ksDef);
            this.cql3KeyspacesMap.put(keyspace, CliClient.loadCql3Defs(this.thriftClient, ksDef));
            this.assumptions.replayAssumptions(keyspace);
        }
        return this.keyspacesMap.get(keyspace);
    }

    public static Map<String, CfDef> loadCql3Defs(Cassandra.Client thriftClient, KsDef thriftKs) {
        try {
            return CliClient.loadCql3DefsUnchecked(thriftClient, thriftKs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, CfDef> loadCql3DefsUnchecked(Cassandra.Client thriftClient, KsDef thriftKs) throws Exception {
        HashMap<String, CfDef> cql3Defs = new HashMap<String, CfDef>();
        String query = "SELECT columnfamily_name, comparator, default_validator, key_validator FROM system.schema_columnfamilies WHERE keyspace_name='%s'";
        String formatted = String.format(query, thriftKs.name);
        CqlResult result = thriftClient.execute_cql3_query(ByteBufferUtil.bytes(formatted), Compression.NONE, ConsistencyLevel.ONE);
        block0: for (CqlRow row : result.rows) {
            Column rawName = (Column)row.columns.get(0);
            assert (ByteBufferUtil.string(ByteBuffer.wrap(rawName.getName())).equals("columnfamily_name"));
            String name = ByteBufferUtil.string(ByteBuffer.wrap(rawName.getValue()));
            Column rawComparator = (Column)row.columns.get(1);
            assert (ByteBufferUtil.string(ByteBuffer.wrap(rawComparator.getName())).equals("comparator"));
            String comparator = ByteBufferUtil.string(ByteBuffer.wrap(rawComparator.getValue()));
            Column rawValidator = (Column)row.columns.get(2);
            assert (ByteBufferUtil.string(ByteBuffer.wrap(rawValidator.getName())).equals("default_validator"));
            String validator = ByteBufferUtil.string(ByteBuffer.wrap(rawValidator.getValue()));
            Column rawKeyValidator = (Column)row.columns.get(3);
            assert (ByteBufferUtil.string(ByteBuffer.wrap(rawKeyValidator.getName())).equals("key_validator"));
            String keyValidator = ByteBufferUtil.string(ByteBuffer.wrap(rawKeyValidator.getValue()));
            for (CfDef cf_def : thriftKs.cf_defs) {
                if (!cf_def.name.equals(name)) continue;
                continue block0;
            }
            CfDef thriftDef = new CfDef(thriftKs.name, name).setComparator_type(comparator).setDefault_validation_class(validator).setKey_validation_class(keyValidator).setColumn_metadata(Collections.emptyList());
            cql3Defs.put(name, thriftDef);
        }
        return cql3Defs;
    }

    private void executeHelp(Tree tree) {
        if (tree.getChildCount() > 0) {
            String token = tree.getChild(0).getText();
            for (CliCommandHelp ch : this.getHelp().commands) {
                if (!token.equals(ch.name)) continue;
                this.sessionState.out.println(ch.help);
                break;
            }
        } else {
            this.sessionState.out.println(this.getHelp().help);
        }
    }

    private void executeCount(Tree statement) throws TException, InvalidRequestException, UnavailableException, TimedOutException {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        Tree columnFamilySpec = statement.getChild(0);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, this.currentCfDefs());
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        ColumnParent colParent = new ColumnParent(columnFamily).setSuper_column((ByteBuffer)null);
        if (columnSpecCnt != 0) {
            Tree columnTree = columnFamilySpec.getChild(2);
            byte[] superColumn = columnTree.getType() == 40 ? this.convertValueByFunction(columnTree, null, null).array() : this.columnNameAsByteArray(CliCompiler.getColumn(columnFamilySpec, 0), columnFamily);
            colParent = new ColumnParent(columnFamily).setSuper_column(superColumn);
        }
        SliceRange range = new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, Integer.MAX_VALUE);
        SlicePredicate predicate = new SlicePredicate().setColumn_names(null).setSlice_range(range);
        int count = this.thriftClient.get_count(this.getKeyAsBytes(columnFamily, columnFamilySpec.getChild(1)), colParent, predicate, this.consistencyLevel);
        this.sessionState.out.printf("%d columns%n", count);
    }

    private Iterable<CfDef> currentCfDefs() {
        return Iterables.concat((Iterable)this.keyspacesMap.get((Object)this.keySpace).cf_defs, this.cql3KeyspacesMap.get(this.keySpace).values());
    }

    private void executeDelete(Tree statement) throws TException, InvalidRequestException, UnavailableException, TimedOutException {
        Tree subColumnTree;
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        Tree columnFamilySpec = statement.getChild(0);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, this.currentCfDefs());
        CfDef cfDef = this.getCfDef(columnFamily);
        ByteBuffer key = this.getKeyAsBytes(columnFamily, columnFamilySpec.getChild(1));
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        byte[] superColumnName = null;
        byte[] columnName = null;
        boolean isSuper = cfDef.column_type.equals("Super");
        if (columnSpecCnt < 0 || columnSpecCnt > 2) {
            this.sessionState.out.println("Invalid row, super column, or column specification.");
            return;
        }
        long startTime = System.nanoTime();
        Tree columnTree = columnSpecCnt >= 1 ? columnFamilySpec.getChild(2) : null;
        Tree tree = subColumnTree = columnSpecCnt == 2 ? columnFamilySpec.getChild(3) : null;
        if (columnSpecCnt == 1) {
            byte[] columnNameBytes;
            assert (columnTree != null);
            byte[] byArray = columnNameBytes = columnTree.getType() == 40 ? this.convertValueByFunction(columnTree, null, null).array() : this.columnNameAsByteArray(CliCompiler.getColumn(columnFamilySpec, 0), cfDef);
            if (isSuper) {
                superColumnName = columnNameBytes;
            } else {
                columnName = columnNameBytes;
            }
        } else if (columnSpecCnt == 2) {
            assert (columnTree != null);
            assert (subColumnTree != null);
            superColumnName = columnTree.getType() == 40 ? this.convertValueByFunction(columnTree, null, null).array() : this.columnNameAsByteArray(CliCompiler.getColumn(columnFamilySpec, 0), cfDef);
            columnName = subColumnTree.getType() == 40 ? this.convertValueByFunction(subColumnTree, null, null).array() : this.subColumnNameAsByteArray(CliCompiler.getColumn(columnFamilySpec, 1), cfDef);
        }
        ColumnPath path = new ColumnPath(columnFamily);
        if (superColumnName != null) {
            path.setSuper_column(superColumnName);
        }
        if (columnName != null) {
            path.setColumn(columnName);
        }
        if (this.isCounterCF(cfDef)) {
            this.thriftClient.remove_counter(key, path, this.consistencyLevel);
        } else {
            this.thriftClient.remove(key, path, FBUtilities.timestampMicros(), this.consistencyLevel);
        }
        this.sessionState.out.println(String.format("%s removed.", columnSpecCnt == 0 ? "row" : "column"));
        this.elapsedTime(startTime);
    }

    private void doSlice(String keyspace, ByteBuffer key, String columnFamily, byte[] superColumnName, int limit) throws InvalidRequestException, UnavailableException, TimedOutException, TException, IllegalAccessException, NotFoundException, InstantiationException, NoSuchFieldException {
        long startTime = System.nanoTime();
        ColumnParent parent = new ColumnParent(columnFamily);
        if (superColumnName != null) {
            parent.setSuper_column(superColumnName);
        }
        SliceRange range = new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, limit);
        SlicePredicate predicate = new SlicePredicate().setColumn_names(null).setSlice_range(range);
        CfDef cfDef = this.getCfDef(columnFamily);
        boolean isSuperCF = cfDef.column_type.equals("Super");
        List columns = this.thriftClient.get_slice(key, parent, predicate, this.consistencyLevel);
        for (ColumnOrSuperColumn cosc : columns) {
            String formattedName;
            Column column;
            AbstractType<?> validator;
            SuperColumn superColumn;
            if (cosc.isSetSuper_column()) {
                superColumn = cosc.super_column;
                this.sessionState.out.printf("=> (super_column=%s,", this.formatColumnName(keyspace, columnFamily, superColumn.name));
                for (Column col : superColumn.getColumns()) {
                    validator = this.getValidatorForValue(cfDef, col.getName());
                    this.sessionState.out.printf("%n     (column=%s, value=%s, timestamp=%d%s)", this.formatSubcolumnName(keyspace, columnFamily, col.name), validator.getString(col.value), col.timestamp, col.isSetTtl() ? String.format(", ttl=%d", col.getTtl()) : "");
                }
                this.sessionState.out.println(")");
                continue;
            }
            if (cosc.isSetColumn()) {
                column = cosc.column;
                validator = this.getValidatorForValue(cfDef, column.getName());
                formattedName = isSuperCF ? this.formatSubcolumnName(keyspace, columnFamily, column.name) : this.formatColumnName(keyspace, columnFamily, column.name);
                this.sessionState.out.printf("=> (column=%s, value=%s, timestamp=%d%s)%n", formattedName, validator.getString(column.value), column.timestamp, column.isSetTtl() ? String.format(", ttl=%d", column.getTtl()) : "");
                continue;
            }
            if (cosc.isSetCounter_super_column()) {
                superColumn = cosc.counter_super_column;
                this.sessionState.out.printf("=> (super_column=%s,", this.formatColumnName(keyspace, columnFamily, superColumn.name));
                for (Column col : superColumn.getColumns()) {
                    this.sessionState.out.printf("%n     (counter=%s, value=%s)", this.formatSubcolumnName(keyspace, columnFamily, col.name), col.value);
                }
                this.sessionState.out.println(")");
                continue;
            }
            column = cosc.counter_column;
            formattedName = isSuperCF ? this.formatSubcolumnName(keyspace, columnFamily, column.name) : this.formatColumnName(keyspace, columnFamily, column.name);
            this.sessionState.out.printf("=> (counter=%s, value=%s)%n", formattedName, column.value);
        }
        this.sessionState.out.println("Returned " + columns.size() + " results.");
        this.elapsedTime(startTime);
    }

    private AbstractType<?> getFormatType(String compareWith) {
        Function function;
        try {
            function = Function.valueOf(compareWith.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            try {
                return TypeParser.parse(compareWith);
            }
            catch (RequestValidationException ce) {
                StringBuilder errorMessage = new StringBuilder("Unknown comparator '" + compareWith + "'. ");
                errorMessage.append("Available functions: ");
                throw new RuntimeException(errorMessage.append(Function.getFunctionNames()).toString(), e);
            }
        }
        return function.getValidator();
    }

    private void executeGet(Tree statement) throws TException, NotFoundException, InvalidRequestException, UnavailableException, TimedOutException, IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchFieldException {
        String valueAsString;
        Column column;
        ByteBuffer columnName;
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        long startTime = System.nanoTime();
        Tree columnFamilySpec = statement.getChild(0);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, this.currentCfDefs());
        ByteBuffer key = this.getKeyAsBytes(columnFamily, columnFamilySpec.getChild(1));
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        CfDef cfDef = this.getCfDef(columnFamily);
        boolean isSuper = cfDef.column_type.equals("Super");
        byte[] superColumnName = null;
        Tree typeTree = null;
        Tree limitTree = null;
        int limit = 1000000;
        if (statement.getChildCount() >= 2) {
            if (statement.getChild(1).getType() == 39) {
                typeTree = statement.getChild(1).getChild(0);
                if (statement.getChildCount() == 3) {
                    limitTree = statement.getChild(2).getChild(0);
                }
            } else {
                limitTree = statement.getChild(1).getChild(0);
            }
        }
        if (limitTree != null && (limit = Integer.parseInt(limitTree.getText())) == 0) {
            throw new IllegalArgumentException("LIMIT should be greater than zero.");
        }
        if (columnSpecCnt == 0) {
            this.doSlice(this.keySpace, key, columnFamily, superColumnName, limit);
            return;
        }
        if (columnSpecCnt == 1) {
            columnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2));
            if (isSuper) {
                superColumnName = columnName.array();
                this.doSlice(this.keySpace, key, columnFamily, superColumnName, limit);
                return;
            }
        } else if (columnSpecCnt == 2) {
            superColumnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2)).array();
            columnName = this.getSubColumnName(columnFamily, columnFamilySpec.getChild(3));
        } else {
            this.sessionState.out.println("Invalid row, super column, or column specification.");
            return;
        }
        AbstractType<?> validator = this.getValidatorForValue(cfDef, TBaseHelper.byteBufferToByteArray((ByteBuffer)columnName));
        ColumnPath path = new ColumnPath(columnFamily);
        if (superColumnName != null) {
            path.setSuper_column(superColumnName);
        }
        path.setColumn(columnName);
        if (this.isCounterCF(cfDef)) {
            this.doGetCounter(key, path);
            this.elapsedTime(startTime);
            return;
        }
        try {
            column = this.thriftClient.get((ByteBuffer)key, (ColumnPath)path, (ConsistencyLevel)this.consistencyLevel).column;
        }
        catch (NotFoundException e) {
            this.sessionState.out.println("Value was not found");
            this.elapsedTime(startTime);
            return;
        }
        byte[] columnValue = column.getValue();
        if (typeTree != null) {
            String typeName = CliUtils.unescapeSQLString(typeTree.getText());
            AbstractType<?> valueValidator = this.getFormatType(typeName);
            valueAsString = valueValidator.getString(ByteBuffer.wrap(columnValue));
            this.updateColumnMetaData(cfDef, columnName, valueValidator.toString());
        } else {
            valueAsString = validator == null ? new String(columnValue, Charsets.UTF_8) : validator.getString(ByteBuffer.wrap(columnValue));
        }
        String formattedColumnName = isSuper ? this.formatSubcolumnName(this.keySpace, columnFamily, column.name) : this.formatColumnName(this.keySpace, columnFamily, column.name);
        this.sessionState.out.printf("=> (column=%s, value=%s, timestamp=%d%s)%n", formattedColumnName, valueAsString, column.timestamp, column.isSetTtl() ? String.format(", ttl=%d", column.getTtl()) : "");
        this.elapsedTime(startTime);
    }

    private void doGetCounter(ByteBuffer key, ColumnPath path) throws TException, NotFoundException, InvalidRequestException, UnavailableException, TimedOutException, IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchFieldException {
        CounterColumn column;
        boolean isSuper = path.super_column != null;
        try {
            column = this.thriftClient.get((ByteBuffer)key, (ColumnPath)path, (ConsistencyLevel)this.consistencyLevel).counter_column;
        }
        catch (NotFoundException e) {
            this.sessionState.out.println("Value was not found");
            return;
        }
        String formattedColumnName = isSuper ? this.formatSubcolumnName(this.keySpace, path.column_family, column.name) : this.formatColumnName(this.keySpace, path.column_family, column.name);
        this.sessionState.out.printf("=> (counter=%s, value=%d)%n", formattedColumnName, column.value);
    }

    private void executeGetWithConditions(Tree statement) {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        long startTime = System.nanoTime();
        IndexClause clause = new IndexClause();
        String columnFamily = CliCompiler.getColumnFamily(statement, this.currentCfDefs());
        Tree conditions = statement.getChild(1);
        CfDef columnFamilyDef = this.getCfDef(columnFamily);
        SlicePredicate predicate = new SlicePredicate();
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(new byte[0]).setFinish(new byte[0]);
        predicate.setSlice_range(sliceRange);
        for (int i = 0; i < conditions.getChildCount(); ++i) {
            Tree condition = conditions.getChild(i);
            String operator = condition.getChild(0).getText();
            String columnNameString = CliUtils.unescapeSQLString(condition.getChild(1).getText());
            Tree valueTree = condition.getChild(2);
            try {
                ByteBuffer value;
                ByteBuffer columnName = this.columnNameAsBytes(columnNameString, columnFamily);
                if (valueTree.getType() == 40) {
                    value = this.convertValueByFunction(valueTree, columnFamilyDef, columnName);
                } else {
                    String valueString = CliUtils.unescapeSQLString(valueTree.getText());
                    value = this.columnValueAsBytes(columnName, columnFamily, valueString);
                }
                IndexOperator idxOperator = CliUtils.getIndexOperator(operator);
                clause.addToExpressions(new IndexExpression(columnName, idxOperator, value));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        clause.setStart_key(new byte[0]);
        if (statement.getChildCount() == 3) {
            Tree limitNode = statement.getChild(2);
            int limitValue = Integer.parseInt(limitNode.getChild(0).getText());
            if (limitValue == 0) {
                throw new IllegalArgumentException("LIMIT should be greater than zero.");
            }
            clause.setCount(limitValue);
        }
        try {
            ColumnParent parent = new ColumnParent(columnFamily);
            List slices = this.thriftClient.get_indexed_slices(parent, clause, predicate, this.consistencyLevel);
            this.printSliceList(columnFamilyDef, slices);
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.elapsedTime(startTime);
    }

    private void executeSet(Tree statement) throws TException, InvalidRequestException, UnavailableException, TimedOutException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        ByteBuffer columnValueInBytes;
        ByteBuffer columnName;
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        long startTime = System.nanoTime();
        Tree columnFamilySpec = statement.getChild(0);
        Tree keyTree = columnFamilySpec.getChild(1);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, this.currentCfDefs());
        CfDef cfDef = this.getCfDef(columnFamily);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        String value = CliUtils.unescapeSQLString(statement.getChild(1).getText());
        Tree valueTree = statement.getChild(1);
        byte[] superColumnName = null;
        if (columnSpecCnt == 0) {
            this.sessionState.err.println("No column name specified, (type 'help;' or '?' for help on syntax).");
            return;
        }
        if (columnSpecCnt == 1) {
            if (cfDef.column_type.equals("Super")) {
                this.sessionState.out.println("Column family " + columnFamily + " may only contain SuperColumns");
                return;
            }
            columnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2));
        } else {
            assert (columnSpecCnt == 2) : "serious parsing error (this is a bug).";
            superColumnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2)).array();
            columnName = this.getSubColumnName(columnFamily, columnFamilySpec.getChild(3));
        }
        switch (valueTree.getType()) {
            case 40: {
                columnValueInBytes = this.convertValueByFunction(valueTree, cfDef, columnName, true);
                break;
            }
            default: {
                columnValueInBytes = this.columnValueAsBytes(columnName, columnFamily, value);
            }
        }
        ColumnParent parent = new ColumnParent(columnFamily);
        if (superColumnName != null) {
            parent.setSuper_column(superColumnName);
        }
        Column columnToInsert = new Column(columnName).setValue(columnValueInBytes).setTimestamp(FBUtilities.timestampMicros());
        if (statement.getChildCount() == 3) {
            String ttl = statement.getChild(2).getText();
            try {
                columnToInsert.setTtl(Integer.parseInt(ttl));
            }
            catch (NumberFormatException e) {
                this.sessionState.err.println(String.format("TTL '%s' is invalid, should be a positive integer.", ttl));
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.thriftClient.insert(this.getKeyAsBytes(columnFamily, keyTree), parent, columnToInsert, this.consistencyLevel);
        this.sessionState.out.println("Value inserted.");
        this.elapsedTime(startTime);
    }

    private void executeIncr(Tree statement, long multiplier) throws TException, NotFoundException, InvalidRequestException, UnavailableException, TimedOutException, IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchFieldException {
        ByteBuffer columnName;
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        Tree columnFamilySpec = statement.getChild(0);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, this.currentCfDefs());
        ByteBuffer key = this.getKeyAsBytes(columnFamily, columnFamilySpec.getChild(1));
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        byte[] superColumnName = null;
        if (columnSpecCnt == 1) {
            columnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2));
        } else if (columnSpecCnt == 2) {
            superColumnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2)).array();
            columnName = this.getSubColumnName(columnFamily, columnFamilySpec.getChild(3));
        } else {
            this.sessionState.out.println("Invalid row, super column, or column specification.");
            return;
        }
        ColumnParent parent = new ColumnParent(columnFamily);
        if (superColumnName != null) {
            parent.setSuper_column(superColumnName);
        }
        long value = 1L;
        if (statement.getChildCount() == 2) {
            String byValue = statement.getChild(1).getText();
            try {
                value = Long.parseLong(byValue);
            }
            catch (NumberFormatException e) {
                this.sessionState.err.println(String.format("'%s' is an invalid value, should be an integer.", byValue));
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        CounterColumn columnToInsert = new CounterColumn(columnName, multiplier * value);
        this.thriftClient.add(key, parent, columnToInsert, this.consistencyLevel);
        this.sessionState.out.printf("Value %s%n", multiplier < 0L ? "decremented." : "incremented.");
    }

    private void executeShowClusterName() throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        this.sessionState.out.println(this.thriftClient.describe_cluster_name());
    }

    private void executeAddKeySpace(Tree statement) {
        if (!CliMain.isConnected()) {
            return;
        }
        String keyspaceName = CliUtils.unescapeSQLString(statement.getChild(0).getText());
        KsDef ksDef = new KsDef(keyspaceName, DEFAULT_PLACEMENT_STRATEGY, new LinkedList());
        try {
            String mySchemaVersion = this.thriftClient.system_add_keyspace(this.updateKsDefAttributes(statement, ksDef));
            this.sessionState.out.println(mySchemaVersion);
            this.keyspacesMap.put(keyspaceName, this.thriftClient.describe_keyspace(keyspaceName));
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void executeAddColumnFamily(Tree statement) {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        CfDef cfDef = new CfDef(this.keySpace, CliUtils.unescapeSQLString(statement.getChild(0).getText()));
        try {
            String mySchemaVersion = this.thriftClient.system_add_column_family(this.updateCfDefAttributes(statement, cfDef));
            this.sessionState.out.println(mySchemaVersion);
            this.keyspacesMap.put(this.keySpace, this.thriftClient.describe_keyspace(this.keySpace));
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void executeUpdateKeySpace(Tree statement) {
        if (!CliMain.isConnected()) {
            return;
        }
        try {
            String keyspaceName = CliCompiler.getKeySpace(statement, (List<KsDef>)this.thriftClient.describe_keyspaces());
            KsDef currentKsDef = this.getKSMetaData(keyspaceName);
            KsDef updatedKsDef = this.updateKsDefAttributes(statement, currentKsDef);
            String mySchemaVersion = this.thriftClient.system_update_keyspace(updatedKsDef);
            this.sessionState.out.println(mySchemaVersion);
            this.keyspacesMap.remove(keyspaceName);
            this.getKSMetaData(keyspaceName);
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void executeUpdateColumnFamily(Tree statement) {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        String cfName = CliCompiler.getColumnFamily(statement, this.currentCfDefs());
        try {
            CfDef cfDef = this.getCfDef(this.thriftClient.describe_keyspace(this.keySpace), cfName);
            if (cfDef == null) {
                throw new RuntimeException("Column Family " + cfName + " was not found in the current keyspace.");
            }
            String mySchemaVersion = this.thriftClient.system_update_column_family(this.updateCfDefAttributes(statement, cfDef));
            this.sessionState.out.println(mySchemaVersion);
            this.keyspacesMap.put(this.keySpace, this.thriftClient.describe_keyspace(this.keySpace));
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KsDef updateKsDefAttributes(Tree statement, KsDef ksDefToUpdate) {
        Map currentStrategyOptions;
        KsDef ksDef = new KsDef(ksDefToUpdate);
        ksDef.setCf_defs(new LinkedList());
        block7: for (int i = 1; i < statement.getChildCount(); i += 2) {
            String currentStatement = statement.getChild(i).getText().toUpperCase();
            AddKeyspaceArgument mArgument = AddKeyspaceArgument.valueOf(currentStatement);
            String mValue = statement.getChild(i + 1).getText();
            switch (mArgument) {
                case PLACEMENT_STRATEGY: {
                    ksDef.setStrategy_class(CliUtils.unescapeSQLString(mValue));
                    continue block7;
                }
                case STRATEGY_OPTIONS: {
                    ksDef.setStrategy_options(this.getStrategyOptionsFromTree(statement.getChild(i + 1)));
                    continue block7;
                }
                case DURABLE_WRITES: {
                    ksDef.setDurable_writes(Boolean.parseBoolean(mValue));
                    continue block7;
                }
                default: {
                    assert (false);
                    continue block7;
                }
            }
        }
        if (ksDef.getStrategy_class().contains(".NetworkTopologyStrategy") && ((currentStrategyOptions = ksDef.getStrategy_options()) == null || currentStrategyOptions.isEmpty())) {
            SimpleSnitch snitch = new SimpleSnitch();
            HashMap<String, String> options = new HashMap<String, String>();
            try {
                options.put(snitch.getDatacenter(InetAddress.getLocalHost()), "1");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ksDef.setStrategy_options(options);
        }
        return ksDef;
    }

    private CfDef updateCfDefAttributes(Tree statement, CfDef cfDefToUpdate) {
        CfDef cfDef = new CfDef(cfDefToUpdate);
        block22: for (int i = 1; i < statement.getChildCount(); i += 2) {
            String currentArgument = statement.getChild(i).getText().toUpperCase();
            ColumnFamilyArgument mArgument = ColumnFamilyArgument.valueOf(currentArgument);
            String mValue = statement.getChild(i + 1).getText();
            switch (mArgument) {
                case COLUMN_TYPE: {
                    cfDef.setColumn_type(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case COMPARATOR: {
                    cfDef.setComparator_type(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case SUBCOMPARATOR: {
                    cfDef.setSubcomparator_type(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case COMMENT: {
                    cfDef.setComment(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case READ_REPAIR_CHANCE: {
                    double chance = Double.parseDouble(mValue);
                    if (chance < 0.0 || chance > 1.0) {
                        throw new RuntimeException("Error: read_repair_chance must be between 0 and 1.");
                    }
                    cfDef.setRead_repair_chance(chance);
                    continue block22;
                }
                case DCLOCAL_READ_REPAIR_CHANCE: {
                    double localChance = Double.parseDouble(mValue);
                    if (localChance < 0.0 || localChance > 1.0) {
                        throw new RuntimeException("Error: dclocal_read_repair_chance must be between 0 and 1.");
                    }
                    cfDef.setDclocal_read_repair_chance(localChance);
                    continue block22;
                }
                case GC_GRACE: {
                    cfDef.setGc_grace_seconds(Integer.parseInt(mValue));
                    continue block22;
                }
                case COLUMN_METADATA: {
                    Tree arrayOfMetaAttributes = statement.getChild(i + 1);
                    if (!arrayOfMetaAttributes.getText().equals("ARRAY")) {
                        throw new RuntimeException("'column_metadata' format - [{ k:v, k:v, ..}, { ... }, ...]");
                    }
                    cfDef.setColumn_metadata(this.getCFColumnMetaFromTree(cfDef, arrayOfMetaAttributes));
                    continue block22;
                }
                case MEMTABLE_OPERATIONS: {
                    continue block22;
                }
                case MEMTABLE_THROUGHPUT: {
                    continue block22;
                }
                case DEFAULT_VALIDATION_CLASS: {
                    cfDef.setDefault_validation_class(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case MIN_COMPACTION_THRESHOLD: {
                    cfDef.setMin_compaction_threshold(Integer.parseInt(mValue));
                    continue block22;
                }
                case MAX_COMPACTION_THRESHOLD: {
                    cfDef.setMax_compaction_threshold(Integer.parseInt(mValue));
                    continue block22;
                }
                case REPLICATE_ON_WRITE: {
                    cfDef.setReplicate_on_write(Boolean.parseBoolean(mValue));
                    continue block22;
                }
                case KEY_VALIDATION_CLASS: {
                    cfDef.setKey_validation_class(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case COMPACTION_STRATEGY: {
                    cfDef.setCompaction_strategy(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case COMPACTION_STRATEGY_OPTIONS: {
                    cfDef.setCompaction_strategy_options(this.getStrategyOptionsFromTree(statement.getChild(i + 1)));
                    continue block22;
                }
                case COMPRESSION_OPTIONS: {
                    cfDef.setCompression_options(this.getStrategyOptionsFromTree(statement.getChild(i + 1)));
                    continue block22;
                }
                case BLOOM_FILTER_FP_CHANCE: {
                    cfDef.setBloom_filter_fp_chance(Double.parseDouble(mValue));
                    continue block22;
                }
                case CACHING: {
                    cfDef.setCaching(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                default: {
                    assert (false);
                    continue block22;
                }
            }
        }
        return cfDef;
    }

    private void executeDelKeySpace(Tree statement) throws TException, InvalidRequestException, NotFoundException, SchemaDisagreementException {
        if (!CliMain.isConnected()) {
            return;
        }
        String keyspaceName = CliCompiler.getKeySpace(statement, (List<KsDef>)this.thriftClient.describe_keyspaces());
        String version = this.thriftClient.system_drop_keyspace(keyspaceName);
        this.sessionState.out.println(version);
        if (keyspaceName.equals(this.keySpace)) {
            this.keySpace = null;
        }
    }

    private void executeDelColumnFamily(Tree statement) throws TException, InvalidRequestException, NotFoundException, SchemaDisagreementException {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        String cfName = CliCompiler.getColumnFamily(statement, this.currentCfDefs());
        String mySchemaVersion = this.thriftClient.system_drop_column_family(cfName);
        this.sessionState.out.println(mySchemaVersion);
    }

    private void executeList(Tree statement) throws TException, InvalidRequestException, NotFoundException, IllegalAccessException, InstantiationException, NoSuchFieldException, UnavailableException, TimedOutException, CharacterCodingException {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        long startTime = System.nanoTime();
        String columnFamily = CliCompiler.getColumnFamily(statement, this.currentCfDefs());
        String rawStartKey = "";
        String rawEndKey = "";
        int limitCount = Integer.MAX_VALUE;
        int columnCount = Integer.MAX_VALUE;
        boolean reversed = false;
        for (int i = 1; i < statement.getChildCount(); ++i) {
            Tree child = statement.getChild(i);
            if (child.getType() == 49) {
                if (child.getChildCount() <= 0) continue;
                rawStartKey = CliUtils.unescapeSQLString(child.getChild(0).getText());
                if (child.getChildCount() <= 1) continue;
                rawEndKey = CliUtils.unescapeSQLString(child.getChild(1).getText());
                continue;
            }
            if (child.getType() == 46) {
                if (child.getChildCount() != 1) {
                    this.sessionState.out.println("Invalid limit clause");
                    return;
                }
                limitCount = Integer.parseInt(child.getChild(0).getText());
                if (limitCount > 0) continue;
                this.sessionState.out.println("Invalid limit " + limitCount);
                return;
            }
            if (child.getType() != 47) continue;
            if (child.getChildCount() < 1 || child.getChildCount() > 2) {
                this.sessionState.err.println("Invalid columns clause.");
                return;
            }
            String columns = child.getChild(0).getText();
            try {
                columnCount = Integer.parseInt(columns);
                if (columnCount < 0) {
                    this.sessionState.err.println("Invalid column limit: " + columnCount);
                    return;
                }
                if (child.getChildCount() != 2) continue;
                reversed = child.getChild(1).getType() == 48;
                continue;
            }
            catch (NumberFormatException nfe) {
                this.sessionState.err.println("Invalid column number format: " + columns);
                return;
            }
        }
        if (limitCount == Integer.MAX_VALUE) {
            limitCount = 100;
            this.sessionState.out.println("Using default limit of 100");
        }
        if (columnCount == Integer.MAX_VALUE) {
            columnCount = 100;
            this.sessionState.out.println("Using default column limit of 100");
        }
        CfDef columnFamilyDef = this.getCfDef(columnFamily);
        SlicePredicate predicate = new SlicePredicate();
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(new byte[0]).setFinish(new byte[0]);
        sliceRange.setCount(columnCount);
        sliceRange.setReversed(reversed);
        predicate.setSlice_range(sliceRange);
        KeyRange range = new KeyRange(limitCount);
        AbstractType<?> keyComparator = this.cfKeysComparators.get(columnFamily);
        ByteBuffer startKey = rawStartKey.isEmpty() ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.getBytesAccordingToType(rawStartKey, keyComparator);
        ByteBuffer endKey = rawEndKey.isEmpty() ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.getBytesAccordingToType(rawEndKey, keyComparator);
        range.setStart_key(startKey).setEnd_key(endKey);
        ColumnParent columnParent = new ColumnParent(columnFamily);
        List keySlices = this.thriftClient.get_range_slices(columnParent, predicate, range, this.consistencyLevel);
        this.printSliceList(columnFamilyDef, keySlices);
        this.elapsedTime(startTime);
    }

    private void executeDropIndex(Tree statement) throws TException, SchemaDisagreementException, InvalidRequestException, NotFoundException {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        String columnFamily = CliCompiler.getColumnFamily(statement, this.currentCfDefs());
        String rawColumName = CliUtils.unescapeSQLString(statement.getChild(1).getText());
        CfDef cfDef = this.getCfDef(columnFamily);
        ByteBuffer columnName = this.columnNameAsBytes(rawColumName, cfDef);
        boolean foundColumn = false;
        for (ColumnDef column : cfDef.getColumn_metadata()) {
            if (!column.name.equals(columnName)) continue;
            foundColumn = true;
            if (column.getIndex_type() == null) {
                throw new RuntimeException(String.format("Column '%s' does not have an index.", rawColumName));
            }
            column.setIndex_name(null);
            column.setIndex_type(null);
        }
        if (!foundColumn) {
            throw new RuntimeException(String.format("Column '%s' definition was not found in ColumnFamily '%s'.", rawColumName, columnFamily));
        }
        String mySchemaVersion = this.thriftClient.system_update_column_family(cfDef);
        this.sessionState.out.println(mySchemaVersion);
        this.keyspacesMap.put(this.keySpace, this.thriftClient.describe_keyspace(this.keySpace));
    }

    private void executeTruncate(String columnFamily) throws TException, InvalidRequestException, UnavailableException, TimedOutException {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        CfDef cfDef = this.getCfDef(CliCompiler.getColumnFamily(columnFamily, this.currentCfDefs()));
        this.thriftClient.truncate(cfDef.getName());
        this.sessionState.out.println(columnFamily + " truncated.");
    }

    private void executeConsistencyLevelStatement(Tree statement) {
        if (!CliMain.isConnected()) {
            return;
        }
        String userSuppliedLevel = statement.getChild(0).getText().toUpperCase();
        try {
            this.consistencyLevel = ConsistencyLevel.valueOf((String)userSuppliedLevel);
        }
        catch (IllegalArgumentException e) {
            String elements = "ONE, TWO, THREE, QUORUM, ALL, LOCAL_QUORUM, EACH_QUORUM, ANY";
            this.sessionState.out.println(String.format("'%s' is invalid. Available: %s", userSuppliedLevel, elements));
            return;
        }
        this.sessionState.out.println(String.format("Consistency level is set to '%s'.", this.consistencyLevel));
    }

    private void executeAssumeStatement(Tree statement) {
        String defaultType;
        String assumptionElement;
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        String cfName = CliCompiler.getColumnFamily(statement, this.currentCfDefs());
        if (this.applyAssumption(cfName, assumptionElement = statement.getChild(1).getText().toUpperCase(), defaultType = CliUtils.unescapeSQLString(statement.getChild(2).getText()))) {
            this.assumptions.addAssumption(this.keySpace, cfName, assumptionElement, defaultType);
            this.sessionState.out.println(String.format("Assumption for column family '%s' added successfully.", cfName));
        }
    }

    private boolean applyAssumption(String cfName, String assumptionElement, String defaultType) {
        AbstractType<?> comparator;
        CfDef columnFamily;
        try {
            columnFamily = this.getCfDef(cfName);
        }
        catch (RuntimeException e) {
            return false;
        }
        try {
            comparator = TypeParser.parse(defaultType);
        }
        catch (RequestValidationException e) {
            try {
                comparator = Function.valueOf(defaultType.toUpperCase()).getValidator();
            }
            catch (Exception ne) {
                String functions = Function.getFunctionNames();
                this.sessionState.out.println("Type '" + defaultType + "' was not found. Available: " + functions + " Or any class which extends o.a.c.db.marshal.AbstractType.");
                return false;
            }
        }
        defaultType = comparator.getClass().getName();
        if (assumptionElement.equals("COMPARATOR")) {
            columnFamily.setComparator_type(defaultType);
        } else if (assumptionElement.equals("SUB_COMPARATOR")) {
            columnFamily.setSubcomparator_type(defaultType);
        } else if (assumptionElement.equals("VALIDATOR")) {
            columnFamily.setDefault_validation_class(defaultType);
        } else if (assumptionElement.equals("KEYS")) {
            this.cfKeysComparators.put(columnFamily.getName(), comparator);
        } else {
            String elements = "VALIDATOR, COMPARATOR, KEYS, SUB_COMPARATOR.";
            this.sessionState.out.println(String.format("'%s' is invalid. Available: %s", assumptionElement, elements));
            return false;
        }
        return true;
    }

    private void executeShowVersion() throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        this.sessionState.out.println(this.thriftClient.describe_version());
    }

    private void executeShowKeySpaces() throws TException, InvalidRequestException {
        if (!CliMain.isConnected()) {
            return;
        }
        List keySpaces = this.thriftClient.describe_keyspaces();
        Collections.sort(keySpaces, new KsDefNamesComparator());
        for (KsDef keySpace : keySpaces) {
            this.describeKeySpace(keySpace.name, keySpace);
        }
    }

    private void executeShowSchema(Tree statement) throws TException, InvalidRequestException {
        if (!CliMain.isConnected()) {
            return;
        }
        List keyspaces = this.thriftClient.describe_keyspaces();
        Collections.sort(keyspaces, new KsDefNamesComparator());
        final String keyspaceName = statement.getChildCount() == 0 ? this.keySpace : CliCompiler.getKeySpace(statement, (List<KsDef>)keyspaces);
        Iterator ksIter = keyspaceName != null ? Collections2.filter((Collection)keyspaces, (Predicate)new Predicate<KsDef>(){

            public boolean apply(KsDef ksDef) {
                return keyspaceName.equals(ksDef.name);
            }
        }).iterator() : keyspaces.iterator();
        while (ksIter.hasNext()) {
            this.showKeyspace(this.sessionState.out, (KsDef)ksIter.next());
        }
        this.sessionState.out.flush();
    }

    private void showKeyspace(PrintStream output, KsDef ksDef) {
        output.append("create keyspace ").append(ksDef.name);
        this.writeAttr(output, true, "placement_strategy", this.normaliseType(ksDef.strategy_class, "org.apache.cassandra.locator"));
        if (ksDef.strategy_options != null && !ksDef.strategy_options.isEmpty()) {
            StringBuilder opts = new StringBuilder();
            opts.append("{");
            String prefix = "";
            for (Map.Entry opt : ksDef.strategy_options.entrySet()) {
                opts.append(prefix + CliUtils.escapeSQLString((String)opt.getKey()) + " : " + CliUtils.escapeSQLString((String)opt.getValue()));
                prefix = ", ";
            }
            opts.append("}");
            this.writeAttrRaw(output, false, "strategy_options", opts.toString());
        }
        this.writeAttr(output, false, "durable_writes", ksDef.durable_writes);
        output.append(";").append(this.NEWLINE);
        output.append(this.NEWLINE);
        output.append("use " + ksDef.name + ";");
        output.append(this.NEWLINE);
        output.append(this.NEWLINE);
        Collections.sort(ksDef.cf_defs, new CfDefNamesComparator());
        for (CfDef cfDef : ksDef.cf_defs) {
            this.showColumnFamily(output, cfDef);
        }
        output.append(this.NEWLINE);
        output.append(this.NEWLINE);
    }

    private void showColumnFamily(PrintStream output, CfDef cfDef) {
        output.append("create column family ").append(CliUtils.escapeSQLString(cfDef.name));
        this.writeAttr(output, true, "column_type", cfDef.column_type);
        this.writeAttr(output, false, "comparator", this.normaliseType(cfDef.comparator_type, "org.apache.cassandra.db.marshal"));
        if (cfDef.column_type.equals("Super")) {
            this.writeAttr(output, false, "subcomparator", this.normaliseType(cfDef.subcomparator_type, "org.apache.cassandra.db.marshal"));
        }
        if (!StringUtils.isEmpty((String)cfDef.default_validation_class)) {
            this.writeAttr(output, false, "default_validation_class", this.normaliseType(cfDef.default_validation_class, "org.apache.cassandra.db.marshal"));
        }
        this.writeAttr(output, false, "key_validation_class", this.normaliseType(cfDef.key_validation_class, "org.apache.cassandra.db.marshal"));
        this.writeAttr(output, false, "read_repair_chance", cfDef.read_repair_chance);
        this.writeAttr(output, false, "dclocal_read_repair_chance", cfDef.dclocal_read_repair_chance);
        this.writeAttr(output, false, "gc_grace", cfDef.gc_grace_seconds);
        this.writeAttr(output, false, "min_compaction_threshold", cfDef.min_compaction_threshold);
        this.writeAttr(output, false, "max_compaction_threshold", cfDef.max_compaction_threshold);
        this.writeAttr(output, false, "replicate_on_write", cfDef.replicate_on_write);
        this.writeAttr(output, false, "compaction_strategy", cfDef.compaction_strategy);
        this.writeAttr(output, false, "caching", cfDef.caching);
        if (cfDef.isSetBloom_filter_fp_chance()) {
            this.writeAttr(output, false, "bloom_filter_fp_chance", cfDef.bloom_filter_fp_chance);
        }
        if (!cfDef.compaction_strategy_options.isEmpty()) {
            StringBuilder cOptions = new StringBuilder();
            cOptions.append("{");
            Map options = cfDef.compaction_strategy_options;
            int i = 0;
            int size = options.size();
            for (Map.Entry entry : options.entrySet()) {
                cOptions.append(CliUtils.quote((String)entry.getKey())).append(" : ").append(CliUtils.quote((String)entry.getValue()));
                if (i != size - 1) {
                    cOptions.append(", ");
                }
                ++i;
            }
            cOptions.append("}");
            this.writeAttrRaw(output, false, "compaction_strategy_options", cOptions.toString());
        }
        if (!StringUtils.isEmpty((String)cfDef.comment)) {
            this.writeAttr(output, false, "comment", cfDef.comment);
        }
        if (!cfDef.column_metadata.isEmpty()) {
            output.append(this.NEWLINE).append("  ").append("and column_metadata = [");
            boolean first = true;
            for (ColumnDef colDef : cfDef.column_metadata) {
                if (!first) {
                    output.append(",");
                }
                first = false;
                this.showColumnMeta(output, cfDef, colDef);
            }
            output.append("]");
        }
        if (cfDef.compression_options != null && !cfDef.compression_options.isEmpty()) {
            StringBuilder compOptions = new StringBuilder();
            compOptions.append("{");
            int i = 0;
            int size = cfDef.compression_options.size();
            for (Map.Entry entry : cfDef.compression_options.entrySet()) {
                compOptions.append(CliUtils.quote((String)entry.getKey())).append(" : ").append(CliUtils.quote((String)entry.getValue()));
                if (i != size - 1) {
                    compOptions.append(", ");
                }
                ++i;
            }
            compOptions.append("}");
            this.writeAttrRaw(output, false, "compression_options", compOptions.toString());
        }
        output.append(";");
        output.append(this.NEWLINE);
        output.append(this.NEWLINE);
    }

    private void showColumnMeta(PrintStream output, CfDef cfDef, ColumnDef colDef) {
        output.append(this.NEWLINE + "  " + "  " + "{");
        AbstractType<?> comparator = this.getFormatType(cfDef.column_type.equals("Super") ? cfDef.subcomparator_type : cfDef.comparator_type);
        output.append("column_name : '" + CliUtils.escapeSQLString(comparator.getString(colDef.name)) + "'," + this.NEWLINE);
        String validationClass = this.normaliseType(colDef.validation_class, "org.apache.cassandra.db.marshal");
        output.append("    validation_class : " + CliUtils.escapeSQLString(validationClass));
        if (colDef.isSetIndex_name()) {
            output.append(",").append(this.NEWLINE).append("    index_name : '" + CliUtils.escapeSQLString(colDef.index_name) + "'," + this.NEWLINE).append("    index_type : " + CliUtils.escapeSQLString(Integer.toString(colDef.index_type.getValue())));
            if (colDef.index_options != null && !colDef.index_options.isEmpty()) {
                output.append(",").append(this.NEWLINE);
                output.append("    index_options : {" + this.NEWLINE);
                int numOpts = colDef.index_options.size();
                for (Map.Entry entry : colDef.index_options.entrySet()) {
                    String option = CliUtils.escapeSQLString((String)entry.getKey());
                    String optionValue = CliUtils.escapeSQLString((String)entry.getValue());
                    output.append("      ").append("'" + option + "' : '").append(optionValue).append("'");
                    if (--numOpts <= 0) continue;
                    output.append(",").append(this.NEWLINE);
                }
                output.append("}");
            }
        }
        output.append("}");
    }

    private String normaliseType(String path, String expectedPackage) {
        if (path.startsWith(expectedPackage)) {
            return path.substring(expectedPackage.length() + 1);
        }
        return path;
    }

    private void writeAttr(PrintStream output, boolean first, String name, Boolean value) {
        this.writeAttrRaw(output, first, name, value.toString());
    }

    private void writeAttr(PrintStream output, boolean first, String name, Number value) {
        this.writeAttrRaw(output, first, name, value.toString());
    }

    private void writeAttr(PrintStream output, boolean first, String name, String value) {
        this.writeAttrRaw(output, first, name, "'" + CliUtils.escapeSQLString(value) + "'");
    }

    private void writeAttrRaw(PrintStream output, boolean first, String name, String value) {
        output.append(this.NEWLINE).append("  ");
        output.append(first ? "with " : "and ");
        output.append(name).append(" = ");
        output.append(value);
    }

    private boolean hasKeySpace(boolean printError) {
        boolean hasKeyspace;
        boolean bl = hasKeyspace = this.keySpace != null;
        if (!hasKeyspace && printError) {
            this.sessionState.err.println("Not authorized to a working keyspace.");
        }
        return hasKeyspace;
    }

    private boolean hasKeySpace() {
        return this.hasKeySpace(true);
    }

    public String getKeySpace() {
        return this.keySpace == null ? "unknown" : this.keySpace;
    }

    public void setKeySpace(String keySpace) throws NotFoundException, InvalidRequestException, TException {
        this.keySpace = keySpace;
        this.getKSMetaData(keySpace);
    }

    public String getUsername() {
        return this.username == null ? "default" : this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private void executeUseKeySpace(Tree statement) throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        int childCount = statement.getChildCount();
        String username = null;
        String password = null;
        String keySpaceName = CliUtils.unescapeSQLString(statement.getChild(0).getText());
        if (childCount == 3) {
            username = statement.getChild(1).getText();
            password = statement.getChild(2).getText();
        }
        if (keySpaceName == null) {
            this.sessionState.out.println("Keyspace argument required");
            return;
        }
        try {
            HashMap<String, String> credentials = new HashMap<String, String>();
            keySpaceName = CliCompiler.getKeySpace(keySpaceName, (List<KsDef>)this.thriftClient.describe_keyspaces());
            this.thriftClient.set_keyspace(keySpaceName);
            if (username != null && password != null) {
                password = password.replace("'", "");
                credentials.put("username", username);
                credentials.put("password", password);
                AuthenticationRequest authRequest = new AuthenticationRequest(credentials);
                this.thriftClient.login(authRequest);
            }
            this.keySpace = keySpaceName;
            this.username = username != null ? username : "default";
            this.keyspacesMap.remove(this.keySpace);
            CliMain.updateCompletor(CliUtils.getCfNamesByKeySpace(this.getKSMetaData(this.keySpace)));
            this.sessionState.out.println("Authenticated to keyspace: " + this.keySpace);
        }
        catch (AuthenticationException e) {
            this.sessionState.err.println("Exception during authentication to the cassandra node: verify keyspace exists, and you are using correct credentials.");
        }
        catch (AuthorizationException e) {
            this.sessionState.err.println("You are not authorized to use keyspace: " + keySpaceName);
        }
        catch (InvalidRequestException e) {
            this.sessionState.err.println(keySpaceName + " does not exist.");
        }
        catch (NotFoundException e) {
            this.sessionState.err.println(keySpaceName + " does not exist.");
        }
        catch (TException e) {
            if (this.sessionState.debug) {
                e.printStackTrace(this.sessionState.err);
            }
            this.sessionState.err.println("Login failure. Did you specify 'keyspace', 'username' and 'password'?");
        }
    }

    private void executeTraceNextQuery() throws TException, CharacterCodingException {
        if (!CliMain.isConnected()) {
            return;
        }
        UUID sessionId = TimeUUIDType.instance.compose(this.thriftClient.trace_next_query());
        this.sessionState.out.println("Will trace next query. Session ID: " + sessionId.toString());
    }

    private void describeKeySpace(String keySpaceName, KsDef metadata) throws TException {
        NodeProbe probe = this.sessionState.getNodeProbe();
        CompactionManagerMBean compactionManagerMBean = probe == null ? null : probe.getCompactionManagerProxy();
        this.sessionState.out.println("Keyspace: " + keySpaceName + ":");
        try {
            KsDef ks_def = metadata == null ? this.thriftClient.describe_keyspace(keySpaceName) : metadata;
            this.sessionState.out.println("  Replication Strategy: " + ks_def.strategy_class);
            this.sessionState.out.println("  Durable Writes: " + ks_def.durable_writes);
            Map options = ks_def.strategy_options;
            this.sessionState.out.println("    Options: [" + (options == null ? "" : FBUtilities.toString(options)) + "]");
            this.sessionState.out.println("  Column Families:");
            Collections.sort(ks_def.cf_defs, new CfDefNamesComparator());
            for (CfDef cfDef : ks_def.cf_defs) {
                this.describeColumnFamily(ks_def, cfDef, probe);
            }
            if (compactionManagerMBean != null) {
                for (Map map : compactionManagerMBean.getCompactions()) {
                    if (((String)map.get("taskType")).equals(OperationType.INDEX_BUILD.toString())) continue;
                    this.sessionState.out.printf("%nCurrently building index %s, completed %d of %d bytes.%n", map.get("columnfamily"), map.get("bytesComplete"), map.get("totalBytes"));
                }
            }
            if (probe != null) {
                probe.close();
            }
        }
        catch (InvalidRequestException e) {
            this.sessionState.out.println("Invalid request: " + (Object)((Object)e));
        }
        catch (NotFoundException e) {
            this.sessionState.out.println("Keyspace " + keySpaceName + " could not be found.");
        }
        catch (IOException e) {
            this.sessionState.out.println("Error while closing JMX connection: " + e.getMessage());
        }
    }

    private void describeColumnFamily(KsDef ks_def, CfDef cf_def, NodeProbe probe) throws TException {
        ColumnFamilyStoreMBean cfMBean = probe == null ? null : probe.getCfsProxy(ks_def.getName(), cf_def.getName());
        boolean isSuper = cf_def.column_type.equals("Super");
        this.sessionState.out.printf("    ColumnFamily: %s%s%n", cf_def.name, isSuper ? " (Super)" : "");
        if (cf_def.comment != null && !cf_def.comment.isEmpty()) {
            this.sessionState.out.printf("    \"%s\"%n", cf_def.comment);
        }
        if (cf_def.key_validation_class != null) {
            this.sessionState.out.printf("      Key Validation Class: %s%n", cf_def.key_validation_class);
        }
        if (cf_def.default_validation_class != null) {
            this.sessionState.out.printf("      Default column value validator: %s%n", cf_def.default_validation_class);
        }
        this.sessionState.out.printf("      Columns sorted by: %s%s%n", cf_def.comparator_type, cf_def.column_type.equals("Super") ? "/" + cf_def.subcomparator_type : "");
        this.sessionState.out.printf("      GC grace seconds: %s%n", cf_def.gc_grace_seconds);
        this.sessionState.out.printf("      Compaction min/max thresholds: %s/%s%n", cf_def.min_compaction_threshold, cf_def.max_compaction_threshold);
        this.sessionState.out.printf("      Read repair chance: %s%n", cf_def.read_repair_chance);
        this.sessionState.out.printf("      DC Local Read repair chance: %s%n", cf_def.dclocal_read_repair_chance);
        this.sessionState.out.printf("      Replicate on write: %s%n", cf_def.replicate_on_write);
        this.sessionState.out.printf("      Caching: %s%n", cf_def.caching);
        this.sessionState.out.printf("      Bloom Filter FP chance: %s%n", cf_def.isSetBloom_filter_fp_chance() ? Double.valueOf(cf_def.bloom_filter_fp_chance) : "default");
        if (cfMBean != null) {
            this.sessionState.out.printf("      Built indexes: %s%n", cfMBean.getBuiltIndexes());
        }
        if (cf_def.getColumn_metadataSize() != 0) {
            String leftSpace = "      ";
            String columnLeftSpace = leftSpace + "    ";
            String compareWith = isSuper ? cf_def.subcomparator_type : cf_def.comparator_type;
            AbstractType<?> columnNameValidator = this.getFormatType(compareWith);
            this.sessionState.out.println(leftSpace + "Column Metadata:");
            for (ColumnDef columnDef : cf_def.getColumn_metadata()) {
                String columnName = columnNameValidator.getString(columnDef.name);
                if (columnNameValidator instanceof BytesType) {
                    try {
                        String columnString = UTF8Type.instance.getString(columnDef.name);
                        columnName = columnString + " (" + columnName + ")";
                    }
                    catch (MarshalException e) {
                        // empty catch block
                    }
                }
                this.sessionState.out.println(leftSpace + "  Column Name: " + columnName);
                this.sessionState.out.println(columnLeftSpace + "Validation Class: " + columnDef.getValidation_class());
                if (columnDef.isSetIndex_name()) {
                    this.sessionState.out.println(columnLeftSpace + "Index Name: " + columnDef.getIndex_name());
                }
                if (columnDef.isSetIndex_type()) {
                    this.sessionState.out.println(columnLeftSpace + "Index Type: " + columnDef.getIndex_type().name());
                }
                if (!columnDef.isSetIndex_options()) continue;
                this.sessionState.out.println(columnLeftSpace + "Index Options: " + columnDef.getIndex_options());
            }
        }
        this.sessionState.out.printf("      Compaction Strategy: %s%n", cf_def.compaction_strategy);
        if (!cf_def.compaction_strategy_options.isEmpty()) {
            this.sessionState.out.println("      Compaction Strategy Options:");
            for (Map.Entry e : cf_def.compaction_strategy_options.entrySet()) {
                this.sessionState.out.printf("        %s: %s%n", e.getKey(), e.getValue());
            }
        }
        if (cf_def.compression_options != null && !cf_def.compression_options.isEmpty()) {
            this.sessionState.out.println("      Compression Options:");
            for (Map.Entry e : cf_def.compression_options.entrySet()) {
                this.sessionState.out.printf("        %s: %s%n", e.getKey(), e.getValue());
            }
        }
    }

    private void executeDescribe(Tree statement) throws TException, InvalidRequestException, NotFoundException {
        if (!CliMain.isConnected()) {
            return;
        }
        int argCount = statement.getChildCount();
        if (this.keySpace == null && argCount == 0) {
            this.sessionState.out.println("Authenticate to a Keyspace, before using `describe` or `describe <column_family>`");
            return;
        }
        KsDef currentKeySpace = null;
        if (this.keySpace != null) {
            this.keyspacesMap.remove(this.keySpace);
            currentKeySpace = this.getKSMetaData(this.keySpace);
        }
        if (argCount > 1) {
            throw new RuntimeException("`describe` command take maximum one argument. See `help describe;`");
        }
        if (argCount == 0) {
            if (currentKeySpace != null) {
                this.describeKeySpace(currentKeySpace.name, null);
                return;
            }
            this.sessionState.out.println("Authenticate to a Keyspace, before using `describe` or `describe <column_family>`");
        } else if (argCount == 1) {
            CfDef inputCfDef;
            String entityName = statement.getChild(0).getText();
            KsDef inputKsDef = CliUtils.getKeySpaceDef(entityName, this.thriftClient.describe_keyspaces());
            if (inputKsDef == null && currentKeySpace == null) {
                throw new RuntimeException(String.format("Keyspace with name '%s' wasn't found, to lookup ColumnFamily with that name, please, authorize to one of the keyspaces first.", entityName));
            }
            CfDef cfDef = inputCfDef = inputKsDef == null ? this.getCfDef(currentKeySpace, entityName) : null;
            if (inputKsDef != null) {
                this.describeKeySpace(inputKsDef.name, inputKsDef);
            } else if (inputCfDef != null) {
                NodeProbe probe = this.sessionState.getNodeProbe();
                try {
                    this.describeColumnFamily(currentKeySpace, inputCfDef, probe);
                    if (probe != null) {
                        probe.close();
                    }
                }
                catch (IOException e) {
                    this.sessionState.out.println("Error while closing JMX connection: " + e.getMessage());
                }
            } else {
                this.sessionState.out.println("Sorry, no Keyspace nor ColumnFamily was found with name: " + entityName);
            }
        }
    }

    private void executeDescribeCluster() {
        if (!CliMain.isConnected()) {
            return;
        }
        this.sessionState.out.println("Cluster Information:");
        try {
            this.sessionState.out.println("   Snitch: " + this.thriftClient.describe_snitch());
            this.sessionState.out.println("   Partitioner: " + this.thriftClient.describe_partitioner());
            this.sessionState.out.println("   Schema versions: ");
            Map versions = this.thriftClient.describe_schema_versions();
            for (String version : versions.keySet()) {
                this.sessionState.out.println(String.format("\t%s: %s%n", version, versions.get(version)));
            }
        }
        catch (Exception e) {
            String message = e instanceof InvalidRequestException ? ((InvalidRequestException)((Object)e)).getWhy() : e.getMessage();
            this.sessionState.err.println("Error retrieving data: " + message);
        }
    }

    private void executeConnect(Tree statement) {
        Tree idList = statement.getChild(0);
        int portNumber = Integer.parseInt(statement.getChild(1).getText());
        StringBuilder hostName = new StringBuilder();
        int idCount = idList.getChildCount();
        for (int idx = 0; idx < idCount; ++idx) {
            hostName.append(idList.getChild(idx).getText());
        }
        CliMain.disconnect();
        this.sessionState.hostName = hostName.toString();
        this.sessionState.thriftPort = portNumber;
        if (statement.getChildCount() == 4) {
            this.sessionState.username = statement.getChild(2).getText();
            this.sessionState.password = CliUtils.unescapeSQLString(statement.getChild(3).getText());
        }
        CliMain.connect(this.sessionState.hostName, this.sessionState.thriftPort);
    }

    private CfDef getCfDef(String keySpaceName, String columnFamilyName) {
        KsDef ksDef = this.keyspacesMap.get(keySpaceName);
        CfDef cfDef = this.getCfDef(ksDef, columnFamilyName);
        if (cfDef == null) {
            throw new RuntimeException("No such column family: " + columnFamilyName);
        }
        return cfDef;
    }

    private CfDef getCfDef(String columnFamilyName) {
        return this.getCfDef(this.keySpace, columnFamilyName);
    }

    private CfDef getCfDef(KsDef keyspace, String columnFamilyName) {
        for (CfDef cfDef : keyspace.cf_defs) {
            if (!cfDef.name.equals(columnFamilyName)) continue;
            return cfDef;
        }
        return this.cql3KeyspacesMap.get(keyspace.name).get(columnFamilyName);
    }

    private List<ColumnDef> getCFColumnMetaFromTree(CfDef cfDef, Tree meta) {
        ArrayList<ColumnDef> columnDefinitions = new ArrayList<ColumnDef>();
        for (int i = 0; i < meta.getChildCount(); ++i) {
            Tree metaHash = meta.getChild(i);
            ColumnDef columnDefinition = new ColumnDef();
            for (int j = 0; j < metaHash.getChildCount(); ++j) {
                Tree metaPair = metaHash.getChild(j);
                String metaKey = CliUtils.unescapeSQLString(metaPair.getChild(0).getText());
                String metaVal = CliUtils.unescapeSQLString(metaPair.getChild(1).getText());
                if (metaKey.equals("column_name")) {
                    if (cfDef.column_type.equals("Super")) {
                        columnDefinition.setName(this.subColumnNameAsByteArray(metaVal, cfDef));
                        continue;
                    }
                    columnDefinition.setName(this.columnNameAsByteArray(metaVal, cfDef));
                    continue;
                }
                if (metaKey.equals("validation_class")) {
                    columnDefinition.setValidation_class(metaVal);
                    continue;
                }
                if (metaKey.equals("index_type")) {
                    columnDefinition.setIndex_type(this.getIndexTypeFromString(metaVal));
                    continue;
                }
                if (metaKey.equals("index_options")) {
                    columnDefinition.setIndex_options(this.getStrategyOptionsFromTree(metaPair.getChild(1)));
                    continue;
                }
                if (metaKey.equals("index_name")) {
                    columnDefinition.setIndex_name(metaVal);
                    continue;
                }
                throw new RuntimeException("Unsupported column_metadata pair given => " + metaKey + ": " + metaVal);
            }
            try {
                columnDefinition.validate();
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
            columnDefinitions.add(columnDefinition);
        }
        return columnDefinitions;
    }

    private IndexType getIndexTypeFromString(String indexTypeAsString) {
        IndexType indexType;
        try {
            indexType = IndexType.findByValue((int)new Integer(indexTypeAsString));
        }
        catch (NumberFormatException e) {
            try {
                indexType = IndexType.valueOf((String)indexTypeAsString);
            }
            catch (IllegalArgumentException ie) {
                throw new RuntimeException("IndexType '" + indexTypeAsString + "' is unsupported.", ie);
            }
        }
        if (indexType == null) {
            throw new RuntimeException("IndexType '" + indexTypeAsString + "' is unsupported.");
        }
        return indexType;
    }

    private ByteBuffer getBytesAccordingToType(String object, AbstractType<?> comparator) {
        if (comparator == null) {
            comparator = BytesType.instance;
        }
        try {
            return ((AbstractType)comparator).fromString(object);
        }
        catch (MarshalException e) {
            throw new RuntimeException(e);
        }
    }

    private ByteBuffer columnNameAsBytes(String column, String columnFamily) {
        CfDef columnFamilyDef = this.getCfDef(columnFamily);
        return this.columnNameAsBytes(column, columnFamilyDef);
    }

    private ByteBuffer columnNameAsBytes(String column, CfDef columnFamilyDef) {
        String comparatorClass = columnFamilyDef.comparator_type;
        return this.getBytesAccordingToType(column, this.getFormatType(comparatorClass));
    }

    private byte[] columnNameAsByteArray(String column, String columnFamily) {
        return TBaseHelper.byteBufferToByteArray((ByteBuffer)this.columnNameAsBytes(column, columnFamily));
    }

    private byte[] columnNameAsByteArray(String column, CfDef cfDef) {
        return TBaseHelper.byteBufferToByteArray((ByteBuffer)this.columnNameAsBytes(column, cfDef));
    }

    private ByteBuffer subColumnNameAsBytes(String superColumn, String columnFamily) {
        CfDef columnFamilyDef = this.getCfDef(columnFamily);
        return this.subColumnNameAsBytes(superColumn, columnFamilyDef);
    }

    private ByteBuffer subColumnNameAsBytes(String superColumn, CfDef columnFamilyDef) {
        String comparatorClass = columnFamilyDef.subcomparator_type;
        if (comparatorClass == null) {
            this.sessionState.out.println(String.format("Notice: defaulting to BytesType subcomparator for '%s'", columnFamilyDef.getName()));
            comparatorClass = "BytesType";
        }
        return this.getBytesAccordingToType(superColumn, this.getFormatType(comparatorClass));
    }

    private byte[] subColumnNameAsByteArray(String superColumn, CfDef cfDef) {
        return TBaseHelper.byteBufferToByteArray((ByteBuffer)this.subColumnNameAsBytes(superColumn, cfDef));
    }

    private ByteBuffer columnValueAsBytes(ByteBuffer columnName, String columnFamilyName, String columnValue) {
        CfDef columnFamilyDef = this.getCfDef(columnFamilyName);
        AbstractType<?> defaultValidator = this.getFormatType(columnFamilyDef.default_validation_class);
        for (ColumnDef columnDefinition : columnFamilyDef.getColumn_metadata()) {
            byte[] currentColumnName = columnDefinition.getName();
            if (ByteBufferUtil.compare(currentColumnName, columnName) != 0) continue;
            try {
                String validationClass = columnDefinition.getValidation_class();
                return this.getBytesAccordingToType(columnValue, this.getFormatType(validationClass));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return defaultValidator.fromString(columnValue);
    }

    private AbstractType<?> getValidatorForValue(CfDef cfDef, byte[] columnNameInBytes) {
        String defaultValidator = cfDef.default_validation_class;
        for (ColumnDef columnDefinition : cfDef.getColumn_metadata()) {
            byte[] nameInBytes = columnDefinition.getName();
            if (!Arrays.equals(nameInBytes, columnNameInBytes)) continue;
            return this.getFormatType(columnDefinition.getValidation_class());
        }
        if (defaultValidator != null && !defaultValidator.isEmpty()) {
            return this.getFormatType(defaultValidator);
        }
        return null;
    }

    private Map<String, String> getStrategyOptionsFromTree(Tree options) {
        if (options.getText().equalsIgnoreCase("ARRAY")) {
            System.err.println("WARNING: [{}] strategy_options syntax is deprecated, please use {}");
            if (options.getChildCount() == 0) {
                return Collections.EMPTY_MAP;
            }
            return this.getStrategyOptionsFromTree(options.getChild(0));
        }
        HashMap<String, String> strategyOptions = new HashMap<String, String>();
        for (int j = 0; j < options.getChildCount(); ++j) {
            Tree optionPair = options.getChild(j);
            String key = CliUtils.unescapeSQLString(optionPair.getChild(0).getText());
            String val = CliUtils.unescapeSQLString(optionPair.getChild(1).getText());
            strategyOptions.put(key, val);
        }
        return strategyOptions;
    }

    private ByteBuffer convertValueByFunction(Tree functionCall, CfDef columnFamily, ByteBuffer columnName) {
        return this.convertValueByFunction(functionCall, columnFamily, columnName, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteBuffer convertValueByFunction(Tree functionCall, CfDef columnFamily, ByteBuffer columnName, boolean withUpdate) {
        String functionName = functionCall.getChild(0).getText();
        Tree argumentTree = functionCall.getChild(1);
        String functionArg = argumentTree == null ? "" : CliUtils.unescapeSQLString(argumentTree.getText());
        AbstractType<?> validator = CliClient.getTypeByFunction(functionName);
        try {
            ByteBuffer value;
            if (functionArg.isEmpty()) {
                if (validator instanceof TimeUUIDType) {
                    value = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
                } else if (validator instanceof LexicalUUIDType) {
                    value = ByteBuffer.wrap(UUIDGen.decompose(UUID.randomUUID()));
                } else {
                    if (!(validator instanceof BytesType)) throw new RuntimeException(String.format("Argument for '%s' could not be empty.", functionName));
                    value = ByteBuffer.wrap(new byte[0]);
                }
            } else {
                value = this.getBytesAccordingToType(functionArg, validator);
            }
            if (!withUpdate) return value;
            this.updateColumnMetaData(columnFamily, columnName, validator.toString());
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AbstractType<?> getTypeByFunction(String functionName) {
        Function function;
        try {
            function = Function.valueOf(functionName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            StringBuilder errorMessage = new StringBuilder("Function '" + functionName + "' not found. ");
            errorMessage.append("Available functions: ");
            throw new RuntimeException(errorMessage.append(Function.getFunctionNames()).toString(), e);
        }
        return function.getValidator();
    }

    private void updateColumnMetaData(CfDef columnFamily, ByteBuffer columnName, String validationClass) {
        ColumnDef column = this.getColumnDefByName(columnFamily, columnName);
        if (column != null) {
            if (column.getValidation_class().equals(validationClass)) {
                return;
            }
            column.setValidation_class(validationClass);
        } else {
            ArrayList<ColumnDef> columnMetaData = new ArrayList<ColumnDef>(columnFamily.getColumn_metadata());
            columnMetaData.add(new ColumnDef(columnName, validationClass));
            columnFamily.setColumn_metadata(columnMetaData);
        }
    }

    private ColumnDef getColumnDefByName(CfDef columnFamily, ByteBuffer columnName) {
        for (ColumnDef columnDef : columnFamily.getColumn_metadata()) {
            byte[] currName = columnDef.getName();
            if (ByteBufferUtil.compare(currName, columnName) != 0) continue;
            return columnDef;
        }
        return null;
    }

    private void printSliceList(CfDef columnFamilyDef, List<KeySlice> slices) throws NotFoundException, TException, IllegalAccessException, InstantiationException, NoSuchFieldException, CharacterCodingException {
        String columnFamilyName = columnFamilyDef.getName();
        AbstractType<?> keyComparator = this.getKeyComparatorForCF(columnFamilyName);
        for (KeySlice ks : slices) {
            String keyName = keyComparator == null ? ByteBufferUtil.string(ks.key) : keyComparator.getString(ks.key);
            this.sessionState.out.printf("-------------------%n", new Object[0]);
            this.sessionState.out.printf("RowKey: %s%n", keyName);
            Iterator iterator = ks.getColumnsIterator();
            while (iterator.hasNext()) {
                SuperColumn superCol;
                AbstractType<?> validator;
                Column col;
                ColumnOrSuperColumn columnOrSuperColumn = (ColumnOrSuperColumn)iterator.next();
                if (columnOrSuperColumn.column != null) {
                    col = columnOrSuperColumn.column;
                    validator = this.getValidatorForValue(columnFamilyDef, col.getName());
                    this.sessionState.out.printf("=> (column=%s, value=%s, timestamp=%d%s)%n", this.formatColumnName(this.keySpace, columnFamilyName, col.name), validator.getString(col.value), col.timestamp, col.isSetTtl() ? String.format(", ttl=%d", col.getTtl()) : "");
                    continue;
                }
                if (columnOrSuperColumn.super_column != null) {
                    superCol = columnOrSuperColumn.super_column;
                    this.sessionState.out.printf("=> (super_column=%s,", this.formatColumnName(this.keySpace, columnFamilyName, superCol.name));
                    for (Column col2 : superCol.columns) {
                        validator = this.getValidatorForValue(columnFamilyDef, col2.getName());
                        this.sessionState.out.printf("%n     (column=%s, value=%s, timestamp=%d%s)", this.formatSubcolumnName(this.keySpace, columnFamilyName, col2.name), validator.getString(col2.value), col2.timestamp, col2.isSetTtl() ? String.format(", ttl=%d", col2.getTtl()) : "");
                    }
                    this.sessionState.out.println(")");
                    continue;
                }
                if (columnOrSuperColumn.counter_column != null) {
                    col = columnOrSuperColumn.counter_column;
                    this.sessionState.out.printf("=> (counter=%s, value=%s)%n", this.formatColumnName(this.keySpace, columnFamilyName, col.name), col.value);
                    continue;
                }
                if (columnOrSuperColumn.counter_super_column == null) continue;
                superCol = columnOrSuperColumn.counter_super_column;
                this.sessionState.out.printf("=> (super_column=%s,", this.formatColumnName(this.keySpace, columnFamilyName, superCol.name));
                for (Column col2 : superCol.columns) {
                    this.sessionState.out.printf("%n     (counter=%s, value=%s)", this.formatSubcolumnName(this.keySpace, columnFamilyName, col2.name), col2.value);
                }
                this.sessionState.out.println(")");
            }
        }
        this.sessionState.out.printf("%n%d Row%s Returned.%n", slices.size(), slices.size() > 1 ? "s" : "");
    }

    private String formatSubcolumnName(String keyspace, String columnFamily, ByteBuffer name) throws NotFoundException, TException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        return this.getFormatType(this.getCfDef((String)keyspace, (String)columnFamily).subcomparator_type).getString(name);
    }

    private String formatColumnName(String keyspace, String columnFamily, ByteBuffer name) throws NotFoundException, TException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        return this.getFormatType(this.getCfDef((String)keyspace, (String)columnFamily).comparator_type).getString(name);
    }

    private ByteBuffer getColumnName(String columnFamily, Tree columnTree) {
        return columnTree.getType() == 40 ? this.convertValueByFunction(columnTree, null, null) : this.columnNameAsBytes(CliUtils.unescapeSQLString(columnTree.getText()), columnFamily);
    }

    private ByteBuffer getSubColumnName(String columnFamily, Tree columnTree) {
        return columnTree.getType() == 40 ? this.convertValueByFunction(columnTree, null, null) : this.subColumnNameAsBytes(CliUtils.unescapeSQLString(columnTree.getText()), columnFamily);
    }

    public ByteBuffer getKeyAsBytes(String columnFamily, Tree keyTree) {
        if (keyTree.getType() == 40) {
            return this.convertValueByFunction(keyTree, null, null);
        }
        String key = CliUtils.unescapeSQLString(keyTree.getText());
        return this.getBytesAccordingToType(key, this.getKeyComparatorForCF(columnFamily));
    }

    private AbstractType<?> getKeyComparatorForCF(String columnFamily) {
        AbstractType<?> keyComparator = this.cfKeysComparators.get(columnFamily);
        if (keyComparator == null) {
            String defaultValidationClass = this.getCfDef(columnFamily).getKey_validation_class();
            assert (defaultValidationClass != null);
            keyComparator = this.getFormatType(defaultValidationClass);
        }
        return keyComparator;
    }

    private boolean isCounterCF(CfDef cfdef) {
        String defaultValidator = cfdef.default_validation_class;
        return defaultValidator != null && !defaultValidator.isEmpty() && this.getFormatType(defaultValidator) instanceof CounterColumnType;
    }

    private void elapsedTime(long startTime) {
        long eta = System.nanoTime() - startTime;
        this.sessionState.out.print("Elapsed time: ");
        if (eta < 10000000L) {
            this.sessionState.out.print((double)Math.round((double)eta / 10000.0) / 100.0);
        } else {
            this.sessionState.out.print(Math.round((double)eta / 1000000.0));
        }
        this.sessionState.out.println(" msec(s).");
    }

    class CfAssumptions {
        private Map<String, Map<String, Map<String, String>>> assumptions = new HashMap<String, Map<String, Map<String, String>>>();
        private boolean assumptionsChanged = false;
        private File assumptionDirectory = new File(System.getProperty("user.home"), ".cassandra-cli");

        public CfAssumptions() {
            this.assumptionDirectory.mkdirs();
        }

        public void addAssumption(String keyspace, String columnFamily, String property, String value) {
            Map<String, String> cfAssumes;
            Map<String, Map<String, String>> ksAssumes = this.assumptions.get(keyspace);
            if (ksAssumes == null) {
                ksAssumes = new HashMap<String, Map<String, String>>();
                this.assumptions.put(keyspace, ksAssumes);
            }
            if ((cfAssumes = ksAssumes.get(columnFamily)) == null) {
                cfAssumes = new HashMap<String, String>();
                ksAssumes.put(columnFamily, cfAssumes);
            }
            cfAssumes.put(property, value);
            this.assumptionsChanged = true;
        }

        public void replayAssumptions(String keyspace) {
            if (!CliMain.isConnected() || !CliClient.this.hasKeySpace(false)) {
                return;
            }
            Map<String, Map<String, String>> cfAssumes = this.assumptions.get(keyspace);
            if (cfAssumes != null) {
                for (Map.Entry<String, Map<String, String>> cfEntry : cfAssumes.entrySet()) {
                    String columnFamily = cfEntry.getKey();
                    Map<String, String> props = cfEntry.getValue();
                    for (Map.Entry<String, String> propEntry : props.entrySet()) {
                        CliClient.this.applyAssumption(columnFamily, propEntry.getKey(), propEntry.getValue());
                    }
                }
            }
        }

        private void readAssumptions() {
            File assumptionFile = new File(this.assumptionDirectory, "assumptions.json");
            if (assumptionFile.isFile()) {
                try {
                    JsonFactory f = new JsonFactory();
                    JsonParser p = f.createJsonParser(assumptionFile);
                    JsonToken token = p.nextToken();
                    while (token != JsonToken.END_OBJECT) {
                        if (token == JsonToken.FIELD_NAME) {
                            String keyspace = p.getText();
                            Map<String, Map<String, String>> ksAssumes = this.assumptions.get(keyspace);
                            if (ksAssumes == null) {
                                ksAssumes = new HashMap<String, Map<String, String>>();
                                this.assumptions.put(keyspace, ksAssumes);
                            }
                            token = p.nextToken();
                            while (token != JsonToken.END_ARRAY) {
                                if (token == JsonToken.FIELD_NAME) {
                                    String columnFamily = p.getText();
                                    Map<String, String> cfAssumes = ksAssumes.get(columnFamily);
                                    if (cfAssumes == null) {
                                        cfAssumes = new HashMap<String, String>();
                                        ksAssumes.put(columnFamily, cfAssumes);
                                    }
                                    token = p.nextToken();
                                    while (token != JsonToken.END_ARRAY) {
                                        if (token == JsonToken.FIELD_NAME) {
                                            String prop = p.getText();
                                            p.nextToken();
                                            String value = p.getText();
                                            cfAssumes.put(prop, value);
                                        }
                                        token = p.nextToken();
                                    }
                                }
                                token = p.nextToken();
                            }
                        }
                        token = p.nextToken();
                    }
                    ((CliClient)CliClient.this).sessionState.out.println("Column Family assumptions read from " + assumptionFile);
                }
                catch (Exception e) {
                    ((CliClient)CliClient.this).sessionState.err.println("Failed reading " + assumptionFile + " file");
                }
            }
        }

        private void writeAssumptions() {
            if (this.assumptionsChanged) {
                File assumptionFile = new File(this.assumptionDirectory, "assumptions.json");
                try {
                    JsonFactory f = new JsonFactory();
                    JsonGenerator g = f.createJsonGenerator(assumptionFile, JsonEncoding.UTF8);
                    g.useDefaultPrettyPrinter();
                    g.writeStartObject();
                    for (Map.Entry<String, Map<String, Map<String, String>>> ksEntry : this.assumptions.entrySet()) {
                        g.writeFieldName(ksEntry.getKey());
                        g.writeStartArray();
                        for (Map.Entry<String, Map<String, String>> cfEntry : ksEntry.getValue().entrySet()) {
                            g.writeStartObject();
                            g.writeFieldName(cfEntry.getKey());
                            g.writeStartArray();
                            for (Map.Entry<String, String> asEntry : cfEntry.getValue().entrySet()) {
                                g.writeStartObject();
                                g.writeStringField(asEntry.getKey(), asEntry.getValue());
                                g.writeEndObject();
                            }
                            g.writeEndArray();
                            g.writeEndObject();
                        }
                        g.writeEndArray();
                    }
                    g.writeEndObject();
                    g.close();
                    ((CliClient)CliClient.this).sessionState.out.println("Column Family assumptions written to " + assumptionFile);
                    this.assumptionsChanged = false;
                }
                catch (Exception e) {
                    ((CliClient)CliClient.this).sessionState.err.println("Failed writing " + assumptionFile + " file");
                }
            }
        }
    }

    private static class CfDefNamesComparator
    implements Comparator<CfDef> {
        private CfDefNamesComparator() {
        }

        @Override
        public int compare(CfDef a, CfDef b) {
            return a.name.compareTo(b.name);
        }
    }

    private static class KsDefNamesComparator
    implements Comparator<KsDef> {
        private KsDefNamesComparator() {
        }

        @Override
        public int compare(KsDef a, KsDef b) {
            return a.name.compareTo(b.name);
        }
    }

    protected static enum ColumnFamilyArgument {
        COLUMN_TYPE,
        COMPARATOR,
        SUBCOMPARATOR,
        COMMENT,
        READ_REPAIR_CHANCE,
        DCLOCAL_READ_REPAIR_CHANCE,
        GC_GRACE,
        COLUMN_METADATA,
        MEMTABLE_OPERATIONS,
        MEMTABLE_THROUGHPUT,
        DEFAULT_VALIDATION_CLASS,
        MIN_COMPACTION_THRESHOLD,
        MAX_COMPACTION_THRESHOLD,
        REPLICATE_ON_WRITE,
        KEY_VALIDATION_CLASS,
        COMPACTION_STRATEGY,
        COMPACTION_STRATEGY_OPTIONS,
        COMPRESSION_OPTIONS,
        BLOOM_FILTER_FP_CHANCE,
        CACHING;

    }

    private static enum AddKeyspaceArgument {
        PLACEMENT_STRATEGY,
        STRATEGY_OPTIONS,
        DURABLE_WRITES;

    }

    public static enum Function {
        BYTES(BytesType.instance),
        INTEGER(IntegerType.instance),
        LONG(LongType.instance),
        INT(Int32Type.instance),
        LEXICALUUID(LexicalUUIDType.instance),
        TIMEUUID(TimeUUIDType.instance),
        UTF8(UTF8Type.instance),
        ASCII(AsciiType.instance),
        DOUBLE(DoubleType.instance),
        COUNTERCOLUMN(CounterColumnType.instance);

        private AbstractType<?> validator;

        private Function(AbstractType<?> validator) {
            this.validator = validator;
        }

        public AbstractType<?> getValidator() {
            return this.validator;
        }

        public static String getFunctionNames() {
            Function[] functions = Function.values();
            StringBuilder functionNames = new StringBuilder();
            for (int i = 0; i < functions.length; ++i) {
                StringBuilder currentName = new StringBuilder(functions[i].name().toLowerCase());
                functionNames.append((CharSequence)currentName.append(i != functions.length - 1 ? ", " : "."));
            }
            return functionNames.toString();
        }
    }
}

