/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import org.apache.cassandra.auth.Auth;

public class AuthenticatedUser {
    public static final String ANONYMOUS_USERNAME = "anonymous";
    public static final AuthenticatedUser ANONYMOUS_USER = new AuthenticatedUser("anonymous");
    private final String name;

    public AuthenticatedUser(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSuper() {
        return !this.isAnonymous() && Auth.isSuperuser(this.name);
    }

    public boolean isAnonymous() {
        return this == ANONYMOUS_USER;
    }

    public String toString() {
        return String.format("#<User %s>", this.name);
    }
}

