/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.UUIDGen;
import org.jboss.netty.buffer.ChannelBuffer;

public class ExecuteMessage
extends Message.Request {
    public static final Message.Codec<ExecuteMessage> codec = new Message.Codec<ExecuteMessage>(){

        @Override
        public ExecuteMessage decode(ChannelBuffer body) {
            byte[] id = CBUtil.readBytes(body);
            int count = body.readUnsignedShort();
            ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>(count);
            for (int i = 0; i < count; ++i) {
                values.add(CBUtil.readValue(body));
            }
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            return new ExecuteMessage(id, values, consistency);
        }

        @Override
        public ChannelBuffer encode(ExecuteMessage msg) {
            int vs = msg.values.size();
            CBUtil.BufferBuilder builder = new CBUtil.BufferBuilder(3, 0, vs);
            builder.add(CBUtil.bytesToCB(msg.statementId.bytes));
            builder.add(CBUtil.shortToCB(vs));
            for (ByteBuffer value : msg.values) {
                builder.addValue(value);
            }
            builder.add(CBUtil.consistencyLevelToCB(msg.consistency));
            return builder.build();
        }
    };
    public final MD5Digest statementId;
    public final List<ByteBuffer> values;
    public final ConsistencyLevel consistency;

    public ExecuteMessage(byte[] statementId, List<ByteBuffer> values, ConsistencyLevel consistency) {
        this(MD5Digest.wrap(statementId), values, consistency);
    }

    public ExecuteMessage(MD5Digest statementId, List<ByteBuffer> values, ConsistencyLevel consistency) {
        super(Message.Type.EXECUTE);
        this.statementId = statementId;
        this.values = values;
        this.consistency = consistency;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            CQLStatement statement = QueryProcessor.getPrepared(this.statementId);
            if (statement == null) {
                throw new PreparedQueryNotFoundException(this.statementId);
            }
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.makeType1UUIDFromHost(FBUtilities.getBroadcastAddress());
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                Tracing.instance().begin("Execute CQL3 prepared query", Collections.<String, String>emptyMap());
            }
            ResultMessage response = QueryProcessor.processPrepared(statement, this.consistency, state, this.values);
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public String toString() {
        return "EXECUTE " + this.statementId + " with " + this.values.size() + " values at consistency " + (Object)((Object)this.consistency);
    }
}

