/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.util.BitSet;
import java.util.Random;

class PureRandom
extends Random {
    private final BitSet bs = new BitSet();
    private int lastUb;

    PureRandom() {
    }

    @Override
    public int nextInt(int ub) {
        if (ub <= 0) {
            throw new IllegalArgumentException("ub must be positive");
        }
        if (this.lastUb != ub) {
            this.bs.clear();
            this.lastUb = ub;
        } else if (this.bs.cardinality() == ub) {
            this.bs.clear();
        }
        int value = super.nextInt(ub);
        while (this.bs.get(value)) {
            value = super.nextInt(ub);
        }
        this.bs.set(value);
        return value;
    }

    public static void main(String[] args) throws Throwable {
        int[] ubs;
        PureRandom pr = new PureRandom();
        for (int ub : ubs = new int[]{2, 3, 1, 10, 5, 0}) {
            System.out.println("UB: " + String.valueOf(ub));
            for (int j = 0; j < 10; ++j) {
                int junk = ((Random)pr).nextInt(ub);
                System.out.println(junk);
            }
        }
    }
}

