/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;

public class IncludingExcludingBounds<T extends RingPosition>
extends AbstractBounds<T> {
    public IncludingExcludingBounds(T left, T right) {
        this(left, right, StorageService.getPartitioner());
    }

    IncludingExcludingBounds(T left, T right, IPartitioner partitioner) {
        super(left, right, partitioner);
        assert (left.compareTo(right) < 0 || right.isMinimum(partitioner)) : "[" + left + "," + right + ")";
    }

    @Override
    public boolean contains(T position) {
        return (Range.contains(this.left, this.right, position) || this.left.equals(position)) && !this.right.equals(position);
    }

    @Override
    public Pair<AbstractBounds<T>, AbstractBounds<T>> split(T position) {
        assert (this.contains(position));
        Bounds<RingPosition> lb = new Bounds<RingPosition>(this.left, (RingPosition)position, this.partitioner);
        ExcludingBounds<RingPosition> rb = new ExcludingBounds<RingPosition>((RingPosition)position, this.right, this.partitioner);
        return Pair.create(lb, rb);
    }

    @Override
    public List<? extends AbstractBounds<T>> unwrap() {
        return Collections.singletonList(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IncludingExcludingBounds)) {
            return false;
        }
        IncludingExcludingBounds rhs = (IncludingExcludingBounds)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "[" + this.left + "," + this.right + ")";
    }

    @Override
    protected String getOpeningString() {
        return "[";
    }

    @Override
    protected String getClosingString() {
        return ")";
    }

    private static IncludingExcludingBounds<RowPosition> makeRowBounds(Token left, Token right, IPartitioner partitioner) {
        return new IncludingExcludingBounds<RowPosition>(left.maxKeyBound(partitioner), right.minKeyBound(partitioner), partitioner);
    }

    @Override
    public AbstractBounds<RowPosition> toRowBounds() {
        return this.left instanceof Token ? IncludingExcludingBounds.makeRowBounds((Token)this.left, (Token)this.right, this.partitioner) : this;
    }

    @Override
    public AbstractBounds<Token> toTokenBounds() {
        return this.left instanceof RowPosition ? new IncludingExcludingBounds<Token>(((RowPosition)this.left).getToken(), ((RowPosition)this.right).getToken(), this.partitioner) : this;
    }
}

