/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ReadCommandSerializer;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.RepairCallback;

public abstract class ReadCommand
implements IReadCommand {
    public static final byte CMD_TYPE_GET_SLICE_BY_NAMES = 1;
    public static final byte CMD_TYPE_GET_SLICE = 2;
    public static final ReadCommandSerializer serializer = new ReadCommandSerializer();
    public final QueryPath queryPath;
    public final String table;
    public final ByteBuffer key;
    private boolean isDigestQuery = false;
    protected final byte commandType;

    public MessageOut<ReadCommand> createMessage() {
        return new MessageOut<ReadCommand>(MessagingService.Verb.READ, this, serializer);
    }

    protected ReadCommand(String table, ByteBuffer key, QueryPath queryPath, byte cmdType) {
        this.table = table;
        this.key = key;
        this.queryPath = queryPath;
        this.commandType = cmdType;
    }

    public boolean isDigestQuery() {
        return this.isDigestQuery;
    }

    public void setDigestQuery(boolean isDigestQuery) {
        this.isDigestQuery = isDigestQuery;
    }

    public String getColumnFamilyName() {
        return this.queryPath.columnFamilyName;
    }

    public abstract ReadCommand copy();

    public abstract Row getRow(Table var1) throws IOException;

    public abstract IDiskAtomFilter filter();

    protected AbstractType<?> getComparator() {
        return ColumnFamily.getComparatorFor(this.table, this.getColumnFamilyName(), this.queryPath.superColumnName);
    }

    @Override
    public String getKeyspace() {
        return this.table;
    }

    public ReadCommand maybeGenerateRetryCommand(RepairCallback handler, Row row) {
        return null;
    }

    public void maybeTrim(Row row) {
    }

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout();
    }
}

