/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.operations.ListOperation;
import org.apache.cassandra.cql3.operations.MapOperation;
import org.apache.cassandra.cql3.operations.Operation;
import org.apache.cassandra.cql3.operations.SetOperation;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.Selector;
import org.apache.cassandra.cql3.statements.UpdateStatement;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.utils.Pair;

public class DeleteStatement
extends ModificationStatement {
    private CFDefinition cfDef;
    private final List<Selector> columns;
    private final List<Relation> whereClause;
    private final List<Pair<CFDefinition.Name, Term>> toRemove;
    private final Map<ColumnIdentifier, List<Term>> processedKeys = new HashMap<ColumnIdentifier, List<Term>>();

    public DeleteStatement(CFName name, List<Selector> columns, List<Relation> whereClause, Attributes attrs) {
        super(name, attrs);
        this.columns = columns;
        this.whereClause = whereClause;
        this.toRemove = new ArrayList<Pair<CFDefinition.Name, Term>>(columns.size());
    }

    @Override
    protected void validateConsistency(ConsistencyLevel cl) throws InvalidRequestException {
        if (this.type == ModificationStatement.Type.COUNTER) {
            cl.validateCounterForWrite(this.cfDef.cfm);
        } else {
            cl.validateForWrite(this.cfDef.cfm.ksName);
        }
    }

    public Collection<RowMutation> getMutations(List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        boolean isRange;
        boolean fullKey;
        List<ByteBuffer> keys = UpdateStatement.buildKeyNames(this.cfDef, this.processedKeys, variables);
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        CFDefinition.Name firstEmpty = UpdateStatement.buildColumnNames(this.cfDef, this.processedKeys, builder, variables, false);
        boolean bl = fullKey = builder.componentCount() == this.cfDef.columns.size();
        boolean bl2 = this.cfDef.isCompact ? !fullKey : (isRange = !fullKey || this.toRemove.isEmpty());
        if (!this.toRemove.isEmpty() && isRange) {
            throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s since %s specified", firstEmpty, this.toRemove.iterator().next().left));
        }
        TreeSet<ByteBuffer> toRead = null;
        for (Pair<CFDefinition.Name, Term> p : this.toRemove) {
            CFDefinition.Name name = (CFDefinition.Name)p.left;
            Term value = (Term)p.right;
            if (!(name.type instanceof ListType) || value == null) continue;
            if (toRead == null) {
                toRead = new TreeSet<ByteBuffer>(UTF8Type.instance);
            }
            toRead.add(name.name.key);
        }
        Map<ByteBuffer, ColumnGroupMap> rows = toRead != null ? this.readRows(keys, builder, toRead, (CompositeType)this.cfDef.cfm.comparator, local, cl) : null;
        ArrayList<RowMutation> rowMutations = new ArrayList<RowMutation>(keys.size());
        UpdateParameters params = new UpdateParameters(variables, this.getTimestamp(now), -1);
        for (ByteBuffer key : keys) {
            rowMutations.add(this.mutationForKey(this.cfDef, key, builder, isRange, params, rows == null ? null : rows.get(key)));
        }
        return rowMutations;
    }

    public RowMutation mutationForKey(CFDefinition cfDef, ByteBuffer key, ColumnNameBuilder builder, boolean isRange, UpdateParameters params, ColumnGroupMap group) throws InvalidRequestException {
        QueryProcessor.validateKey(key);
        RowMutation rm = new RowMutation(cfDef.cfm.ksName, key);
        ColumnFamily cf = rm.addOrGet(this.columnFamily());
        if (this.columns.isEmpty() && builder.componentCount() == 0) {
            cf.delete(new DeletionInfo(params.timestamp, params.localDeletionTime));
        } else if (isRange) {
            ByteBuffer start = builder.copy().build();
            ByteBuffer end = builder.buildAsEndOfRange();
            QueryProcessor.validateColumnName(start);
            cf.addAtom(params.makeRangeTombstone(start, end));
        } else if (cfDef.isCompact) {
            ByteBuffer columnName = builder.build();
            QueryProcessor.validateColumnName(columnName);
            cf.addColumn(params.makeTombstone(columnName));
        } else {
            Iterator<Pair<CFDefinition.Name, Term>> iter = this.toRemove.iterator();
            while (iter.hasNext()) {
                Pair<CFDefinition.Name, Term> p = iter.next();
                CFDefinition.Name column = (CFDefinition.Name)p.left;
                if (column.type.isCollection()) {
                    Operation op;
                    CollectionType validator = (CollectionType)column.type;
                    Term keySelected = (Term)p.right;
                    if (keySelected == null) {
                        ByteBuffer start = builder.copy().add(column.name.key).build();
                        QueryProcessor.validateColumnName(start);
                        ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                        ByteBuffer end = b.add(column.name.key).buildAsEndOfRange();
                        cf.addAtom(params.makeRangeTombstone(start, end));
                        continue;
                    }
                    builder.add(column.name.key);
                    List<Term> args = Collections.singletonList(keySelected);
                    switch (validator.kind) {
                        case LIST: {
                            op = ListOperation.DiscardKey(args);
                            break;
                        }
                        case SET: {
                            op = SetOperation.Discard(args);
                            break;
                        }
                        case MAP: {
                            op = MapOperation.DiscardKey(keySelected);
                            break;
                        }
                        default: {
                            throw new InvalidRequestException("Unknown collection type: " + (Object)((Object)validator.kind));
                        }
                    }
                    op.execute(cf, builder, validator, params, group == null ? null : group.getCollection(column.name.key));
                    continue;
                }
                ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                ByteBuffer columnName = b.add(column.name.key).build();
                QueryProcessor.validateColumnName(columnName);
                cf.addColumn(params.makeTombstone(columnName));
            }
        }
        return rm;
    }

    @Override
    public ParsedStatement.Prepared prepare(CFDefinition.Name[] boundNames) throws InvalidRequestException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        this.type = metadata.getDefaultValidator().isCommutative() ? ModificationStatement.Type.COUNTER : ModificationStatement.Type.LOGGED;
        this.cfDef = metadata.getCfDef();
        UpdateStatement.processKeys(this.cfDef, this.whereClause, this.processedKeys, boundNames);
        for (Selector column : this.columns) {
            CFDefinition.Name name = this.cfDef.get(column.id());
            if (name == null) {
                throw new InvalidRequestException(String.format("Unknown identifier %s", column));
            }
            if (name.kind != CFDefinition.Name.Kind.COLUMN_METADATA && name.kind != CFDefinition.Name.Kind.VALUE_ALIAS) {
                throw new InvalidRequestException(String.format("Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", column));
            }
            if (column.key() != null && !(name.type instanceof ListType) && !(name.type instanceof MapType)) {
                throw new InvalidRequestException(String.format("Invalid selection %s since %s is neither a list or a map", column, column.id()));
            }
            this.toRemove.add(Pair.create(name, column.key()));
        }
        return new ParsedStatement.Prepared(this, Arrays.asList(boundNames));
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        CFDefinition.Name[] boundNames = new CFDefinition.Name[this.getBoundsTerms()];
        return this.prepare(boundNames);
    }

    public String toString() {
        return String.format("DeleteStatement(name=%s, columns=%s, keys=%s)", this.cfName, this.columns, this.whereClause);
    }
}

