/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.PropertyDefinitions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFPropDefs
extends PropertyDefinitions {
    private static final Logger logger = LoggerFactory.getLogger(CFPropDefs.class);
    public static final String KW_COMMENT = "comment";
    public static final String KW_READREPAIRCHANCE = "read_repair_chance";
    public static final String KW_DCLOCALREADREPAIRCHANCE = "dclocal_read_repair_chance";
    public static final String KW_GCGRACESECONDS = "gc_grace_seconds";
    public static final String KW_MINCOMPACTIONTHRESHOLD = "min_threshold";
    public static final String KW_MAXCOMPACTIONTHRESHOLD = "max_threshold";
    public static final String KW_REPLICATEONWRITE = "replicate_on_write";
    public static final String KW_CACHING = "caching";
    public static final String KW_BF_FP_CHANCE = "bloom_filter_fp_chance";
    public static final String KW_COMPACTION = "compaction";
    public static final String KW_COMPRESSION = "compression";
    public static final String COMPACTION_STRATEGY_CLASS_KEY = "class";
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> obsoleteKeywords = new HashSet<String>();
    private Class<? extends AbstractCompactionStrategy> compactionStrategyClass = null;

    public void validate() throws ConfigurationException, SyntaxException {
        this.validate(keywords, obsoleteKeywords);
        Map<String, String> compactionOptions = this.getCompactionOptions();
        if (!compactionOptions.isEmpty()) {
            String strategy = compactionOptions.get(COMPACTION_STRATEGY_CLASS_KEY);
            if (strategy == null) {
                throw new ConfigurationException("Missing sub-option 'class' for the 'compaction' option.");
            }
            this.compactionStrategyClass = CFMetaData.createCompactionStrategy(strategy);
            compactionOptions.remove(COMPACTION_STRATEGY_CLASS_KEY);
        }
    }

    public Map<String, String> getCompactionOptions() throws SyntaxException {
        Map<String, String> compactionOptions = this.getMap(KW_COMPACTION);
        if (compactionOptions == null) {
            return Collections.emptyMap();
        }
        return compactionOptions;
    }

    public Map<String, String> getCompressionOptions() throws SyntaxException {
        Map<String, String> compressionOptions = this.getMap(KW_COMPRESSION);
        if (compressionOptions == null) {
            return new HashMap<String, String>(){
                {
                    if (CFMetaData.DEFAULT_COMPRESSOR != null) {
                        this.put("sstable_compression", CFMetaData.DEFAULT_COMPRESSOR);
                    }
                }
            };
        }
        return compressionOptions;
    }

    public void applyToCFMetadata(CFMetaData cfm) throws ConfigurationException, SyntaxException {
        if (this.hasProperty(KW_COMMENT).booleanValue()) {
            cfm.comment(this.getString(KW_COMMENT, ""));
        }
        cfm.readRepairChance(this.getDouble(KW_READREPAIRCHANCE, cfm.getReadRepairChance()));
        cfm.dcLocalReadRepairChance(this.getDouble(KW_DCLOCALREADREPAIRCHANCE, cfm.getDcLocalReadRepair()));
        cfm.gcGraceSeconds(this.getInt(KW_GCGRACESECONDS, cfm.getGcGraceSeconds()));
        cfm.replicateOnWrite(this.getBoolean(KW_REPLICATEONWRITE, cfm.getReplicateOnWrite()));
        cfm.minCompactionThreshold(CFPropDefs.toInt(KW_MINCOMPACTIONTHRESHOLD, this.getCompactionOptions().get(KW_MINCOMPACTIONTHRESHOLD), cfm.getMinCompactionThreshold()));
        cfm.maxCompactionThreshold(CFPropDefs.toInt(KW_MAXCOMPACTIONTHRESHOLD, this.getCompactionOptions().get(KW_MAXCOMPACTIONTHRESHOLD), cfm.getMaxCompactionThreshold()));
        cfm.caching(CFMetaData.Caching.fromString(this.getString(KW_CACHING, cfm.getCaching().toString())));
        cfm.bloomFilterFpChance(this.getDouble(KW_BF_FP_CHANCE, cfm.getBloomFilterFpChance()));
        if (this.compactionStrategyClass != null) {
            cfm.compactionStrategyClass(this.compactionStrategyClass);
            cfm.compactionStrategyOptions(new HashMap<String, String>(this.getCompactionOptions()));
        }
        if (!this.getCompressionOptions().isEmpty()) {
            cfm.compressionParameters(CompressionParameters.create(this.getCompressionOptions()));
        }
    }

    public ConsistencyLevel getConsistencyLevel(String key) throws ConfigurationException, SyntaxException {
        String value = this.getSimple(key);
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(ConsistencyLevel.class, value);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("Invalid consistency level value: %s", value));
        }
    }

    public String toString() {
        return String.format("CFPropDefs(%s)", this.properties.toString());
    }

    static {
        keywords.add(KW_COMMENT);
        keywords.add(KW_READREPAIRCHANCE);
        keywords.add(KW_DCLOCALREADREPAIRCHANCE);
        keywords.add(KW_GCGRACESECONDS);
        keywords.add(KW_REPLICATEONWRITE);
        keywords.add(KW_CACHING);
        keywords.add(KW_BF_FP_CHANCE);
        keywords.add(KW_COMPACTION);
        keywords.add(KW_COMPRESSION);
        obsoleteKeywords.add("compaction_strategy_class");
        obsoleteKeywords.add("compaction_strategy_options");
        obsoleteKeywords.add("min_compaction_threshold");
        obsoleteKeywords.add("max_compaction_threshold");
        obsoleteKeywords.add("compaction_parameters");
        obsoleteKeywords.add("compression_parameters");
    }
}

