/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.FrameCompressor;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.AuthenticateMessage;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ReadyMessage;
import org.apache.cassandra.utils.SemanticVersion;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class StartupMessage
extends Message.Request {
    public static final String CQL_VERSION = "CQL_VERSION";
    public static final String COMPRESSION = "COMPRESSION";
    public static final Message.Codec<StartupMessage> codec = new Message.Codec<StartupMessage>(){

        @Override
        public StartupMessage decode(ChannelBuffer body) {
            return new StartupMessage(CBUtil.readStringMap(body));
        }

        @Override
        public ChannelBuffer encode(StartupMessage msg) {
            ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
            CBUtil.writeStringMap(cb, msg.options);
            return cb;
        }
    };
    public final Map<String, String> options;

    public StartupMessage(Map<String, String> options) {
        super(Message.Type.STARTUP);
        this.options = options;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    @Override
    public Message.Response execute(QueryState state) {
        try {
            ClientState cState = state.getClientState();
            String cqlVersion = this.options.get(CQL_VERSION);
            if (cqlVersion == null) {
                throw new ProtocolException("Missing value CQL_VERSION in STARTUP message");
            }
            cState.setCQLVersion(cqlVersion);
            if (cState.getCQLVersion().compareTo(new SemanticVersion("2.99.0")) < 0) {
                throw new ProtocolException(String.format("CQL version %s is not support by the binary protocol (supported version are >= 3.0.0)", cqlVersion));
            }
            if (this.options.containsKey(COMPRESSION)) {
                String compression = this.options.get(COMPRESSION).toLowerCase();
                if (compression.equals("snappy")) {
                    if (FrameCompressor.SnappyCompressor.instance == null) {
                        throw new ProtocolException("This instance does not support Snappy compression");
                    }
                    this.connection.setCompressor(FrameCompressor.SnappyCompressor.instance);
                } else {
                    throw new ProtocolException(String.format("Unknown compression algorithm: %s", compression));
                }
            }
            if (cState.isLogged()) {
                return new ReadyMessage();
            }
            return new AuthenticateMessage(DatabaseDescriptor.getAuthenticator().getClass().getName());
        }
        catch (InvalidRequestException e) {
            return ErrorMessage.fromException(new ProtocolException(e.getMessage()));
        }
    }

    public String toString() {
        return "STARTUP " + this.options;
    }
}

