/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import com.google.common.base.Stopwatch;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TraceState {
    public final UUID sessionId;
    public final InetAddress coordinator;
    public final Stopwatch watch;
    public final ByteBuffer sessionIdBytes;
    public final boolean isLocallyOwned;

    public TraceState(InetAddress coordinator, UUID sessionId, boolean locallyOwned) {
        assert (coordinator != null);
        assert (sessionId != null);
        this.coordinator = coordinator;
        this.sessionId = sessionId;
        this.isLocallyOwned = locallyOwned;
        this.sessionIdBytes = ByteBufferUtil.bytes(sessionId);
        this.watch = new Stopwatch();
        this.watch.start();
    }

    public int elapsed() {
        long elapsed = this.watch.elapsedTime(TimeUnit.MICROSECONDS);
        return elapsed < Integer.MAX_VALUE ? (int)elapsed : Integer.MAX_VALUE;
    }
}

