/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AsyncRepairCallback;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.RowDigestResolver;
import org.apache.cassandra.service.RowRepairResolver;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCallback<TMessage, TResolved>
implements IAsyncCallback<TMessage> {
    protected static final Logger logger = LoggerFactory.getLogger(ReadCallback.class);
    protected static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    protected static final String localdc = snitch.getDatacenter(FBUtilities.getBroadcastAddress());
    public final IResponseResolver<TMessage, TResolved> resolver;
    protected final SimpleCondition condition = new SimpleCondition();
    private final long startTime;
    protected final int blockfor;
    final List<InetAddress> endpoints;
    private final IReadCommand command;
    protected final ConsistencyLevel consistencyLevel;
    protected final AtomicInteger received = new AtomicInteger(0);

    public ReadCallback(IResponseResolver<TMessage, TResolved> resolver, ConsistencyLevel consistencyLevel, IReadCommand command, List<InetAddress> endpoints) {
        this.command = command;
        this.blockfor = consistencyLevel.blockFor(command.getKeyspace());
        this.resolver = resolver;
        this.startTime = System.currentTimeMillis();
        this.consistencyLevel = consistencyLevel;
        this.sortForConsistencyLevel(endpoints);
        List<InetAddress> list = this.endpoints = resolver instanceof RowRepairResolver ? endpoints : this.filterEndpoints(endpoints);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Blockfor is %s; setting up requests to %s", this.blockfor, StringUtils.join(this.endpoints, (String)",")));
        }
    }

    protected void sortForConsistencyLevel(List<InetAddress> endpoints) {
    }

    private List<InetAddress> filterEndpoints(List<InetAddress> ep) {
        if (this.resolver instanceof RowDigestResolver) {
            assert (this.command instanceof ReadCommand) : this.command;
            String table = ((RowDigestResolver)this.resolver).table;
            String columnFamily = ((ReadCommand)this.command).getColumnFamilyName();
            CFMetaData cfmd = Schema.instance.getTableMetaData(table).get(columnFamily);
            double chance = FBUtilities.threadLocalRandom().nextDouble();
            if (cfmd.getReadRepairChance() > chance) {
                return ep;
            }
            if (cfmd.getDcLocalReadRepair() > chance) {
                ArrayList local = Lists.newArrayList();
                ArrayList other = Lists.newArrayList();
                for (InetAddress add : ep) {
                    if (snitch.getDatacenter(add).equals(localdc)) {
                        local.add(add);
                        continue;
                    }
                    other.add(add);
                }
                if (local.size() < this.blockfor) {
                    local.addAll(other.subList(0, Math.min(this.blockfor - local.size(), other.size())));
                }
                return local;
            }
        }
        return ep.subList(0, Math.min(ep.size(), this.blockfor));
    }

    public TResolved get() throws ReadTimeoutException, DigestMismatchException, IOException {
        boolean success;
        long timeout = this.command.getTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            throw new ReadTimeoutException(this.consistencyLevel, this.received.get(), this.blockfor, this.resolver.isDataPresent());
        }
        return this.blockfor == 1 ? this.resolver.getData() : this.resolver.resolve();
    }

    @Override
    public void response(MessageIn<TMessage> message) {
        int n;
        this.resolver.preprocess(message);
        int n2 = n = this.waitingFor(message) ? this.received.incrementAndGet() : this.received.get();
        if (n >= this.blockfor && this.resolver.isDataPresent()) {
            this.condition.signal();
            this.maybeResolveForRepair();
        }
    }

    protected boolean waitingFor(MessageIn message) {
        return true;
    }

    public void response(TMessage result) {
        MessageIn<TMessage> message = MessageIn.create(FBUtilities.getBroadcastAddress(), result, Collections.<String, byte[]>emptyMap(), MessagingService.Verb.INTERNAL_RESPONSE, 5);
        this.response((TMessage)message);
    }

    protected void maybeResolveForRepair() {
        if (this.blockfor < this.endpoints.size() && this.received.get() == this.endpoints.size()) {
            assert (this.resolver.isDataPresent());
            StageManager.getStage(Stage.READ_REPAIR).execute(new AsyncRepairRunner());
        }
    }

    public void assureSufficientLiveNodes() throws UnavailableException {
        if (this.endpoints.size() < this.blockfor) {
            logger.debug("Live nodes {} do not satisfy ConsistencyLevel ({} required)", (Object)StringUtils.join(this.endpoints, (String)", "), (Object)this.blockfor);
            throw new UnavailableException(this.consistencyLevel, this.blockfor, this.endpoints.size());
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return true;
    }

    private class AsyncRepairRunner
    extends WrappedRunnable {
        private AsyncRepairRunner() {
        }

        @Override
        protected void runMayThrow() throws IOException {
            try {
                ReadCallback.this.resolver.resolve();
            }
            catch (DigestMismatchException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Digest mismatch:", (Throwable)e);
                }
                ReadCommand readCommand = (ReadCommand)ReadCallback.this.command;
                RowRepairResolver repairResolver = new RowRepairResolver(readCommand.table, readCommand.key, readCommand.filter());
                AsyncRepairCallback repairHandler = new AsyncRepairCallback(repairResolver, ReadCallback.this.endpoints.size());
                MessageOut<ReadCommand> message = ((ReadCommand)ReadCallback.this.command).createMessage();
                for (InetAddress endpoint : ReadCallback.this.endpoints) {
                    MessagingService.instance().sendRR(message, endpoint, repairHandler);
                }
            }
        }
    }
}

