/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.utils.FBUtilities;

public class DatacenterSyncWriteResponseHandler
extends AbstractWriteResponseHandler {
    private static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private static final String localdc = snitch.getDatacenter(FBUtilities.getBroadcastAddress());
    private final String table;
    private final NetworkTopologyStrategy strategy;
    private final HashMap<String, AtomicInteger> responses = new HashMap();

    public DatacenterSyncWriteResponseHandler(Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, String table, Runnable callback, WriteType writeType) {
        super(naturalEndpoints, pendingEndpoints, consistencyLevel, callback, writeType);
        assert (consistencyLevel == ConsistencyLevel.EACH_QUORUM);
        this.table = table;
        this.strategy = (NetworkTopologyStrategy)Table.open(table).getReplicationStrategy();
        for (String dc : this.strategy.getDatacenters()) {
            int rf = this.strategy.getReplicationFactor(dc);
            this.responses.put(dc, new AtomicInteger(rf / 2 + 1));
        }
    }

    @Override
    public void response(MessageIn message) {
        String dataCenter = message == null ? localdc : snitch.getDatacenter(message.from);
        this.responses.get(dataCenter).getAndDecrement();
        for (AtomicInteger i : this.responses.values()) {
            if (i.get() <= 0) continue;
            return;
        }
        this.signal();
    }

    @Override
    protected int blockForCL() {
        return this.consistencyLevel.blockFor(this.table);
    }

    @Override
    protected int ackCount() {
        int n = 0;
        for (Map.Entry<String, AtomicInteger> entry : this.responses.entrySet()) {
            String dc = entry.getKey();
            AtomicInteger i = entry.getValue();
            n += this.strategy.getReplicationFactor(dc) / 2 + 1 - i.get();
        }
        return n;
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        HashMap<String, AtomicInteger> dcEndpoints = new HashMap<String, AtomicInteger>();
        for (String dc : this.strategy.getDatacenters()) {
            dcEndpoints.put(dc, new AtomicInteger());
        }
        for (InetAddress destination : Iterables.concat((Iterable)this.naturalEndpoints, (Iterable)this.pendingEndpoints)) {
            if (!FailureDetector.instance.isAlive(destination)) continue;
            String destinationDC = snitch.getDatacenter(destination);
            ((AtomicInteger)dcEndpoints.get(destinationDC)).incrementAndGet();
        }
        for (String dc : this.strategy.getDatacenters()) {
            if (((AtomicInteger)dcEndpoints.get(dc)).get() >= this.responses.get(dc).get()) continue;
            throw new UnavailableException(this.consistencyLevel, this.responses.get(dc).get(), ((AtomicInteger)dcEndpoints.get(dc)).get());
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

