/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.LocalToken;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.BloomFilterTracker;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableBoundedScanner;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.io.util.CompressedSegmentedFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.AlwaysPresentFilter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.LegacyBloomFilter;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableReader
extends SSTable {
    private static final Logger logger = LoggerFactory.getLogger(SSTableReader.class);
    private static final int INDEX_FILE_BUFFER_BYTES = 16 * DatabaseDescriptor.getIndexInterval();
    public final long maxDataAge;
    private SegmentedFile ifile;
    private SegmentedFile dfile;
    private IndexSummary indexSummary;
    private IFilter bf;
    private InstrumentingCache<KeyCacheKey, RowIndexEntry> keyCache;
    private final BloomFilterTracker bloomFilterTracker = new BloomFilterTracker();
    private final AtomicInteger references = new AtomicInteger(1);
    private final AtomicBoolean isCompacted = new AtomicBoolean(false);
    private final AtomicBoolean isSuspect = new AtomicBoolean(false);
    private final SSTableDeletingTask deletingTask;
    private final SSTableMetadata sstableMetadata;

    public static long getApproximateKeyCount(Iterable<SSTableReader> sstables) {
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            int indexKeyCount = sstable.getKeySamples().size();
            count += (long)((indexKeyCount + 1) * DatabaseDescriptor.getIndexInterval());
            if (!logger.isDebugEnabled()) continue;
            logger.debug("index size for bloom filter calc for file  : " + sstable.getFilename() + "   : " + count);
        }
        return count;
    }

    public static SSTableReader open(Descriptor descriptor) throws IOException {
        CFMetaData metadata;
        if (descriptor.cfname.contains(".")) {
            int i = descriptor.cfname.indexOf(".");
            String parentName = descriptor.cfname.substring(0, i);
            CFMetaData parent = Schema.instance.getCFMetaData(descriptor.ksname, parentName);
            ColumnDefinition def = parent.getColumnDefinitionForIndex(descriptor.cfname.substring(i + 1));
            metadata = CFMetaData.newIndexMetadata(parent, def, SecondaryIndex.getIndexComparator(parent, def));
        } else {
            metadata = Schema.instance.getCFMetaData(descriptor.ksname, descriptor.cfname);
        }
        return SSTableReader.open(descriptor, metadata);
    }

    public static SSTableReader open(Descriptor desc, CFMetaData metadata) throws IOException {
        IPartitioner<LocalToken> p = desc.cfname.contains(".") ? new LocalPartitioner(metadata.getKeyValidator()) : StorageService.getPartitioner();
        return SSTableReader.open(desc, SSTableReader.componentsFor(desc), metadata, p);
    }

    public static SSTableReader openNoValidation(Descriptor descriptor, Set<Component> components, CFMetaData metadata) throws IOException {
        return SSTableReader.open(descriptor, components, metadata, StorageService.getPartitioner(), false);
    }

    public static SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner) throws IOException {
        return SSTableReader.open(descriptor, components, metadata, partitioner, true);
    }

    private static SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, boolean validate) throws IOException {
        assert (partitioner != null);
        assert (components.contains(Component.DATA));
        assert (components.contains(Component.PRIMARY_INDEX));
        long start = System.currentTimeMillis();
        logger.info("Opening {} ({} bytes)", (Object)descriptor, (Object)new File(descriptor.filenameFor(COMPONENT_DATA)).length());
        SSTableMetadata sstableMetadata = components.contains(Component.STATS) ? SSTableMetadata.serializer.deserialize(descriptor) : SSTableMetadata.createDefaultInstance();
        String partitionerName = partitioner.getClass().getCanonicalName();
        if (sstableMetadata.partitioner != null && !partitionerName.equals(sstableMetadata.partitioner)) {
            logger.error(String.format("Cannot open %s because partitioner does not match %s != %s.  Please verify your partitioner in cassandra.yaml", descriptor, sstableMetadata.partitioner, partitionerName));
            System.exit(1);
        }
        SSTableReader sstable = new SSTableReader(descriptor, components, metadata, partitioner, null, null, null, null, System.currentTimeMillis(), sstableMetadata);
        if (descriptor.version.hasStringsInBloomFilter) {
            sstable.load(true);
        } else {
            sstable.load(false);
            sstable.loadBloomFilter();
        }
        if (validate) {
            sstable.validate();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("INDEX LOAD TIME for " + descriptor + ": " + (System.currentTimeMillis() - start) + " ms.");
        }
        if (logger.isDebugEnabled() && sstable.getKeyCache() != null) {
            logger.debug(String.format("key cache contains %s/%s keys", sstable.getKeyCache().size(), sstable.getKeyCache().getCapacity()));
        }
        return sstable;
    }

    public static void logOpenException(Descriptor descriptor, IOException e) {
        if (e instanceof FileNotFoundException) {
            logger.error("Missing sstable component in " + descriptor + "; skipped because of " + e.getMessage());
        } else {
            logger.error("Corrupt sstable " + descriptor + "; skipped", (Throwable)e);
        }
    }

    public static Collection<SSTableReader> batchOpen(Set<Map.Entry<Descriptor, Set<Component>>> entries, final CFMetaData metadata, final IPartitioner partitioner) {
        final LinkedBlockingQueue<SSTableReader> sstables = new LinkedBlockingQueue<SSTableReader>();
        DebuggableThreadPoolExecutor executor = DebuggableThreadPoolExecutor.createWithFixedPoolSize("SSTableBatchOpen", Runtime.getRuntime().availableProcessors());
        for (final Map.Entry<Descriptor, Set<Component>> entry : entries) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SSTableReader sstable;
                    try {
                        sstable = SSTableReader.open((Descriptor)entry.getKey(), (Set)entry.getValue(), metadata, partitioner);
                    }
                    catch (IOException ex) {
                        logger.error("Corrupt sstable " + entry + "; skipped", (Throwable)ex);
                        return;
                    }
                    sstables.add(sstable);
                }
            };
            executor.submit(runnable);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(7L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        return sstables;
    }

    static SSTableReader internalOpen(Descriptor desc, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, SegmentedFile ifile, SegmentedFile dfile, IndexSummary isummary, IFilter bf, long maxDataAge, SSTableMetadata sstableMetadata) {
        assert (desc != null && partitioner != null && ifile != null && dfile != null && isummary != null && bf != null && sstableMetadata != null);
        return new SSTableReader(desc, components, metadata, partitioner, ifile, dfile, isummary, bf, maxDataAge, sstableMetadata);
    }

    private SSTableReader(Descriptor desc, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, SegmentedFile ifile, SegmentedFile dfile, IndexSummary indexSummary, IFilter bloomFilter, long maxDataAge, SSTableMetadata sstableMetadata) {
        super(desc, components, metadata, partitioner);
        this.sstableMetadata = sstableMetadata;
        this.maxDataAge = maxDataAge;
        this.ifile = ifile;
        this.dfile = dfile;
        this.indexSummary = indexSummary;
        this.bf = bloomFilter;
        this.deletingTask = new SSTableDeletingTask(this);
    }

    public void setTrackedBy(DataTracker tracker) {
        this.deletingTask.setTracker(tracker);
        this.keyCache = CacheService.instance.keyCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadBloomFilter() throws IOException {
        if (!this.components.contains(Component.FILTER)) {
            this.bf = new AlwaysPresentFilter();
            return;
        }
        DataInputStream stream = null;
        try {
            stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.descriptor.filenameFor(Component.FILTER))));
            this.bf = FilterFactory.deserialize(stream, this.descriptor.version.filterType, true);
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(stream);
            throw throwable;
        }
        FileUtils.closeQuietly(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(boolean recreatebloom) throws IOException {
        SegmentedFile.Builder ibuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode());
        SegmentedFile.Builder dbuilder = this.compression ? SegmentedFile.getCompressedBuilder() : SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode());
        RandomAccessReader primaryIndex = RandomAccessReader.open(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)), true);
        boolean summaryLoaded = SSTableReader.loadSummary(this, ibuilder, dbuilder);
        boolean readIndex = recreatebloom || !summaryLoaded;
        try {
            long indexPosition;
            long estimatedKeys;
            long indexSize = primaryIndex.length();
            long histogramCount = this.sstableMetadata.estimatedRowSize.count();
            long l = estimatedKeys = histogramCount > 0L && !this.sstableMetadata.estimatedRowSize.isOverflowed() ? histogramCount : this.estimateRowsFromIndex(primaryIndex);
            if (recreatebloom) {
                this.bf = LegacyBloomFilter.getFilter(estimatedKeys, 15);
            }
            if (!summaryLoaded) {
                this.indexSummary = new IndexSummary(estimatedKeys);
            }
            while (readIndex && (indexPosition = primaryIndex.getFilePointer()) != indexSize) {
                ByteBuffer key = ByteBufferUtil.readWithShortLength(primaryIndex);
                RowIndexEntry indexEntry = RowIndexEntry.serializer.deserialize(primaryIndex, this.descriptor.version);
                DecoratedKey decoratedKey = SSTableReader.decodeKey(this.partitioner, this.descriptor, key);
                if (this.first == null) {
                    this.first = decoratedKey;
                }
                this.last = decoratedKey;
                if (recreatebloom) {
                    this.bf.add(decoratedKey.key);
                }
                if (summaryLoaded) continue;
                this.indexSummary.maybeAddEntry(decoratedKey, indexPosition);
                ibuilder.addPotentialBoundary(indexPosition);
                dbuilder.addPotentialBoundary(indexEntry.position);
            }
        }
        finally {
            FileUtils.closeQuietly(primaryIndex);
        }
        this.first = SSTableReader.getMinimalKey(this.first);
        this.last = SSTableReader.getMinimalKey(this.last);
        this.indexSummary.complete();
        this.ifile = ibuilder.complete(this.descriptor.filenameFor(Component.PRIMARY_INDEX));
        this.dfile = dbuilder.complete(this.descriptor.filenameFor(Component.DATA));
        if (readIndex) {
            SSTableReader.saveSummary(this, ibuilder, dbuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadSummary(SSTableReader reader, SegmentedFile.Builder ibuilder, SegmentedFile.Builder dbuilder) {
        File summariesFile = new File(reader.descriptor.filenameFor(Component.SUMMARY));
        if (!summariesFile.exists()) {
            return false;
        }
        DataInputStream iStream = null;
        try {
            iStream = new DataInputStream(new FileInputStream(summariesFile));
            reader.indexSummary = IndexSummary.serializer.deserialize(iStream, reader.partitioner);
            reader.first = SSTableReader.decodeKey(reader.partitioner, reader.descriptor, ByteBufferUtil.readWithLength(iStream));
            reader.last = SSTableReader.decodeKey(reader.partitioner, reader.descriptor, ByteBufferUtil.readWithLength(iStream));
            ibuilder.deserializeBounds(iStream);
            dbuilder.deserializeBounds(iStream);
        }
        catch (IOException e) {
            boolean bl;
            try {
                logger.debug("Cannot deserialize SSTable Summary: ", (Throwable)e);
                if (summariesFile.exists()) {
                    summariesFile.delete();
                }
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(iStream);
                throw throwable;
            }
            FileUtils.closeQuietly(iStream);
            return bl;
        }
        FileUtils.closeQuietly(iStream);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSummary(SSTableReader reader, SegmentedFile.Builder ibuilder, SegmentedFile.Builder dbuilder) {
        File summariesFile = new File(reader.descriptor.filenameFor(Component.SUMMARY));
        if (summariesFile.exists()) {
            summariesFile.delete();
        }
        DataOutputStream oStream = null;
        try {
            oStream = new DataOutputStream(new FileOutputStream(summariesFile));
            IndexSummary.serializer.serialize(reader.indexSummary, oStream);
            ByteBufferUtil.writeWithLength(reader.first.key, (DataOutput)oStream);
            ByteBufferUtil.writeWithLength(reader.last.key, (DataOutput)oStream);
            ibuilder.serializeBounds(oStream);
            dbuilder.serializeBounds(oStream);
        }
        catch (IOException e) {
            block5: {
                try {
                    logger.debug("Cannot save SSTable Summary: ", (Throwable)e);
                    if (!summariesFile.exists()) break block5;
                    summariesFile.delete();
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(oStream);
                    throw throwable;
                }
            }
            FileUtils.closeQuietly(oStream);
        }
        FileUtils.closeQuietly(oStream);
    }

    private void validate() {
        if (this.first.compareTo(this.last) > 0) {
            throw new IllegalStateException(String.format("SSTable first key %s > last key %s", this.first, this.last));
        }
    }

    public long getIndexScanPosition(RowPosition key) {
        assert (this.indexSummary.getKeys() != null && this.indexSummary.getKeys().size() > 0);
        int index = Collections.binarySearch(this.indexSummary.getKeys(), key);
        if (index < 0) {
            int greaterThan = (index + 1) * -1;
            if (greaterThan == 0) {
                return -1L;
            }
            return this.indexSummary.getPosition(greaterThan - 1);
        }
        return this.indexSummary.getPosition(index);
    }

    public CompressionMetadata getCompressionMetadata() {
        if (!this.compression) {
            throw new IllegalStateException(this + " is not compressed");
        }
        return ((CompressedSegmentedFile)this.dfile).metadata;
    }

    public void forceFilterFailures() {
        this.bf = LegacyBloomFilter.alwaysMatchingBloomFilter();
    }

    public IFilter getBloomFilter() {
        return this.bf;
    }

    public long getBloomFilterSerializedSize() {
        return FilterFactory.serializedSize(this.bf, this.descriptor.version.filterType);
    }

    public long estimatedKeys() {
        return this.indexSummary.getKeys().size() * DatabaseDescriptor.getIndexInterval();
    }

    public long estimatedKeysForRanges(Collection<Range<Token>> ranges) {
        long sampleKeyCount = 0L;
        List<Pair<Integer, Integer>> sampleIndexes = SSTableReader.getSampleIndexesForRanges(this.indexSummary.getKeys(), ranges);
        for (Pair<Integer, Integer> sampleIndexRange : sampleIndexes) {
            sampleKeyCount += (long)((Integer)sampleIndexRange.right - (Integer)sampleIndexRange.left + 1);
        }
        return Math.max(1L, sampleKeyCount * (long)DatabaseDescriptor.getIndexInterval().intValue());
    }

    public Collection<DecoratedKey> getKeySamples() {
        return this.indexSummary.getKeys();
    }

    private static List<Pair<Integer, Integer>> getSampleIndexesForRanges(List<DecoratedKey> samples, Collection<Range<Token>> ranges) {
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
        if (samples.isEmpty()) {
            return positions;
        }
        for (Range range : Range.normalize(ranges)) {
            int right;
            Token.KeyBound leftPosition = ((Token)range.left).maxKeyBound();
            Token.KeyBound rightPosition = ((Token)range.right).maxKeyBound();
            int left = Collections.binarySearch(samples, leftPosition);
            left = left < 0 ? (left + 1) * -1 : ++left;
            if (left == samples.size()) continue;
            int n = right = Range.isWrapAround(range.left, range.right) ? samples.size() - 1 : Collections.binarySearch(samples, rightPosition);
            if (right < 0) {
                if ((right = (right + 1) * -1) == 0) continue;
                --right;
            }
            if (left > right) continue;
            positions.add(Pair.create(left, right));
        }
        return positions;
    }

    public Iterable<DecoratedKey> getKeySamples(Range<Token> range) {
        final List<DecoratedKey> samples = this.indexSummary.getKeys();
        final List<Pair<Integer, Integer>> indexRanges = SSTableReader.getSampleIndexesForRanges(samples, Collections.singletonList(range));
        if (indexRanges.isEmpty()) {
            return Collections.emptyList();
        }
        return new Iterable<DecoratedKey>(){

            @Override
            public Iterator<DecoratedKey> iterator() {
                return new Iterator<DecoratedKey>(){
                    private Iterator<Pair<Integer, Integer>> rangeIter;
                    private Pair<Integer, Integer> current;
                    private int idx;
                    {
                        this.rangeIter = indexRanges.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.current == null || this.idx > (Integer)this.current.right) {
                            if (this.rangeIter.hasNext()) {
                                this.current = this.rangeIter.next();
                                this.idx = (Integer)this.current.left;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public DecoratedKey next() {
                        RowPosition k = (RowPosition)samples.get(this.idx++);
                        assert (k instanceof DecoratedKey);
                        return (DecoratedKey)k;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public List<Pair<Long, Long>> getPositionsForRanges(Collection<Range<Token>> ranges) {
        ArrayList<Pair<Long, Long>> positions = new ArrayList<Pair<Long, Long>>();
        for (Range range : Range.normalize(ranges)) {
            long right;
            AbstractBounds<RowPosition> keyRange = range.toRowBounds();
            RowIndexEntry idxLeft = this.getPosition((RowPosition)keyRange.left, Operator.GT);
            long left = idxLeft == null ? -1L : idxLeft.position;
            if (left == -1L) continue;
            RowIndexEntry idxRight = this.getPosition((RowPosition)keyRange.right, Operator.GT);
            long l = right = idxRight == null ? -1L : idxRight.position;
            if (right == -1L || Range.isWrapAround(range.left, range.right)) {
                right = this.uncompressedLength();
            }
            if (left == right) continue;
            positions.add(Pair.create(left, right));
        }
        return positions;
    }

    public void cacheKey(DecoratedKey key, RowIndexEntry info) {
        CFMetaData.Caching caching = this.metadata.getCaching();
        if (caching == CFMetaData.Caching.NONE || caching == CFMetaData.Caching.ROWS_ONLY || this.keyCache == null || this.keyCache.getCapacity() == 0L) {
            return;
        }
        KeyCacheKey cacheKey = new KeyCacheKey(this.descriptor, key.key);
        logger.trace("Adding cache entry for {} -> {}", (Object)cacheKey, (Object)info);
        this.keyCache.put(cacheKey, info);
    }

    public RowIndexEntry getCachedPosition(DecoratedKey key, boolean updateStats) {
        return this.getCachedPosition(new KeyCacheKey(this.descriptor, key.key), updateStats);
    }

    private RowIndexEntry getCachedPosition(KeyCacheKey unifiedKey, boolean updateStats) {
        if (this.keyCache != null && this.keyCache.getCapacity() > 0L) {
            return updateStats ? this.keyCache.get(unifiedKey) : this.keyCache.getInternal(unifiedKey);
        }
        return null;
    }

    public RowIndexEntry getPosition(RowPosition key, Operator op) {
        return this.getPosition(key, op, true);
    }

    public RowIndexEntry getPosition(RowPosition key, Operator op, boolean updateCacheAndStats) {
        long sampledPosition;
        if (op == Operator.EQ) {
            assert (key instanceof DecoratedKey);
            if (!this.bf.isPresent(((DecoratedKey)key).key)) {
                logger.debug("Bloom filter allows skipping sstable {}", (Object)this.descriptor.generation);
                return null;
            }
        }
        if ((op == Operator.EQ || op == Operator.GE) && key instanceof DecoratedKey) {
            DecoratedKey decoratedKey = (DecoratedKey)key;
            KeyCacheKey cacheKey = new KeyCacheKey(this.descriptor, decoratedKey.key);
            RowIndexEntry cachedPosition = this.getCachedPosition(cacheKey, updateCacheAndStats);
            if (cachedPosition != null) {
                logger.trace("Cache hit for {} -> {}", (Object)cacheKey, (Object)cachedPosition);
                logger.debug("Key cache hit for sstable {}", (Object)this.descriptor.generation);
                return cachedPosition;
            }
        }
        if ((sampledPosition = this.getIndexScanPosition(key)) == -1L) {
            if (op == Operator.EQ && updateCacheAndStats) {
                this.bloomFilterTracker.addFalsePositive();
            }
            if (op.apply(1) >= 0) {
                sampledPosition = 0L;
            } else {
                logger.debug("Index sample allows skipping sstable {}", (Object)this.descriptor.generation);
                return null;
            }
        }
        int i = 0;
        Iterator<FileDataInput> segments = this.ifile.iterator(sampledPosition, INDEX_FILE_BUFFER_BYTES);
        while (segments.hasNext() && i <= DatabaseDescriptor.getIndexInterval()) {
            FileDataInput in = segments.next();
            try {
                while (!in.isEOF() && i <= DatabaseDescriptor.getIndexInterval()) {
                    boolean opSatisfied;
                    boolean exactMatch;
                    ++i;
                    ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                    if (op == Operator.EQ) {
                        opSatisfied = exactMatch = indexKey.equals(((DecoratedKey)key).key);
                    } else {
                        DecoratedKey indexDecoratedKey = SSTableReader.decodeKey(this.partitioner, this.descriptor, indexKey);
                        int comparison = indexDecoratedKey.compareTo(key);
                        int v = op.apply(comparison);
                        opSatisfied = v == 0;
                        boolean bl = exactMatch = comparison == 0;
                        if (v < 0) {
                            logger.debug("Partition index lookup allows skipping sstable {}", (Object)this.descriptor.generation);
                            RowIndexEntry rowIndexEntry = null;
                            return rowIndexEntry;
                        }
                    }
                    if (opSatisfied) {
                        RowIndexEntry indexEntry = RowIndexEntry.serializer.deserialize(in, this.descriptor.version);
                        if (exactMatch && updateCacheAndStats) {
                            assert (key instanceof DecoratedKey);
                            DecoratedKey decoratedKey = (DecoratedKey)key;
                            if (logger.isTraceEnabled()) {
                                FileDataInput fdi = this.dfile.getSegment(indexEntry.position);
                                DecoratedKey keyInDisk = SSTableReader.decodeKey(this.partitioner, this.descriptor, ByteBufferUtil.readWithShortLength(fdi));
                                if (!keyInDisk.equals(key)) {
                                    throw new AssertionError((Object)String.format("%s != %s in %s", keyInDisk, key, fdi.getPath()));
                                }
                                fdi.close();
                            }
                            this.cacheKey(decoratedKey, indexEntry);
                        }
                        if (op == Operator.EQ && updateCacheAndStats) {
                            this.bloomFilterTracker.addTruePositive();
                        }
                        logger.debug("Partition index lookup complete for sstable {}", (Object)this.descriptor.generation);
                        RowIndexEntry rowIndexEntry = indexEntry;
                        return rowIndexEntry;
                    }
                    RowIndexEntry.serializer.skip(in, this.descriptor.version);
                }
            }
            catch (IOException e) {
                this.markSuspect();
                throw new CorruptSSTableException((Exception)e, in.getPath());
            }
            finally {
                FileUtils.closeQuietly(in);
            }
        }
        if (op == Operator.EQ && updateCacheAndStats) {
            this.bloomFilterTracker.addFalsePositive();
        }
        logger.debug("Partition index lookup complete (bloom filter false positive) {}", (Object)this.descriptor.generation);
        return null;
    }

    public long uncompressedLength() {
        return this.dfile.length;
    }

    public long onDiskLength() {
        return this.dfile.onDiskLength;
    }

    public boolean acquireReference() {
        int n;
        do {
            if ((n = this.references.get()) > 0) continue;
            return false;
        } while (!this.references.compareAndSet(n, n + 1));
        return true;
    }

    public void releaseReference() {
        if (this.references.decrementAndGet() == 0 && this.isCompacted.get()) {
            this.ifile.cleanup();
            this.dfile.cleanup();
            this.deletingTask.schedule();
            FileUtils.closeQuietly(this.bf);
        }
        assert (this.references.get() >= 0) : "Reference counter " + this.references.get() + " for " + this.dfile.path;
    }

    public boolean markCompacted() {
        if (logger.isDebugEnabled()) {
            logger.debug("Marking " + this.getFilename() + " compacted");
        }
        return !this.isCompacted.getAndSet(true);
    }

    public void markSuspect() {
        if (logger.isDebugEnabled()) {
            logger.debug("Marking " + this.getFilename() + " as a suspect for blacklisting.");
        }
        this.isSuspect.getAndSet(true);
    }

    public boolean isMarkedSuspect() {
        return this.isSuspect.get();
    }

    public SSTableScanner getScanner(QueryFilter filter) {
        return new SSTableScanner(this, filter);
    }

    public SSTableScanner getDirectScanner() {
        return new SSTableScanner(this, true);
    }

    public SSTableScanner getDirectScanner(Range<Token> range) {
        if (range == null) {
            return this.getDirectScanner();
        }
        return new SSTableBoundedScanner(this, true, range);
    }

    public FileDataInput getFileDataInput(long position) {
        return this.dfile.getSegment(position);
    }

    public boolean newSince(long age) {
        return this.maxDataAge > age;
    }

    public static long readRowSize(DataInput in, Descriptor d) throws IOException {
        if (d.version.hasIntRowSize) {
            return in.readInt();
        }
        return in.readLong();
    }

    public void createLinks(String snapshotDirectoryPath) {
        for (Component component : this.components) {
            File sourceFile = new File(this.descriptor.filenameFor(component));
            File targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
            FileUtils.createHardLink(sourceFile, targetLink);
        }
    }

    public static DecoratedKey decodeKey(IPartitioner p, Descriptor d, ByteBuffer bytes) {
        if (d.version.hasEncodedKeys) {
            return p.convertFromDiskFormat(bytes);
        }
        return p.decorateKey(bytes);
    }

    public DecoratedKey decodeKey(ByteBuffer bytes) {
        return SSTableReader.decodeKey(this.partitioner, this.descriptor, bytes);
    }

    public long getBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getFalsePositiveCount();
    }

    public long getRecentBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getRecentFalsePositiveCount();
    }

    public long getBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getTruePositiveCount();
    }

    public long getRecentBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getRecentTruePositiveCount();
    }

    public InstrumentingCache<KeyCacheKey, RowIndexEntry> getKeyCache() {
        return this.keyCache;
    }

    public EstimatedHistogram getEstimatedRowSize() {
        return this.sstableMetadata.estimatedRowSize;
    }

    public EstimatedHistogram getEstimatedColumnCount() {
        return this.sstableMetadata.estimatedColumnCount;
    }

    public double getEstimatedDroppableTombstoneRatio(int gcBefore) {
        return this.sstableMetadata.getEstimatedDroppableTombstoneRatio(gcBefore);
    }

    public double getCompressionRatio() {
        return this.sstableMetadata.compressionRatio;
    }

    public ReplayPosition getReplayPosition() {
        return this.sstableMetadata.replayPosition;
    }

    public long getMaxTimestamp() {
        return this.sstableMetadata.maxTimestamp;
    }

    public Set<Integer> getAncestors() {
        return this.sstableMetadata.ancestors;
    }

    public RandomAccessReader openDataReader(boolean skipIOCache) {
        return this.compression ? CompressedRandomAccessReader.open(this.getFilename(), this.getCompressionMetadata(), skipIOCache) : RandomAccessReader.open(new File(this.getFilename()), skipIOCache);
    }

    public RandomAccessReader openIndexReader(boolean skipIOCache) {
        return RandomAccessReader.open(new File(this.getIndexFilename()), skipIOCache);
    }

    public long getCreationTimeFor(Component component) {
        return new File(this.descriptor.filenameFor(component)).lastModified();
    }

    public static boolean acquireReferences(Iterable<SSTableReader> sstables) {
        SSTableReader failed = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.acquireReference()) continue;
            failed = sstable;
            break;
        }
        if (failed == null) {
            return true;
        }
        for (SSTableReader sstable : sstables) {
            if (sstable == failed) break;
            sstable.releaseReference();
        }
        return false;
    }

    public static void releaseReferences(Iterable<SSTableReader> sstables) {
        for (SSTableReader sstable : sstables) {
            sstable.releaseReference();
        }
    }

    public static abstract class Operator {
        public static final Operator EQ = new Equals();
        public static final Operator GE = new GreaterThanOrEqualTo();
        public static final Operator GT = new GreaterThan();

        public abstract int apply(int var1);

        static final class GreaterThan
        extends Operator {
            GreaterThan() {
            }

            @Override
            public int apply(int comparison) {
                return comparison > 0 ? 0 : 1;
            }
        }

        static final class GreaterThanOrEqualTo
        extends Operator {
            GreaterThanOrEqualTo() {
            }

            @Override
            public int apply(int comparison) {
                return comparison >= 0 ? 0 : -comparison;
            }
        }

        static final class Equals
        extends Operator {
            Equals() {
            }

            @Override
            public int apply(int comparison) {
                return -comparison;
            }
        }
    }
}

