/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.operations;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.operations.Operation;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.Pair;

public class MapOperation
implements Operation {
    private final Map<Term, Term> values;
    private final Term discardKey;
    private final Kind kind;

    private MapOperation(Map<Term, Term> values, Kind kind) {
        this.values = values;
        this.discardKey = null;
        this.kind = kind;
    }

    private MapOperation(Term discardKey) {
        this.values = null;
        this.discardKey = discardKey;
        this.kind = Kind.DISCARD;
    }

    @Override
    public void execute(ColumnFamily cf, ColumnNameBuilder builder, AbstractType<?> validator, UpdateParameters params) throws InvalidRequestException {
        throw new InvalidRequestException("Map operations are only supported on Map typed columns, but " + validator + " given.");
    }

    @Override
    public void execute(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        if (validator.kind != CollectionType.Kind.MAP) {
            throw new InvalidRequestException("Map operations are only supported on Map typed columns, but " + validator + " given.");
        }
        switch (this.kind) {
            case SET: {
                cf.addAtom(params.makeTombstoneForOverwrite(builder.copy().build(), builder.copy().buildAsEndOfRange()));
            }
            case PUT: {
                this.doPut(cf, builder, validator, params);
                break;
            }
            case DISCARD: {
                this.doDiscard(cf, builder, validator, params);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported Map operation: " + (Object)((Object)this.kind)));
            }
        }
    }

    public static void doInsertFromPrepared(ColumnFamily cf, ColumnNameBuilder builder, MapType validator, Term values, UpdateParameters params) throws InvalidRequestException {
        if (!values.isBindMarker()) {
            throw new InvalidRequestException("Can't apply operation on column with " + validator + " type.");
        }
        cf.addAtom(params.makeTombstoneForOverwrite(builder.copy().build(), builder.copy().buildAsEndOfRange()));
        try {
            Object m = validator.compose(params.variables.get(values.bindIndex));
            for (Map.Entry entry : m.entrySet()) {
                ByteBuffer name = builder.copy().add(validator.nameComparator().decompose(entry.getKey())).build();
                ByteBuffer value = validator.valueComparator().decompose(entry.getValue());
                cf.addColumn(params.makeColumn(name, value));
            }
        }
        catch (MarshalException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    private void doPut(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params) throws InvalidRequestException {
        for (Map.Entry<Term, Term> entry : this.values.entrySet()) {
            ByteBuffer name = builder.copy().add(entry.getKey().getByteBuffer(validator.nameComparator(), params.variables)).build();
            ByteBuffer value = entry.getValue().getByteBuffer(validator.valueComparator(), params.variables);
            cf.addColumn(params.makeColumn(name, value));
        }
    }

    private void doDiscard(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params) throws InvalidRequestException {
        ByteBuffer name = builder.add(this.discardKey.getByteBuffer(validator.nameComparator(), params.variables)).build();
        cf.addColumn(params.makeTombstone(name));
    }

    @Override
    public List<Term> getValues() {
        ArrayList<Term> l = new ArrayList<Term>(2 * this.values.size());
        for (Map.Entry<Term, Term> entry : this.values.entrySet()) {
            l.add(entry.getKey());
            l.add(entry.getValue());
        }
        return l;
    }

    @Override
    public boolean requiresRead() {
        return this.kind == Kind.SET || this.kind == Kind.DISCARD;
    }

    @Override
    public Operation.Type getType() {
        return Operation.Type.MAP;
    }

    public static Operation Set(Map<Term, Term> values) {
        return new MapOperation(values, Kind.SET);
    }

    public static Operation Put(Map<Term, Term> values) {
        return new MapOperation(values, Kind.PUT);
    }

    public static Operation Put(final Term key, final Term value) {
        return MapOperation.Put((Map<Term, Term>)new HashMap<Term, Term>(1){
            {
                super(x0);
                this.put(key, value);
            }
        });
    }

    public static Operation DiscardKey(Term discardKey) {
        return new MapOperation(discardKey);
    }

    static enum Kind {
        SET,
        PUT,
        DISCARD;

    }
}

