/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.obs.OpenBitSet;

public class Murmur3BloomFilter
extends BloomFilter {
    public static final ISerializer<BloomFilter> serializer = new Murmur3BloomFilterSerializer();

    Murmur3BloomFilter(int hashes, long numElements, int bucketsPer) {
        super(hashes, numElements, bucketsPer);
    }

    private Murmur3BloomFilter(int hashes, OpenBitSet bs) {
        super(hashes, bs);
    }

    @Override
    protected long[] hash(ByteBuffer b, int position, int remaining, long seed) {
        return MurmurHash.hash3_x64_128(b, b.position(), b.remaining(), seed);
    }

    private static class Murmur3BloomFilterSerializer
    extends BloomFilterSerializer {
        private Murmur3BloomFilterSerializer() {
        }

        @Override
        protected BloomFilter createFilter(int hashes, OpenBitSet bs) {
            return new Murmur3BloomFilter(hashes, bs);
        }
    }
}

