/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.obs.OpenBitSet;

public class Murmur2BloomFilter
extends BloomFilter {
    public static final ISerializer<BloomFilter> serializer = new Murmur2BloomFilterSerializer();

    Murmur2BloomFilter(int hashes, long numElements, int bucketsPer) {
        super(hashes, numElements, bucketsPer);
    }

    private Murmur2BloomFilter(int hashes, OpenBitSet bs) {
        super(hashes, bs);
    }

    @Override
    protected long[] hash(ByteBuffer b, int position, int remaining, long seed) {
        long hash1 = MurmurHash.hash2_64(b, b.position(), b.remaining(), seed);
        long hash2 = MurmurHash.hash2_64(b, b.position(), b.remaining(), hash1);
        return new long[]{hash1, hash2};
    }

    private static class Murmur2BloomFilterSerializer
    extends BloomFilterSerializer {
        private Murmur2BloomFilterSerializer() {
        }

        @Override
        protected BloomFilter createFilter(int hashes, OpenBitSet bs) {
            return new Murmur2BloomFilter(hashes, bs);
        }
    }
}

