/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterId
implements Comparable<CounterId> {
    private static final Logger logger = LoggerFactory.getLogger(CounterId.class);
    public static final int LENGTH = 16;
    private final ByteBuffer id;

    private static LocalCounterIdHistory localIds() {
        return LocalIds.instance;
    }

    public static CounterId getLocalId() {
        return (CounterId)CounterId.localIds().current.get();
    }

    public static void renewLocalId() {
        CounterId.renewLocalId(FBUtilities.timestampMicros());
    }

    public static synchronized void renewLocalId(long now) {
        CounterId.localIds().renewCurrent(now);
    }

    public static List<CounterIdRecord> getOldLocalCounterIds() {
        return CounterId.localIds().olds;
    }

    public static CounterId fromInt(int n) {
        long lowBits = 0xC000000000000000L | (long)n;
        return new CounterId(ByteBuffer.allocate(16).putLong(0, 0L).putLong(8, lowBits));
    }

    public static CounterId wrap(ByteBuffer id) {
        return new CounterId(id);
    }

    public static CounterId wrap(ByteBuffer bb, int offset) {
        ByteBuffer dup = bb.duplicate();
        dup.position(offset);
        dup.limit(dup.position() + 16);
        return CounterId.wrap(dup);
    }

    private CounterId(ByteBuffer id) {
        if (id.remaining() != 16) {
            throw new IllegalArgumentException("A CounterId representation is exactly 16 bytes");
        }
        this.id = id;
    }

    public static CounterId generate() {
        return new CounterId(ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.makeType1UUIDFromHost(FBUtilities.getBroadcastAddress()))));
    }

    public ByteBuffer bytes() {
        return this.id;
    }

    public boolean isLocalId() {
        return this.equals(CounterId.getLocalId());
    }

    @Override
    public int compareTo(CounterId o) {
        return ByteBufferUtil.compareSubArrays(this.id, this.id.position(), o.id, o.id.position(), 16);
    }

    public String toString() {
        return UUIDGen.getUUID(this.id).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterId otherId = (CounterId)o;
        return this.id.equals(otherId.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static class CounterIdRecord {
        public final CounterId id;
        public final long timestamp;

        public CounterIdRecord(CounterId id, long timestamp) {
            this.id = id;
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterIdRecord otherRecord = (CounterIdRecord)o;
            return this.id.equals(otherRecord.id) && this.timestamp == otherRecord.timestamp;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.timestamp});
        }

        public String toString() {
            return String.format("(%s, %d)", this.id.toString(), this.timestamp);
        }
    }

    private static class LocalCounterIdHistory {
        private final AtomicReference<CounterId> current;
        private final List<CounterIdRecord> olds;

        LocalCounterIdHistory() {
            CounterId id = SystemTable.getCurrentLocalCounterId();
            if (id == null) {
                id = CounterId.generate();
                logger.info("No saved local counter id, using newly generated: {}", (Object)id);
                SystemTable.writeCurrentLocalCounterId(null, id, FBUtilities.timestampMicros());
                this.current = new AtomicReference<CounterId>(id);
                this.olds = new CopyOnWriteArrayList<CounterIdRecord>();
            } else {
                logger.info("Saved local counter id: {}", (Object)id);
                this.current = new AtomicReference<CounterId>(id);
                this.olds = new CopyOnWriteArrayList<CounterIdRecord>(SystemTable.getOldLocalCounterIds());
            }
        }

        synchronized void renewCurrent(long now) {
            CounterId newCounterId = CounterId.generate();
            CounterId old = this.current.get();
            SystemTable.writeCurrentLocalCounterId(old, newCounterId, now);
            this.current.set(newCounterId);
            this.olds.add(new CounterIdRecord(old, now));
        }
    }

    public static class OneShotRenewer {
        private boolean renewed = false;
        private final CounterId initialId = CounterId.getLocalId();

        public void maybeRenew(CounterColumn column) {
            if (!this.renewed && column.hasCounterId(this.initialId)) {
                CounterId.renewLocalId();
                this.renewed = true;
            }
        }
    }

    private static class LocalIds {
        static final LocalCounterIdHistory instance = new LocalCounterIdHistory();

        private LocalIds() {
        }
    }
}

