/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.jboss.netty.buffer.ChannelBuffer;

public class QueryMessage
extends Message.Request {
    public static final Message.Codec<QueryMessage> codec = new Message.Codec<QueryMessage>(){

        @Override
        public QueryMessage decode(ChannelBuffer body) {
            String query = CBUtil.readLongString(body);
            return new QueryMessage(query);
        }

        @Override
        public ChannelBuffer encode(QueryMessage msg) {
            return CBUtil.longStringToCB(msg.query);
        }
    };
    public final String query;

    public QueryMessage(String query) {
        super(Message.Type.QUERY);
        this.query = query;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    @Override
    public Message.Response execute() {
        try {
            return QueryProcessor.process(this.query, ((ServerConnection)this.connection).clientState());
        }
        catch (Exception e) {
            if (!(e instanceof UnavailableException || e instanceof InvalidRequestException || e instanceof RequestTimeoutException)) {
                logger.error("Unexpected error during query", (Throwable)e);
            }
            return ErrorMessage.fromException(e);
        }
    }

    public String toString() {
        return "QUERY " + this.query;
    }
}

