/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracing {
    public static final String TRACE_KS = "system_traces";
    public static final String EVENTS_CF = "events";
    public static final String SESSIONS_CF = "sessions";
    public static final String TRACE_HEADER = "TraceSession";
    private static final int TTL = 86400;
    private static Tracing instance = new Tracing();
    public static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    private InetAddress localAddress = FBUtilities.getLocalAddress();
    private final ThreadLocal<TraceState> state = new ThreadLocal();

    public static Tracing instance() {
        return instance;
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, Object value) {
        cf.addColumn(new ExpiringColumn(name, ByteBufferUtil.bytes(value.toString()), System.currentTimeMillis(), 86400));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, InetAddress address) {
        cf.addColumn(new ExpiringColumn(name, ByteBufferUtil.bytes(address), System.currentTimeMillis(), 86400));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, int value) {
        cf.addColumn(new ExpiringColumn(name, ByteBufferUtil.bytes(value), System.currentTimeMillis(), 86400));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, long value) {
        cf.addColumn(new ExpiringColumn(name, ByteBufferUtil.bytes(value), System.currentTimeMillis(), 86400));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, String value) {
        cf.addColumn(new ExpiringColumn(name, ByteBufferUtil.bytes(value), System.currentTimeMillis(), 86400));
    }

    private void addColumn(ColumnFamily cf, ByteBuffer name, ByteBuffer value) {
        cf.addColumn(new ExpiringColumn(name, value, System.currentTimeMillis(), 86400));
    }

    public void addParameterColumns(ColumnFamily cf, Map<String, String> rawPayload) {
        for (Map.Entry<String, String> entry : rawPayload.entrySet()) {
            cf.addColumn(new ExpiringColumn(Tracing.buildName(cf.metadata(), ByteBufferUtil.bytes("parameters"), ByteBufferUtil.bytes(entry.getKey())), ByteBufferUtil.bytes(entry.getValue()), System.currentTimeMillis(), 86400));
        }
    }

    public static ByteBuffer buildName(CFMetaData meta, ByteBuffer ... args) {
        ColumnNameBuilder builder = meta.getCfDef().getColumnNameBuilder();
        for (ByteBuffer arg : args) {
            builder.add(arg);
        }
        return builder.build();
    }

    public UUID getSessionId() {
        assert (Tracing.isTracing());
        return this.state.get().sessionId;
    }

    public static boolean isTracing() {
        return instance != null && Tracing.instance.state.get() != null;
    }

    public void reset() {
        this.state.set(null);
    }

    public UUID newSession() {
        return this.newSession(TimeUUIDType.instance.compose(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes())));
    }

    public UUID newSession(UUID sessionId) {
        assert (this.state.get() == null);
        TraceState ts = new TraceState(this.localAddress, sessionId);
        this.state.set(ts);
        return sessionId;
    }

    public void stopSession() {
        TraceState state = this.state.get();
        if (state == null) {
            logger.debug("request complete");
        } else {
            final long finished_at = System.currentTimeMillis();
            final ByteBuffer sessionIdBytes = state.sessionIdBytes;
            StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

                @Override
                public void runMayThrow() throws Exception {
                    ColumnFamily cf = ColumnFamily.create(CFMetaData.TraceSessionsCf);
                    Tracing.this.addColumn(cf, Tracing.buildName(CFMetaData.TraceSessionsCf, ByteBufferUtil.bytes("finished_at")), LongType.instance.decompose(finished_at));
                    RowMutation mutation = new RowMutation(Tracing.TRACE_KS, sessionIdBytes);
                    mutation.add(cf);
                    StorageProxy.mutate(Arrays.asList(mutation), ConsistencyLevel.ANY);
                }
            });
            this.reset();
        }
    }

    public TraceState get() {
        return this.state.get();
    }

    public void set(TraceState tls) {
        this.state.set(tls);
    }

    public void begin(final String request, final Map<String, String> parameters) {
        assert (Tracing.isTracing());
        final long started_at = System.currentTimeMillis();
        final ByteBuffer sessionIdBytes = this.state.get().sessionIdBytes;
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                ColumnFamily cf = ColumnFamily.create(CFMetaData.TraceSessionsCf);
                Tracing.this.addColumn(cf, Tracing.buildName(CFMetaData.TraceSessionsCf, ByteBufferUtil.bytes("coordinator")), InetAddressType.instance.decompose(FBUtilities.getBroadcastAddress()));
                Tracing.this.addColumn(cf, Tracing.buildName(CFMetaData.TraceSessionsCf, ByteBufferUtil.bytes("request")), UTF8Type.instance.decompose(request));
                Tracing.this.addColumn(cf, Tracing.buildName(CFMetaData.TraceSessionsCf, ByteBufferUtil.bytes("started_at")), LongType.instance.decompose(started_at));
                Tracing.this.addParameterColumns(cf, parameters);
                RowMutation mutation = new RowMutation(Tracing.TRACE_KS, sessionIdBytes);
                mutation.add(cf);
                StorageProxy.mutate(Arrays.asList(mutation), ConsistencyLevel.ANY);
            }
        });
    }

    public void initializeFromMessage(MessageIn<?> message) {
        byte[] sessionBytes = message.parameters.get(TRACE_HEADER);
        if (sessionBytes == null) {
            this.state.set(null);
            return;
        }
        Preconditions.checkState((sessionBytes.length == 16 ? 1 : 0) != 0);
        this.state.set(new TraceState(message.from, UUIDGen.getUUID(ByteBuffer.wrap(sessionBytes))));
    }
}

